class EMHTMale2Bot extends TMale2Bot;

function eAttitude AttitudeTo(Pawn Other)
{
	local byte result;

	if( Level.Game.IsA('MonsterHunt') )
	{
		if(
			Other.IsA('PlayerPawn')
			|| Other.IsA('Bot')
			|| Other.IsA('Nali')
			|| Other.IsA('Cow')
		)
		{
			return ATTITUDE_Friendly;
		}
		else
		{
			return ATTITUDE_Hate;
		}
	}

	if ( Level.Game.IsA('DeathMatchPlus') )
	{
		result = DeathMatchPlus(Level.Game).AssessBotAttitude(self, Other);
		Switch (result)
		{
			case 0: return ATTITUDE_Fear;
			case 1: return ATTITUDE_Hate;
			case 2: return ATTITUDE_Ignore;
			case 3: return ATTITUDE_Friendly;
		}
	}

	if ( Level.Game.bTeamGame && (PlayerReplicationInfo.Team == Other.PlayerReplicationInfo.Team) )
		return ATTITUDE_Friendly; //teammate

	return ATTITUDE_Hate;
}

defaultproperties
{
     CarcassType=Class'Botpack.TMale2Carcass'
     LandGrunt=Sound'Botpack.MaleSounds.(All).land10'
     FaceSkin=3
     FixedSkin=2
     TeamSkin2=1
     DefaultSkinName="SoldierSkins.blkt"
     DefaultPackage="SoldierSkins."
     SelectionMesh="Botpack.SelectionMale2"
     MenuName="Male Soldier"
     Mesh=LodMesh'Botpack.Soldier'
}
