class EMHTMale1Bot extends TMale1Bot;

function eAttitude AttitudeTo(Pawn Other)
{
	local byte result;

	if( Level.Game.IsA('MonsterHunt') )
	{
		if(
			Other.IsA('PlayerPawn')
			|| Other.IsA('Bot')
			|| Other.IsA('Nali')
			|| Other.IsA('Cow')
		)
		{
			return ATTITUDE_Friendly;
		}
		else
		{
			return ATTITUDE_Hate;
		}
	}

	if ( Level.Game.IsA('DeathMatchPlus') )
	{
		result = DeathMatchPlus(Level.Game).AssessBotAttitude(self, Other);
		Switch (result)
		{
			case 0: return ATTITUDE_Fear;
			case 1: return ATTITUDE_Hate;
			case 2: return ATTITUDE_Ignore;
			case 3: return ATTITUDE_Friendly;
		}
	}

	if ( Level.Game.bTeamGame && (PlayerReplicationInfo.Team == Other.PlayerReplicationInfo.Team) )
		return ATTITUDE_Friendly; //teammate

	return ATTITUDE_Hate;
}

defaultproperties
{
     LandGrunt=Sound'UnrealShare.Male.MLand3'
     JumpSound=Sound'Botpack.Male.TMJump3'
     FaceSkin=1
     TeamSkin1=2
     TeamSkin2=3
     DefaultSkinName="CommandoSkins.cmdo"
     DefaultPackage="CommandoSkins."
     SelectionMesh="Botpack.SelectionMale1"
     MenuName="Male Commando"
     VoiceType="BotPack.VoiceMaleOne"
     Mesh=LodMesh'Botpack.Commando'
}
