// Smiling Monsters FPH Alarm
// By Ti-Lung 25/09/2007
// Version 1.3 (20070925)
// Created for the Smiling Monsters community
// http://www.smiling-monsters.com/community/

class SMoFPHAlarm expands Mutator
	config(SMoFPHAlarm);

// config variable
var config bool
	bDisable,
	bKick,
	bBan,
	bMessagePlayer,
	bUseOutsideLog,
	bLogAllFPH;
var config int
	FPHLimitNormal,
	FPHLimitInstaGib,
	NegativeScoreLimit,
	TeamKillLimit,
	NumFragVerify,
	MaxFPH;

// Internal variable
var bool bInitialized;
var int FPHLimit;
var int SuicideCount[32], TeamKillCount[32];
var float FPHDelta;
var FPHAlarmLog LogClass;

function PreBeginPlay()
{
	local Mutator M;

	Super.PreBeginPlay();

	if ( bInitialized )
		return;

	bInitialized = True;
	Log("Mutator initialized.",'SMoFPHAlarm');

	if( Level.netMode != NM_DedicatedServer )
	{
		log("This mutator will only function on a dedicated server",'SMoFPHAlarm');
	}

	if( Level.netMode != NM_DedicatedServer || bDisable )
	{
		log("Mutator destroy",'SMoFPHAlarm');
		Self.Destroy(); // mutator not necessary so destroy
	}

	// Verify if InstagibDM or SniperArena mutator
	for( M = Level.Game.BaseMutator; M != None; M = M.NextMutator )
	{
		if(
			M.class == class'Botpack.InstaGibDM'
			|| M.class == class'Botpack.SniperArena'
		)
		{
			FPHLimit = FPHLimitInstaGib; // Set instagib fphlimit
			break;
		}
	}

	if( FPHLimit == 0 )
		FPHLimit = FPHLimitNormal;
}

function PostBeginPlay()
{
	super.PostBeginPlay();

	// Spawn log class
	LogClass = Spawn( class'FPHAlarmLog' );

	// Start log
	if ( LogClass != none )
	{
		LogClass.StartLog();
		Log("Start outside log",'SMoFPHAlarm');
	}
}

// UT call to scorekill function when player get a frag
function ScoreKill( Pawn Killer, Pawn Other )
{
	local bool bFPH, bSuicide, bTeamKill;
	local int KillerScore, PID;
	local float PlayerTime, PlayerJoinTime, GameTime, FPH;
	local string IP, ClientMessage, Playername, MapName;

	Super.ScoreKill( Killer, Other );

	// Verify that killer exist to stop accessed none
	if( Killer != none )
	{
		if( Killer.IsA('PlayerPawn') && Killer.PlayerReplicationInfo != none )
		{
			KillerScore = Killer.PlayerReplicationInfo.Score;

			// Calculate time that player is in match
			PlayerTime =
				Level.TimeSeconds
				- Killer.PlayerReplicationInfo.StartTime;

			// Calculate gametime if game use remainintime or elapsedtime
			if( Level.Game.GameReplicationInfo.RemainingTime > 0 )
			{
				GameTime =
					( TournamentGameReplicationInfo(Level.Game.GameReplicationInfo).TimeLimit*60 )
					- Level.Game.GameReplicationInfo.RemainingTime;
			}
			else
			{
				GameTime = Level.Game.GameReplicationInfo.ElapsedTime;
			}

			if( KillerScore	>= NumFragVerify )
			{
				// Calculate frag per hour
				// The value is lower than fph in f1 because time is float and not int
				FPH = ( KillerScore / PlayerTime ) * 3600;

				// Remove comment to see fph in message
				// Killer.ClientMessage("FPH"@FPH);

				if( FPH > MaxFPH )
				{
					MaxFPH = FPH;
					log("New MaxFPH"@MaxFPH);
					SaveConfig(); // Save config variable to ini file
				}

				// FPH verify
				if( ( FPH >= FPHLimit ) || bLogAllFPH )
				{
					if( bUseOutsideLog )
					{
						OutsideLog("Server time"@GetShortAbsoluteTime());
						if( !bLogAllFPH )
							OutsideLog("Exceed FPH Limit");
						OutsideLog("PlayerFPH"@FPH);
					}
					else
					{
						log("Server time"@GetShortAbsoluteTime(),'SMoFPHAlarm');
						if( !bLogAllFPH )
							log("Exceed FPH Limit",'SMoFPHAlarm');
						log("PlayerFPH"@FPH);
					}

					bFPH = true;
				}
			}

			/* Team DeathMatch */

			if(
				Level.Game.IsA('TeamGamePlus')
				// Assault, CTFGame, Domination are child of TeamGamePlus
				&& !ClassIsChildOf(Level.Game.Class,class'Botpack.TeamGamePlus')
			)
			{
				// Get PlayerID of killer pawn
				PID = PawnToPlayerID( Killer );

				// Suicide
				// Does not detect console suicide
				if( KillerScore <= 0 )
				{
					if( Killer == Other )
					{
						SuicideCount[ PID ] += 1;

						if( SuicideCount[ PID ] >= -NegativeScoreLimit )
						{
							if( bUseOutsideLog )
							{
								OutsideLog("Server time"@GetShortAbsoluteTime());
								OutsideLog("Exceed Suicide Limit"@SuicideCount[ PID ]);
							}
							else
							{
								log("Server time"@GetShortAbsoluteTime(),'SMoFPHAlarm');
								log("Exceed Suicide Limit"@SuicideCount[ PID ],'SMoFPHAlarm');
							}

							bSuicide = true;
						}
					}
				}

				// Team kill
				if(
					Killer.PlayerReplicationInfo.Team
					== Other.PlayerReplicationInfo.Team
				)
				{
					TeamKillCount[ PID ] += 1;

					if( TeamKillCount[ PID ] >= TeamKillLimit )
					{
						if( bUseOutsideLog )
						{
							OutsideLog("Server time"@GetShortAbsoluteTime());
							OutsideLog("Exceed TeamKill Limit"@TeamKillCount[ PID ]);
						}
						else
						{
							log("Server time"@GetShortAbsoluteTime(),'SMoFPHAlarm');
							log("Exceed TeamKill Limit"@TeamKillCount[ PID ],'SMoFPHAlarm');
						}
					}
				}
			}

			// Log player information and kick/ban
			if( bFPH || bSuicide || bTeamKill || bLogAllFPH )
			{
				// Name of map
				MapName = left(
					Level.Game.GameReplicationInfo,
					Instr( Level.Game.GameReplicationInfo, "." )
					);

				// Get network address and remove ":" plus port number
				IP = left(
					PlayerPawn( Killer ).GetPlayerNetworkAddress(),
					Instr( PlayerPawn( Killer ).GetPlayerNetworkAddress(), ":" )
					);

				Playername = Killer.PlayerReplicationInfo.PlayerName;

				if( bUseOutsideLog )
				{
					OutsideLog("MapName"@MapName);
					OutsideLog("PlayerName"@PlayerName);
					OutsideLog("PlayerID"@Killer.PlayerReplicationInfo.PlayerID);
					OutsideLog("PlayerIP"@IP);
					OutsideLog("PlayerTime"@PlayerTime);
					OutsideLog("GameTime"@GameTime);
				}
				else
				{
					log("MapName"@MapName,'SMoFPHAlarm');
					log("PlayerName"@PlayerName,'SMoFPHAlarm');
					log("PlayerID"@Killer.PlayerReplicationInfo.PlayerID,'SMoFPHAlarm');
					log("PlayerIP"@IP,'SMoFPHAlarm');
					log("PlayerTime"@PlayerTime,'SMoFPHAlarm');
					log("GameTime"@GameTime,'SMoFPHAlarm');
				}

				// Kick player
				if( bKick )
				{
					log("Kick:"@Killer.PlayerReplicationInfo.PlayerName,'SMoFPHAlarm');

					// Set string for client message
					if( bFPH )
						ClientMessage = "Exceed FPH Limit on server";
					if( bSuicide )
						ClientMessage = "Exceed Suicide Limit on server";
					if( bTeamKill )
						ClientMessage = "Exceed Teamkill Limit on server";

					if( bMessagePlayer )
					{
						Killer.ClientMessage( "Kick:" @ ClientMessage );
					}

					Killer.Destroy(); // Destroy Pawn and disconnect player

					// Reset player counter for new player
					SuicideCount[ PID ] = 0;
					TeamKillCount[ PID ] = 0;
				}

				if( bBan )
				{
					log("Ban:"@Killer.PlayerReplicationInfo.PlayerName,'SMoFPHAlarm');
					BanIP( IP ); // Ban player
				}
			}
		}
	}
}

// This handle end of log when match end
// Global variable: LogClass (class FPHAlarmLog)
function bool HandleEndGame()
{
	// Super.HandleEndGame();

	if ( LogClass != none )
	{
		// Stop log
		LogClass.StopLog();
		LogClass.Destroy(); // Destroy log
		LogClass = None; // Reset pointer to logclass
	}
}

/* Custom function */

// Return playerid of a pawn
function int PawnToPlayerID( Pawn aPawn )
{
	local Pawn P;

	P = Level.PawnList;

	while ( P != none )
	{
		if( P.IsA('PlayerPawn') || P.IsA('Bot') )
		{
			if( P == aPawn )
				return P.PlayerReplicationInfo.PlayerID;
		}

		P = P.nextPawn;
	}

	return -1; // Should not happen
}

// Ban function from HiddenAdmin
function bool BanIP( string IPString )
{
	local int i;

	if ( Level.Game.CheckIPPolicy( IPString ) )
	{
		for (i=0; i<50; i++)
		{
			if ( Level.Game.IPPolicies[i] == "" )
			{
				break; // exit iterator
			}
		}

		if (i<50)
		{
			Level.Game.IPPolicies[i] = "DENY,"$IPString;
			Level.Game.SaveConfig();
			return true;
		}
	}

	return false;
}

// Log to outside file
// global variable: LogClass (class FPHAlarmLog)
function OutsideLog( string aString )
{
	local Pawn P;

	if( LogClass != none )
	{
		LogClass.LogEventString( aString );
		LogClass.FileFlush();
	}

	Log( aString ); // Log to server ini also
}

// Server time from StatLog
function string GetShortAbsoluteTime()
{
	local string AbsoluteTime;

	AbsoluteTime = string(Level.Year);

	if (Level.Month < 10)
		AbsoluteTime = AbsoluteTime$".0"$Level.Month;
	else
		AbsoluteTime = AbsoluteTime$"."$Level.Month;

	if (Level.Day < 10)
		AbsoluteTime = AbsoluteTime$".0"$Level.Day;
	else
		AbsoluteTime = AbsoluteTime$"."$Level.Day;

	if (Level.Hour < 10)
		AbsoluteTime = AbsoluteTime$".0"$Level.Hour;
	else
		AbsoluteTime = AbsoluteTime$"."$Level.Hour;

	if (Level.Minute < 10)
		AbsoluteTime = AbsoluteTime$".0"$Level.Minute;
	else
		AbsoluteTime = AbsoluteTime$"."$Level.Minute;

	if (Level.Second < 10)
		AbsoluteTime = AbsoluteTime$".0"$Level.Second;
	else
		AbsoluteTime = AbsoluteTime$"."$Level.Second;

	return AbsoluteTime;
}

// Close log when mutator destroy
event Destroyed()
{
	Super.Destroyed();

	if ( LogClass != None)
	{
		LogClass.StopLog();
		LogClass.Destroy();
		LogClass = None;
	}
}

defaultproperties
{
	bBan=False
	bDisable=False
	bKick=False
	bLogAllFPH=False
	bUseOutsideLog=True
	FPHLimitNormal=550
	FPHLimitInstaGib=1900
	NegativeScoreLimit=-10
	NumFragVerify=10
	MaxFPH=0
	TeamKillLimit=10
}
