class MapVoteReport extends Info;

var string ReportText;
var int x;
var MapVoteWRI MVWRI;
var bool bSendResults;
var MapVoteHistory History;

function RunRport(string ReportType, PlayerPawn Sender,class<MapVoteHistory> MapVoteHistoryClass)
{
   // Find the requestors WRI
   foreach AllActors(class'x3dfxMapVotev23.MapVoteWRI',MVWRI)
   {
      if(Sender == MVWRI.Owner)
         break;
   }
   if(MVWRI == none)
   {
      log("Failed to find MVWRI",'x3dfxMapVote');
      Destroy();
      return;
   }

   // change report area to show "Please Wait......."
   MVWRI.SendReportText("<html><body bgcolor=#000000><br><br><br><center><b>Please Wait.....</b></center></body></html>");
   MVWRI.SendReportText("");

   if ( MapVoteHistoryClass != None )
   {
   	History = spawn(MapVoteHistoryClass);
   	if(History == none)
   	{
     		log("Failed to spawn MapVoteHistory",'x3dfxMapVote');
      		Destroy();
      		return;
   	}
   }
   History.MapReport(ReportType,self);
}

function tick(float DeltaTime)
{
   if(bSendResults)
   {
      if(MVWRI == None)  // just incase the user gets tired of waiting
      {
         History.Destroy();
         Destroy();
         return;
      }
      if(x > len(ReportText))
      {
         MVWRI.SendReportText("");
         bSendResults = false;
         History.Destroy();
         Destroy();
      }
      else
      {
         MVWRI.SendReportText(Mid(ReportText,x,250));
         x = x + 250;
         if(x < len(ReportText))
         {
            MVWRI.SendReportText(Mid(ReportText,x,250));
            x = x + 250;
         }
      }
   }
}
