class MapVoteClientWindow expands UWindowPageWindow;

var MapVoteListBox MapListBox;
var UWindowSmallButton CloseButton;
var UWindowSmallButton VoteButton;
var UWindowSmallButton InfoButton;
var PlayerVoteListBox PlayerListBox;
var UWindowSmallButton KickVoteButton;
var MapStatusListBox lstMapStatus;
var KickStatusListBox lstKickStatus;
var UWindowCheckBox   cbLoadScreenShot;
var UMenuLabelControl lblStatusTitles;
var UMenuLabelControl lblMapCount;
var UWindowEditControl txtFind;
var UWindowSmallButton SendButton;
var UWindowEditControl txtMessage;
var UMenuLabelControl lblMode;
var MapVoteWRI MVWRI;

var UWindowSmallButton btnVote1;
var UWindowSmallButton btnVote2;
var UWindowSmallButton btnVote3;
var UWindowSmallButton btnVote4;
var UWindowSmallButton btnVote5;
var UWindowSmallButton btnVote6;
var UWindowSmallButton btnVote7;
var UWindowSmallButton btnVote8;
var UMenuLabelControl lblNumVotes1;
var UMenuLabelControl lblNumVotes2;
var UMenuLabelControl lblNumVotes3;
var UMenuLabelControl lblNumVotes4;
var UMenuLabelControl lblNumVotes5;
var UMenuLabelControl lblNumVotes6;
var UMenuLabelControl lblNumVotes7;
var UMenuLabelControl lblNumVotes8;
var UMenuLabelControl lblTitleBar1;
var UMenuLabelControl lblTitleBar2;
var UMenuLabelControl lblTitleBar3;
var UMenuLabelControl lblTitleBar4;
var UMenuLabelControl lblTitleBar5;
var UMenuLabelControl lblTitleBar6;
var UMenuLabelControl lblTitleBar7;
var UMenuLabelControl lblTitleBar8;
var UMenuLabelControl lblTitleBar9;

var Texture Screenshot;
var string MapTitle;
var string MapAuthor;
var string IdealPlayerCount;
var float LastVoteTime;
var float SelectionTime;

var string OtherPreFix,MapPreFixOverRide,PreFixSwap;

function Created()
{
   local color TextColor;
   TextColor.R = 255;
   TextColor.G = 255;
   TextColor.B = 255;

   //MapCount = 1;

   Super.Created();

   MapListBox = MapVoteListBox(CreateControl(class'MapVoteListBox',10,10,130,110));
   MapListBox.Items.Clear();

   VoteButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton',50,120,40,20));
   VoteButton.DownSound = sound 'UnrealShare.BeltSnd';
   VoteButton.Text= "Vote";
   VoteButton.bDisabled = false;

   InfoButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton',360,120,40,15));
   InfoButton.Text= "Info";
   InfoButton.bDisabled = false;

   PlayerListBox = PlayerVoteListBox(CreateControl(class'PlayerVoteListBox',420,10,170,110));
   PlayerListBox.Items.Clear();

   KickVoteButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton',420,120,40,20));
   KickVoteButton.DownSound = sound 'UnrealShare.BeltSnd';
   KickVoteButton.Text= "Kick";
   KickVoteButton.bDisabled = true;

   lstMapStatus = MapStatusListBox(CreateControl(class'MapStatusListBox',10,150,200,130));
   lstMapStatus.bAcceptsFocus = False;
   lstMapStatus.Items.Clear();

   lstKickStatus = KickStatusListBox(CreateControl(class'KickStatusListBox',420,150,170,130));
   lstKickStatus.bAcceptsFocus = False;
   lstKickStatus.Items.Clear();

   cbLoadScreenShot = UWindowCheckBox(CreateControl(class'UWindowCheckBox', 150, 120, 70, 20));
   cbLoadScreenShot.SetText("ScreenShot");
   cbLoadScreenShot.Align = TA_Right;
   cbLoadScreenShot.SetFont(F_Normal);
   cbLoadScreenShot.SetTextColor(TextColor);
   cbLoadScreenShot.bChecked = class'x3dfxMapVotev23.x3dfxMapVote'.default.bLoadScreenShot;

   lblTitleBar1 = UMenuLabelControl(CreateControl(class'UMenuLabelControl', 310, 10, 150, 10));
   lblTitleBar1.SetText("x3dfxMapVote");
   lblTitleBar1.SetFont(F_Normal);
   lblTitleBar1.SetTextColor(TextColor);

   lblTitleBar2 = UMenuLabelControl(CreateControl(class'UMenuLabelControl', 275, 20, 150, 10));
   lblTitleBar2.SetText("[x3dfx] Community Gaming");
   lblTitleBar2.SetFont(F_Normal);
   lblTitleBar2.SetTextColor(TextColor);

   lblTitleBar3 = UMenuLabelControl(CreateControl(class'UMenuLabelControl', 275, 40, 150, 10));
   lblTitleBar3.SetText("Please  don't  nag  BDB  if ");
   lblTitleBar3.SetFont(F_Normal);
   lblTitleBar3.SetTextColor(TextColor);

   lblTitleBar7 = UMenuLabelControl(CreateControl(class'UMenuLabelControl', 275, 50, 150, 10));
   lblTitleBar7.SetText("something is broken, just");
   lblTitleBar7.SetFont(F_Normal);
   lblTitleBar7.SetTextColor(TextColor);

   lblTitleBar4 = UMenuLabelControl(CreateControl(class'UMenuLabelControl', 275, 60, 150, 10));
   lblTitleBar4.SetText("get over it.");
   lblTitleBar4.SetFont(F_Normal);
   lblTitleBar4.SetTextColor(TextColor);

   lblTitleBar5 = UMenuLabelControl(CreateControl(class'UMenuLabelControl', 275, 80, 150, 10));
   lblTitleBar5.SetText("This version allows switching ");
   lblTitleBar5.SetFont(F_Normal);
   lblTitleBar5.SetTextColor(TextColor);

   lblTitleBar6 = UMenuLabelControl(CreateControl(class'UMenuLabelControl', 275, 90, 150, 10));
   lblTitleBar6.SetText("between Instagib and Normal ");
   lblTitleBar6.SetFont(F_Normal);
   lblTitleBar6.SetTextColor(TextColor);

   lblTitleBar8 = UMenuLabelControl(CreateControl(class'UMenuLabelControl', 275, 100, 150, 10));
   lblTitleBar8.SetText("Weapons,  and  other  Game ");
   lblTitleBar8.SetFont(F_Normal);
   lblTitleBar8.SetTextColor(TextColor);

   lblTitleBar9 = UMenuLabelControl(CreateControl(class'UMenuLabelControl', 275, 110, 160, 10));
   lblTitleBar9.SetText("Modes.   Enjoy.");
   lblTitleBar9.SetFont(F_Normal);
   lblTitleBar9.SetTextColor(TextColor);

   lblStatusTitles = UMenuLabelControl(CreateControl(Class'UMenuLabelControl',10, 140, 590, 10));
   lblStatusTitles.SetText("Rank Map Name                              Votes                                                                          Player Name                         Votes");
   lblStatusTitles.SetFont(F_Normal);
   lblStatusTitles.SetTextColor(TextColor);

   lblMapCount = UMenuLabelControl(CreateControl(class'UMenuLabelControl', 95, 120, 70, 10));
   lblMapCount.SetText("");
   lblMapCount.SetFont(F_Normal);
   lblMapCount.SetTextColor(TextColor);

   txtFind = UWindowEditControl(CreateControl(class'UWindowEditControl', -30, 120, 80, 10));
   txtFind.SetNumericOnly(false);
   txtFind.SetText("");

   txtMessage = UWindowEditControl(CreateControl(class'UWindowEditControl', -150, 285, 320, 10));
   txtMessage.SetText("");
   txtMessage.SetNumericOnly(false);
   txtMessage.SetHistory(true);
   txtMessage.SetMaxLength(150);

   SendButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton', 170, 285, 40, 10));
   SendButton.Text= "Send";
   SendButton.bDisabled = false;

   lblMode = UMenuLabelControl(CreateControl(class'UMenuLabelControl', 260, 290, 100, 20));
   lblMode.SetText("Mode:");
   lblMode.SetFont(F_Normal);
   lblMode.SetTextColor(TextColor);

   CloseButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton',560,285,40,20));
   CloseButton.DownSound = sound 'UnrealShare.WeaponPickup';
   CloseButton.Text= "Close";
   CloseButton.bDisabled = false;

   // bonehed316:  buttons for mode vote
   // Basic weapon ZP
   btnVote1 = UWindowSmallButton(CreateControl(class'UWindowSmallButton',230,150,130,20));
   btnVote1.DownSound = sound 'Botpack.Expl04';
   btnVote1.Text= "";
   btnVote1.bDisabled = false;

   // Basic weapon ZP statuslabel
   lblNumVotes1 = UMenuLabelControl(CreateControl(class'UMenuLabelControl', 365, 150, 60, 20));
   lblNumVotes1.SetText("0 votes");
   lblNumVotes1.SetFont(F_Normal);
   lblNumVotes1.SetTextColor(TextColor);

   // Dual color ZP isntagib
   btnVote2 = UWindowSmallButton(CreateControl(class'UWindowSmallButton',230,166,130,20));
   btnVote2.DownSound = sound 'UnrealShare.Gib4';
   btnVote2.Text= "";
   btnVote2.bDisabled = false;

   // Dual color ZP isntagib statuslabel
   lblNumVotes2 = UMenuLabelControl(CreateControl(class'UMenuLabelControl', 365, 166, 60, 20));
   lblNumVotes2.SetText("0 votes");
   lblNumVotes2.SetFont(F_Normal);
   lblNumVotes2.SetTextColor(TextColor);

   // ZP instagib
   btnVote3 = UWindowSmallButton(CreateControl(class'UWindowSmallButton',230,182,130,20));
   btnVote3.DownSound = sound 'UnrealShare.Gib1';
   btnVote3.Text= "";
   btnVote3.bDisabled = false;

   // ZP instagib statuslabel
   lblNumVotes3 = UMenuLabelControl(CreateControl(class'UMenuLabelControl', 365, 182, 60, 20));
   lblNumVotes3.SetText("0 votes");
   lblNumVotes3.SetFont(F_Normal);
   lblNumVotes3.SetTextColor(TextColor);

   // Enforcer Arena
   btnVote4 = UWindowSmallButton(CreateControl(class'UWindowSmallButton',230,198,130,20));
   btnVote4.DownSound = sound 'Botpack.Cocking';
   btnVote4.Text= "";
   btnVote4.bDisabled = false;

   // Enforcer Arena statuslabel
   lblNumVotes4 = UMenuLabelControl(CreateControl(class'UMenuLabelControl', 365, 198, 60, 20));
   lblNumVotes4.SetText("0 votes");
   lblNumVotes4.SetFont(F_Normal);
   lblNumVotes4.SetTextColor(TextColor);

   // Shock Arena
   btnVote5 = UWindowSmallButton(CreateControl(class'UWindowSmallButton',230,214,130,20));
   btnVote5.DownSound = sound 'Botpack.TazerAltFire';
   btnVote5.Text= "";
   btnVote5.bDisabled = false;

   // Shock Arena statuslabel
   lblNumVotes5 = UMenuLabelControl(CreateControl(class'UMenuLabelControl', 365, 214, 60, 20));
   lblNumVotes5.SetText("0 votes");
   lblNumVotes5.SetFont(F_Normal);
   lblNumVotes5.SetTextColor(TextColor);

   // Sniper Arena
   btnVote6 = UWindowSmallButton(CreateControl(class'UWindowSmallButton',230,230,130,20));
   btnVote6.DownSound = sound 'Botpack.SniperFire';
   btnVote6.Text= "";
   btnVote6.bDisabled = false;

   // Sniper Arena statuslabel
   lblNumVotes6 = UMenuLabelControl(CreateControl(class'UMenuLabelControl', 365, 230, 60, 20));
   lblNumVotes6.SetText("0 votes");
   lblNumVotes6.SetFont(F_Normal);
   lblNumVotes6.SetTextColor(TextColor);

   // Normal votebutton
   btnVote7 = UWindowSmallButton(CreateControl(class'UWindowSmallButton',230,246,130,20));
   btnVote7.DownSound = sound 'UnrealI.Shot1';
   btnVote7.Text= "";
   btnVote7.bDisabled = false;

   // NW statuslabel
   lblNumVotes7 = UMenuLabelControl(CreateControl(class'UMenuLabelControl', 365, 246, 60, 20));
   lblNumVotes7.SetText("0 votes");
   lblNumVotes7.SetFont(F_Normal);
   lblNumVotes7.SetTextColor(TextColor);

   // Instagib votebutton
   btnVote8 = UWindowSmallButton(CreateControl(class'UWindowSmallButton',230,262,130,20));
   btnVote8.DownSound = sound 'UnrealShare.TazerFire';
   btnVote8.Text= "";
   btnVote8.bDisabled = false;

   // Instagib statuslabel
   lblNumVotes8 = UMenuLabelControl(CreateControl(class'UMenuLabelControl', 365, 262, 60, 20));
   lblNumVotes8.SetText("0 votes");
   lblNumVotes8.SetFont(F_Normal);
   lblNumVotes8.SetTextColor(TextColor);

}

function Notify(UWindowDialogControl C, byte E)
{
   Super.Notify(C,E);

   switch(E)
   {
      case DE_Change:
         switch(C)
         {
            case txtFind:
               MapListBox.Find(txtFind.GetValue());
               break;
         }
         break;

      case DE_DoubleClick:
         switch(C)
         {
            case MapListBox:
               //log("DoubleClick MapListBox");
               if(GetPlayerOwner().Level.TimeSeconds > LastVoteTime + 3) // prevent spamming
               {
	               if(Left(UMenuMapVoteList(MapListBox.SelectedItem).MapName,3) != "[X]" || GetPlayerOwner().PlayerReplicationInfo.bAdmin)
		            {
                     GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE MAP "$UMenuMapVoteList(MapListBox.SelectedItem).MapName);
                     LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
		            }
               }
               SelectionTime = GetPlayerOwner().Level.TimeSeconds; // delays the selection to prevent laggy scolling due to screenshot loading
               break;

            case lstMapStatus:
               //log("DoubleClick lstMapStatus");
               MapListBox.SelectMap(MapStatusListItem(lstMapStatus.SelectedItem).MapName);
               if(GetPlayerOwner().Level.TimeSeconds > LastVoteTime + 3) // prevent spamming
               {
	          if(Left(UMenuMapVoteList(MapListBox.SelectedItem).MapName,3) != "[X]" || GetPlayerOwner().PlayerReplicationInfo.bAdmin)
		  {
                     GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE MAP "$UMenuMapVoteList(MapListBox.SelectedItem).MapName);
                     LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
		  }
               }
               SelectionTime = GetPlayerOwner().Level.TimeSeconds;
               break;

            case PlayerListBox:
               if(GetPlayerOwner().Level.TimeSeconds > LastVoteTime + 3)
               {
                  GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE KICK "$PlayerVoteListItem(PlayerListBox.SelectedItem).PlayerName);
                  LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
               }
               break;

            case lstKickStatus:
               PlayerListBox.SelectPlayer(KickStatusListItem(lstKickStatus.SelectedItem).PlayerName);
               if(GetPlayerOwner().Level.TimeSeconds > LastVoteTime + 3)
               {
                  GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE KICK X"$PlayerVoteListItem(PlayerListBox.SelectedItem).PlayerName);
                  LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
               }
               break;
         }
         break;

      case DE_Click:
         switch(C)
         {
            case SendButton:
               if(txtMessage.GetValue() != "")
               {
                  GetPlayerOwner().ConsoleCommand("SAY "$ txtMessage.GetValue());
                  txtMessage.SetValue("");
               }
               break;

            case VoteButton:
               if(GetPlayerOwner().Level.TimeSeconds > LastVoteTime + 3) // prevent spamming
               {
	          if(Left(UMenuMapVoteList(MapListBox.SelectedItem).MapName,3) != "[X]" || GetPlayerOwner().PlayerReplicationInfo.bAdmin)
		  {
                     if(UMenuMapVoteList(MapListBox.SelectedItem).MapName != "")
                        GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE MAP "$UMenuMapVoteList(MapListBox.SelectedItem).MapName);
                     LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
		  }
               }
               break;

            case InfoButton:
               if(MapListBox.SelectedItem != None)
               {
                  MapVoteTabWindow(ParentWindow.ParentWindow).InfoWindow.BrowseWebPage(MapVoteTabWindow(ParentWindow.ParentWindow).InfoWindow.MapInfoURL $ UMenuMapVoteList(MapListBox.SelectedItem).MapName $ ".htm");
                  MapVoteTabWindow(ParentWindow.ParentWindow).Pages.GotoTab(MapVoteTabWindow(ParentWindow.ParentWindow).Pages.GetPage("Info"), true);
               }
               break;

            case CloseButton:
               ParentWindow.ParentWindow.Close();
               break;

            case MapListBox:
               SelectionTime = GetPlayerOwner().Level.TimeSeconds; // delays the selection to prevent laggy scolling due to screenshot loading
               break;

            case lstMapStatus:
               MapListBox.SelectMap(MapStatusListItem(lstMapStatus.SelectedItem).MapName);
               SelectionTime = GetPlayerOwner().Level.TimeSeconds;
               break;

            case KickVoteButton:
               if(GetPlayerOwner().Level.TimeSeconds > LastVoteTime + 3) // prevent spamming
               {
                  GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE KICK "$PlayerVoteListItem(PlayerListBox.SelectedItem).PlayerName);
                  LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
               }
               break;

            case lstKickStatus:
               PlayerListBox.SelectPlayer(KickStatusListItem(lstKickStatus.SelectedItem).PlayerName);
               break;

	// bonehed316: Handler for vote buttons
            case btnVote1:
               if(GetPlayerOwner().Level.TimeSeconds > LastVoteTime + 1)
		{
			if (!btnVote1.bDisabled || GetPlayerOwner().PlayerReplicationInfo.bAdmin) // prevent spamming
               		{
                  		GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE 1");
                  		LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
               		}
			else
			{
				GetPlayerOwner().ClientMessage("Voting for this button is disabled!");
				LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
			}
		}
               break;

            // instagib
            case btnVote2:
               if(GetPlayerOwner().Level.TimeSeconds > LastVoteTime + 1)
		{
			if (!btnVote2.bDisabled || GetPlayerOwner().PlayerReplicationInfo.bAdmin) // prevent spamming
               		{
                  		GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE 2");
                  		LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
               		}
			else
			{
				GetPlayerOwner().ClientMessage("Voting for this button is disabled!");
				LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
			}
		}
               break;

            // ZP NW
            case btnVote3:
               if(GetPlayerOwner().Level.TimeSeconds > LastVoteTime + 1)
		{
			if (!btnVote3.bDisabled || GetPlayerOwner().PlayerReplicationInfo.bAdmin) // prevent spamming
               		{
                  		GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE 3");
                  		LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
               		}
			else
			{
				GetPlayerOwner().ClientMessage("Voting for this button is disabled!");
				LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
			}
		}
               break;

            // ZP Enforcer arena
            case btnVote4:
               if(GetPlayerOwner().Level.TimeSeconds > LastVoteTime + 1)
		{
			if (!btnVote4.bDisabled || GetPlayerOwner().PlayerReplicationInfo.bAdmin) // prevent spamming
               		{
                  		GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE 4");
                  		LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
               		}
			else
			{
				GetPlayerOwner().ClientMessage("Voting for this button is disabled!");
				LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
			}
		}
               break;

            // ZP shock arena
            case btnVote5:
               if(GetPlayerOwner().Level.TimeSeconds > LastVoteTime + 1)
		{
			if (!btnVote5.bDisabled || GetPlayerOwner().PlayerReplicationInfo.bAdmin) // prevent spamming
              		{
                 		GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE 5");
                  		LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
               		}
			else
			{
				GetPlayerOwner().ClientMessage("Voting for this button is disabled!");
				LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
			}
		}
               break;

            // ZP sniper arena
            case btnVote6:
               if(GetPlayerOwner().Level.TimeSeconds > LastVoteTime + 1)
		{
			if (!btnVote6.bDisabled || GetPlayerOwner().PlayerReplicationInfo.bAdmin) // prevent spamming
               		{
                 		 GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE 6");
                  		LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
               		}
			else
			{
				GetPlayerOwner().ClientMessage("Voting for this button is disabled!");
				LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
			}
		}
               break;

            // ZP instagib
            case btnVote7:
               if(GetPlayerOwner().Level.TimeSeconds > LastVoteTime + 1)
		{
			if (!btnVote7.bDisabled || GetPlayerOwner().PlayerReplicationInfo.bAdmin) // prevent spamming
               		{
                 		 GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE 7");
                  		LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
               		}
			else
			{
				GetPlayerOwner().ClientMessage("Voting for this button is disabled!");
				LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
			}
		}
               break;

            // ZP dual color instagib
            case btnVote8:
               if(GetPlayerOwner().Level.TimeSeconds > LastVoteTime + 1)
		{
			if (!btnVote8.bDisabled || GetPlayerOwner().PlayerReplicationInfo.bAdmin) // prevent spamming
               		{
                 		 GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE 8");
                  		LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
               		}
			else
			{
				GetPlayerOwner().ClientMessage("Voting for this button is disabled!");
				LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
			}
		}
               break;

         }
         break;

      case DE_EnterPressed:
         if(txtMessage.GetValue() != "")
         {
            GetPlayerOwner().ConsoleCommand("SAY "$ txtMessage.GetValue());
            txtMessage.SetValue("");
            txtMessage.FocusOtherWindow(SendButton);
         }
         break;
   }
}

function tick(float DeltaTime)
{
   if(SelectionTime != 0 && GetPlayerOwner().Level.TimeSeconds  > SelectionTime + 1)
   {
      SetMap(UMenuMapVoteList(MapListBox.SelectedItem).MapName);
      SelectionTime = 0;
   }
   super.tick(DeltaTime);
}

function SetMap(string MapName)
{
     local int i;
     local LevelSummary L;

     if(!cbLoadScreenShot.bChecked)
        return;

     i = InStr(Caps(MapName), ".UNR");
     if(i != -1)
          MapName = Left(MapName, i);

     if(PreFixSwap == "")  // no prefix swapping load as normal
     {
        if(Left(MapName,3) == "LMS" || Left(MapName,3) == "TDM")
	{
           Screenshot = Texture(DynamicLoadObject("DM" $ Mid(MapName,3) $ ".Screenshot", class'Texture'));
           L = LevelSummary(DynamicLoadObject("DM" $ Mid(MapName,3) $".LevelSummary", class'LevelSummary'));
	}
	else
	{
           Screenshot = Texture(DynamicLoadObject(MapName$".Screenshot", class'Texture'));
           L = LevelSummary(DynamicLoadObject(MapName$".LevelSummary", class'LevelSummary'));
	}
     }
     else
     {
        if(Left(MapName,Len(PreFixSwap)) == PreFixSwap) // this is a prefix swapped map
	{
           if(MapPreFixOverRide == "")  // Not Overridden map prefix, load default prefix
	   {
              Screenshot = Texture(DynamicLoadObject(OtherPreFix $ Mid(MapName,Len(PreFixSwap)) $ ".Screenshot", class'Texture'));
              L = LevelSummary(DynamicLoadObject(OtherPrefix $ Mid(MapName,Len(PreFixSwap)) $".LevelSummary", class'LevelSummary'));
	   }
	   else  // Overridden map prefix, load with Overridden map prefix
	   {
              Screenshot = Texture(DynamicLoadObject(MapPreFixOverRide $ Mid(MapName,Len(PreFixSwap)) $".Screenshot", class'Texture'));
              L = LevelSummary(DynamicLoadObject(MapPreFixOverRide $ Mid(MapName,Len(PreFixSwap)) $".LevelSummary", class'LevelSummary'));
	   }
        }
	else  // This is not a prefix swapped map , load as normal
	{
           if(Left(MapName,3) == "LMS" || Left(MapName,3) == "TDM")
	   {
              Screenshot = Texture(DynamicLoadObject("DM" $ Mid(MapName,3) $ ".Screenshot", class'Texture'));
              L = LevelSummary(DynamicLoadObject("DM" $ Mid(MapName,3) $".LevelSummary", class'LevelSummary'));
	   }
	   else
	   {
              Screenshot = Texture(DynamicLoadObject(MapName$".Screenshot", class'Texture'));
              L = LevelSummary(DynamicLoadObject(MapName$".LevelSummary", class'LevelSummary'));
	   }
	}
     }
     if(Left(MapName,3) == "[X]")
     {
        MapTitle = "You can NOT";
        MapAuthor = "vote for this map.";
        IdealPlayerCount = "";
     }
     else
     {
        if(L != None)
        {
           MapTitle = L.Title;
           MapAuthor = L.Author;
           IdealPlayerCount = L.IdealPlayerCount;
        }
        else
        {
           MapTitle = "DownLoad";
           MapAuthor = "Required";
           IdealPlayerCount = "";
        }
     }
}


function Paint(Canvas C, float MouseX, float MouseY)
{
     local int i,p1,p2,pos;
     local string TempText,TextLine;
     local float X, Y, W, H;

     Super.Paint(C,MouseX,MouseY);

     //DrawStretchedTexture(C, 145, 10, 120, 110, Texture'BlackTexture');

     DrawStretchedTexture(C, 0, 0, WinWidth, WinHeight, Texture'BlackTexture');

     if(Screenshot != None)
     {
          W = Min(100, Screenshot.USize);
          H = Min(100, Screenshot.VSize);
          if(W > H)
               W = H;
          if(H > W)
               H = W;
          C.DrawColor.R = 255;
          C.DrawColor.G = 255;
          C.DrawColor.B = 255;

          DrawStretchedTexture(C, 145, 10, 120, 110, Screenshot);
     }

     C.Font = Root.Fonts[F_Normal];

     if(IdealPlayerCount != "")
     {
        TextSize(C, IdealPlayerCount $ " Players", W, H);
        ClipText(C, 155, 110, IdealPlayerCount $ " Players");
     }

     if(MapAuthor != "")
     {
        TextSize(C, MapAuthor, W, H);
        ClipText(C, 155, 40, MapAuthor);
     }

     if(MapTitle != "")
     {
        TextSize(C, MapTitle, W, H);
        ClipText(C, 155, 20, MapTitle);
     }


     // Draw Status text
     C.DrawColor.R = 0;
     C.DrawColor.G = 0;
     C.DrawColor.B = 0;
     C.Font = Root.Fonts[F_Normal];
}

function KeyDown( int Key, float X, float Y )
{
   ParentWindow.KeyDown(Key,X,Y);
}


function Close(optional bool bByParent)
{
    local int w, Mode;

    class'x3dfxMapVotev23.x3dfxMapVote'.default.bLoadScreenShot = cbLoadScreenShot.bChecked;
    class'x3dfxMapVotev23.x3dfxMapVote'.static.StaticSaveConfig();
    Super.Close(bByParent);
}

defaultproperties
{
}
