class MVKeyBinderClientWindow expands UMenuDialogClientWindow config;

var string RealKeyName[255];
var MVKeyBinderListBox lstKeyList;
var UWindowSmallButton SaveButton;
var float CloseRequestTime;
var UMenuLabelControl lblMessage;
//var config bool bShowKeyBinder;
//var UWindowCheckBox cbShowKeyBinder;

function Created()
{
    local color c;
    local color TextColor;
    TextColor.R = 255;
    TextColor.G = 255;
    TextColor.B = 255;

    Super.Created();

    c.R = 0;
    c.G = 0;
    c.B = 128;

    lstKeyList = MVKeyBinderListBox(CreateControl(class'MVKeyBinderListBox',10,23,460,92));
    lstKeyList.bAcceptsFocus = False;
    lstKeyList.Items.Clear();

    SaveButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton',215,120,50,20));
    SaveButton.Text= "Set/Save";
    SaveButton.DownSound = sound 'UnrealShare.WeaponPickup';
    SaveButton.bDisabled = false;
    SaveButton.bAcceptsFocus = False;

    lblMessage = UMenuLabelControl(CreateControl(class'UMenuLabelControl', 10, 150, 460, 40));
    lblMessage.SetText("");
    lblMessage.SetFont(F_LargeBold);
    lblMessage.SetTextColor(TextColor);
    lblMessage.bAcceptsFocus = False;

    //cbShowKeyBinder = UWindowCheckBox(CreateControl(class'UWindowCheckBox', 280, 120, 150, 20));
    ////cbShowKeyBinder.Align = TA_right;
    //cbShowKeyBinder.SetText("Show Key Binder on Startup");
    //cbShowKeyBinder.SetSize(150, 1);
    ////cbShowKeyBinder.SetFont(F_Normal);
    //cbShowKeyBinder.SetTextColor(TextColor);
    //cbShowKeyBinder.bChecked = class'x3dfxMapVotev23.MVKeyBinderClientWindow'.default.bShowKeyBinder;
    //cbShowKeyBinder.bAcceptsFocus = False;

    SetAcceptsFocus();
    LoadExistingKeys();
}

function KeyDown( int Key, float X, float Y )
{
   local int i;
   local KeyBinderListItem KeyItem;

   for( KeyItem=KeyBinderListItem(lstKeyList.Items); KeyItem!=None; KeyItem=KeyBinderListItem(KeyItem.Next) )
   {
      if(RealKeyName[Key] == KeyItem.KeyName)
      {
         lstKeyList.SetSelectedItem(KeyItem);
         lstKeyList.MakeSelectedVisible();
         break;
      }
   }
}

function LoadExistingKeys()
{
     local int I;
     local string KeyName;
     local string Alias;
     local KeyBinderListItem A;
     local bool bFound;

     for (I=0; I<255; I++)
     {
        A = KeyBinderListItem(lstKeyList.Items.Append(class'KeyBinderListItem'));
        KeyName = GetPlayerOwner().ConsoleCommand( "KEYNAME "$i );
        A.KeyName = KeyName;
        RealKeyName[i] = KeyName;
        if ( KeyName != "" )
        {
           Alias = GetPlayerOwner().ConsoleCommand( "KEYBINDING "$KeyName );
           A.CommandString = Alias;
           if(Caps(Alias) == "MUTATE BDBMAPVOTE VOTEMENU")
           {
              lstKeyList.SetSelectedItem(A);
              lstKeyList.MakeSelectedVisible();
              CloseRequestTime = GetPlayerOwner().Level.TimeSeconds;
              lblMessage.SetText("Your MapVote Hot Key is " $ KeyName);
              bFound = true;
           }
        }
     }
     if(!bFound)
       lblMessage.SetText("Press/Select a Desired MapVote Hot Key");
}

//function Close(bool bByParent)
//{
//   class'x3dfxMapVotev23.MVKeyBinderClientWindow'.default.bShowKeyBinder = cbShowKeyBinder.bChecked;
//   class'x3dfxMapVotev23.MVKeyBinderClientWindow'.static.StaticSaveConfig();
//   Super.Close(bByParent);
//}

//function tick(float DeltaTime)
//{
//   if(CloseRequestTime > 0 && GetPlayerOwner().Level.TimeSeconds  > CloseRequestTime + 4)
//      ParentWindow.Close();
//   super.tick(DeltaTime);
//}

function Notify(UWindowDialogControl C, byte E)
{
    local string CommandString;
    super.Notify(C, E);
     switch(E)
     {
     case DE_Click:
         switch(C)
         {
            case SaveButton:
                 SaveKeyBind();
                 break;
          }
          break;
     }
}


function SaveKeyBind()
{
   local string CommandString;

   SetKey(KeyBinderListItem(lstKeyList.SelectedItem).KeyName,"MUTATE BDBMAPVOTE VOTEMENU");
   ParentWindow.Close();
}

function SetKey(string KeyName,string CommandString)
{
   GetPlayerOwner().ConsoleCommand("SET Input "$KeyName$" "$CommandString);
   KeyBinderListItem(lstKeyList.SelectedItem).CommandString = CommandString;
}

function Paint(Canvas C, float MouseX, float MouseY)
{
     C.DrawColor.R = 0;
     C.DrawColor.G = 0;
     C.DrawColor.B = 0;
     DrawStretchedTexture(C, 0, 0, WinWidth, WinHeight, Texture'UWindow.WhiteTexture');

     Super.Paint(C,MouseX,MouseY);

     C.DrawColor.R = 255;
     C.DrawColor.G = 255;
     C.DrawColor.B = 255;
     DrawStretchedTexture(C, 10, 10, 460, 13, Texture'UWindow.WhiteTexture');
     C.DrawColor.R = 0;
     C.DrawColor.G = 0;
     C.DrawColor.B = 0;
     C.Font = Root.Fonts[F_Normal];
     ClipText(C, 15, 11, "Keyboard Key");
     ClipText(C, 115, 11, "Console Commands");
     DrawStretchedTexture(C, 105 , 10, 1, 13, Texture'UWindow.WhiteTexture');
}

//defaultproperties
//{
//   bShowKeyBinder=True
//}
