//-----------------------------------------------------------
// MapVote Mutator
// By BDB (Bruce Bickar)
//-----------------------------------------------------------
class x3dfxMapVote expands Mutator config(x3dfxMapVote);

var bool   bInitialized;
var string MapList[1024];        // list of all the maps available on the server
var int    PlayerIDList[32];    // list of player IDs, used for looking up the players index number
var int    PlayerVote[32];      // index of the map that the player has voted for
var int    MapCount;            // total number of maps on server
var int    PlayerKickVote[32];  // list of kick votes per player
var string MapStatusText[100];
var string KickStatusText[100];
var string KickIPList[50];      // list of player IP addresses to kick
var float  EndGameTime;
var bool   bMidGameVote;
var int    CurrentID;
var int    JoinTickCount;       // number of ticks after player join

   // Bonehed316: for mode vote
var string extra;

var int PlayerModeVote[32];
var int NumVotes1,NumVotes2,NumVotes3,NumVotes4,
	NumVotes5,NumVotes6,NumVotes7,NumVotes8;

var config int CurGameMode;
var config bool bAllowButton1;
var config bool bAllowButton2;
var config bool bAllowButton3;
var config bool bAllowButton4;
var config bool bAllowButton5;
var config bool bAllowButton6;
var config bool bAllowButton7;
var config bool bAllowButton8;
var config bool bEnableAll;
var config bool bDisableAll;
var config bool bShowVoterNames;
var config bool b20SecOpenVoteWindow;
var config int MinPlayersForTeamGames;

var config bool bAutoDetect;
var config bool bDM;
var config bool bLMS;
var config bool bTDM;
var config bool bDOM;
var config bool bCTF;
var config bool bAS;
var config bool bOther;
var config string OtherClass;
var config string ExtraMutators;
var config string ExtraMutators1;
var config string ExtraMutators2;
var config string ExtraMutators3;
var config string ExtraMutators4;
var config string ExtraMutators5;
var config string ExtraMutators6;
var config string ExtraMutators7;
var config string ExtraMutators8;
var config string ButtonName1;
var config string ButtonName2;
var config string ButtonName3;
var config string ButtonName4;
var config string ButtonName5;
var config string ButtonName6;
var config string ButtonName7;
var config string ButtonName8;
var config string MapPreFixOverRide; // tell it to load maps with this prefix instead of default
var config string PreFixSwap;        // map name prefix to change too
var config bool bSortWithPreFix;     // set false to ingnore prefix when sorting maps
var config int VoteTimeLimit;
var config int KickPercent;
var config bool bUseMapList;
var config int ScoreBoardDelay;
var config bool bAutoOpen;
var config bool bKickVote;
var config bool bCheckOtherGameTie;
var config int RepeatLimit;
var config string MapVoteHistoryType;
var config string ServerInfoURL;    //www.planetunreal.com:80/BDBUnreal/ServerInfo.htm
var config string MapInfoURL;       //www.planetunreal.com:80/BDBUnreal/MapInfo/
var config int MidGameVotePercent;
var config string Mode;
var config int MinMapCount;
var config string HasStartWindow; // Yes,No,Auto - Does the game have a start menu
var config bool bEntryWindows; // false = Dont open Welcome window or Keybinder when player enters
var config bool bDebugMode;     // debug mode will log extra data to log
var config string AccName[32];  // use for Accumulation mode
var config int    AccVotes[32]; // use for Accumulation mode
//bonehed316:  used for acc mode votes
var config int    AccModeVotes[32];  //use for accumulation mode

// client side settings
var config int MsgTimeOut;
var config bool bLoadScreenShot;

var int TimeLeft,ScoreBoardTime,ServerTravelTime;
var class<GameInfo> OtherGameClass;

var config string DMGameType;
var config string LMSGameType;
var config string TDMGameType;
var config string DOMGameType;
var config string CTFGameType;
var config string ASGameType;
var class<GameInfo> DMGameClass;
var class<GameInfo> LMSGameClass;
var class<GameInfo> TDMGameClass;
var class<GameInfo> DOMGameClass;
var class<GameInfo> CTFGameClass;
var class<GameInfo> ASGameClass;
var class<MapVoteHistory> MapVoteHistoryClass;
var bool bLevelSwitchPending;
var string ServerTravelString;
var int MarkedMapCount; // total number of maps that have not been elimitated.

//************************************************************************************************
function bool HandleEndGame()
{
   local Pawn aPawn;
   local bool bReturn;

   DebugLog("1");

	Super.HandleEndGame(); // pass along call to other mutators

   bReturn = false;

   if(!bAutoOpen || CheckForTie()) // Don't open voting windows for tied game or if disabled
   {
      DebugLog("2");
      return false;
   }

   // Do not mess with Assult games in mid game
   if(Level.Game.IsA('Assault'))
   {
      DebugLog("4");
      //log("Playing Assault, Check bDefense");
      if( !Assault(Level.Game).bDefenseSet )
      {
	 //log("bDefenseSet == False, Ending game normally.(First half end)");
	 return false;
      }
      else
      {
	 //log("bDefense == True, calling ResetGame.(Second half end)");
	 Assault(Level.Game).ResetGame();  // resets assault ini settings so next game starts on first half of game instead of second
      }
   }

   DebugLog("5");
   // Setting bDontRestart will give players time to vote
   DeathMatchPlus(Level.Game).bDontRestart = true;

   // Start voting count-down timer
   TimeLeft = VoteTimeLimit;
   ScoreBoardTime = ScoreBoardDelay;
   settimer(1,true);

   return bReturn;
}
//************************************************************************************************
event timer()
{
   local pawn aPawn;
   local int VoterNum,NoVoteCount, NoModeVoteCount,mapnum;
   local MapVoteWRI A;
   local Pawn P;

   if(bLevelSwitchPending)
   {
      DebugLog("6");
      if(Level.TimeSeconds > ServerTravelTime + 3) // Give a little extra time for windows to close
      {
	 DebugLog("NextURL = " $ Level.NextURL);
	      Debuglog("NextSwitchCountdown = " $ Level.NextSwitchCountdown);

	 if( Level.NextURL == "" )
	      {
	    DebugLog("7");

	         if(Level.NextSwitchCountdown < 0)  // if negative then level switch failed
	         {
	            Log("Map change Failed, bad or missing map file.",'x3dfxMapVote');
	            mapnum = Rand(MapCount) + 1;

	            while(Left(MapList[mapnum],3) == "[X]")  // don't allow elimiated maps
		  mapnum = Rand(MapCount) + 1;         // select a different map

	       ServerTravelString = SetupGameMap(MapList[mapnum]);
	       Level.ServerTravel(ServerTravelString, false);    // change the map
	         }
	         else
	       Level.ServerTravel(ServerTravelString, false);    // change the map
	      }
		//bonehed316:  	something may need to be added here to keep the
		//		mutators loaded, but it may use the ones added
		//		by the command line, or by the server itself, and
		//      	so far it works okay.
      }
      return;
   }

   if(ScoreBoardTime > 0)
   {
      DebugLog("8");
      ScoreBoardTime--;
      if(ScoreBoardTime == 0)
      {
	 DebugLog("9");
	 EndGameTime = Level.TimeSeconds;

	 // force all players voting window open
	 for( aPawn=Level.PawnList; aPawn!=None; aPawn=aPawn.NextPawn )
	 {
	    if(PlayerPawn(aPawn) != none && aPawn.bIsPlayer)
	    {
	       VoterNum = FindPlayerIndex(PlayerPawn(aPawn).PlayerReplicationInfo.PlayerID);
					if(VoterNum > -1)
		  if(PlayerVote[VoterNum] == 0 || (PlayerModeVote[VoterNum] == 0 && !bDisableAll)) // if this player has not voted
		     OpenVoteWindow(PlayerPawn(aPawn));
	    }
	 }

	 BroadcastMessage(String(TimeLeft) $" seconds left to vote.", true);
      }
      return;
   }
   TimeLeft--;

   //log(TimeLeft);
   if(TimeLeft == 60)  // play announcer voice for 1 minute warning
   {
      DebugLog("10");
      BroadcastMessage("1 Minute left to vote.", true);
      for( P = Level.PawnList; P!=None; P=P.nextPawn )
	 if( P.IsA('TournamentPlayer') )
	   TournamentPlayer(P).TimeMessage(12);
   }

   if(TimeLeft == 10)
   {
      DebugLog("11");
      BroadcastMessage("10 seconds left to vote.", true);
   }

   if(TimeLeft < 11 && TimeLeft > 0 )  // play announcer voice Count Down
   {
      for( P = Level.PawnList; P!=None; P=P.nextPawn )
	 if( P.IsA('TournamentPlayer') )
	    TournamentPlayer(P).TimeMessage(TimeLeft);
   }

   CleanUpPlayerIDs();

   if(TimeLeft % 20 == 0 && TimeLeft > 0)
   {
      DebugLog("12");
      NoVoteCount = 0;
      NoModeVoteCount = 0;
      // force all players voting windows open if they have not voted
      for( aPawn=Level.PawnList; aPawn!=None; aPawn=aPawn.NextPawn )
      {
	 if(aPawn.bIsPlayer && PlayerPawn(aPawn) != none)
	 {
	    VoterNum = FindPlayerIndex(PlayerPawn(aPawn).PlayerReplicationInfo.PlayerID);
				if(VoterNum > -1)
				{
	       if(PlayerVote[VoterNum] == 0) // if this player has not voted
	       {
		  NoVoteCount++;
			if (TimeLeft == 20 && b20SecOpenVoteWindow)	//20 second warning, open voter windows for those who have not yet voted
			{
		  		OpenVoteWindow(PlayerPawn(aPawn));
				PlayerPawn(aPawn).ClientMessage("20 Seconds Left, Please Vote for a Map");
			}
	       }
	       if(PlayerModeVote[VoterNum] == 0 && !bDisableAll) // if this player has not mode voted
	       {
		  NoModeVoteCount++;
			if (TimeLeft == 20 && b20SecOpenVoteWindow)	//20 second warning, open voter windows for those who have not yet voted
			{
		  		OpenVoteWindow(PlayerPawn(aPawn));
				PlayerPawn(aPawn).ClientMessage("20 Seconds Left, Please Vote for a Game Mode");
			}
	       }
				}
	 }
      }
      if ( NoVoteCount == 0 && NoModeVoteCount == 0 ) // this should fix a problem cause by players leaving the game
      {
	 DebugLog("13");
	 TallyVotes(true); // all players have voted, so force a map change
      }
   }

   if(TimeLeft == 0)  // force level switch if time limit is up
   {
	 if( ( NumVotes1 == 0 ) &&	//no one mode voted
	 ( NumVotes2 == 0 ) &&
	 ( NumVotes3 == 0 ) &&
	 ( NumVotes4 == 0 ) &&
	 ( NumVotes5 == 0 ) &&
	 ( NumVotes6 == 0 ) &&
	 ( NumVotes7 == 0 ) &&
	 ( NumVotes8 == 0 )  && !bDisableAll)
	 {
		BroadcastMessage("No One Voted for a Mode, One Will be Chosen Randomly");
	 }
     DebugLog("14");
     TallyVotes(true);   // if no-one has voted a random map will be choosen
   }
}
//************************************************************************************************
function tick(float DeltaTime)
{
   local string PlayerName,PID;
   local int    TeamID;
   local Pawn   Other;

   Super.tick(DeltaTime);

   if(Level.Game.CurrentID > CurrentID) // at least one new player has joined
   {
      if(JoinTickCount < 20)  // added 20 tick delay too see if it reduces intermittant crash problem
      {
	 if(JoinTickCount == 0)
	    DebugLog("15");
	 JoinTickCount++;
	 return;
      }

      DebugLog("16");

      JoinTickCount = 0;
      // Find the new player
      for( Other=Level.PawnList; Other!=None; Other=Other.NextPawn )
	 if(Other.PlayerReplicationInfo.PlayerID == CurrentID)
	    break;

      CurrentID++;

      // Ignore Bots and other none playerpawns
      if(Other == None || !Other.bIsPlayer || !Other.IsA('PlayerPawn'))
      {
	 DebugLog("17");
	 return;
      }

      Log("New Player " $ Other.PlayerReplicationInfo.PlayerName $ ", " $ PlayerPawn(Other).GetPlayerNetworkAddress(),'x3dfxMapVote');

      if(bKickVote)
      {
	 DebugLog("18");

	 if(CheckKickIP(PlayerPawn(Other).GetPlayerNetworkAddress())) // check players IP address
	 {
	    DebugLog("19");
	    BroadcastMessage(Other.PlayerReplicationInfo.PlayerName $ " has been refused access to the server.", true);
	    Other.Destroy();    // Re-Kick this player
	    return;
	 }

	 if(Other.IsA('Spectator'))
	    TeamID = 9;
	 else
	 {
	    if(PlayerPawn(Other).PlayerReplicationInfo.Team == 255)
	       TeamID = 0;
	    else
	       TeamID = PlayerPawn(Other).PlayerReplicationInfo.Team;
	 }

	 PID = right("000" $ PlayerPawn(Other).PlayerReplicationInfo.PlayerID,3);

	 PlayerName = TeamID $ PID $ PlayerPawn(Other).PlayerReplicationInfo.PlayerName;
	 AddNewPlayer(PlayerName);

	 DebugLog("20");
	 // add the PlayerID to the PlayerIDList
	 FindPlayerIndex(PlayerPawn(Other).PlayerReplicationInfo.PlayerID);
      }

      if(bEntryWindows && !Other.IsA('Spectator'))
      {
	 DebugLog("21");
	 if(Level.Game.IsA('Assault') && Assault(Level.Game).bDefenseSet)  // dont open for second half of Assault game
	 {
	    DebugLog("22");
	    return;
	 }
	 if(Level.Game.bGameEnded)
	 {
	    DebugLog("23");
	    if(bAutoOpen)
	       OpenVoteWindow(PlayerPawn(Other));   // open the voting window
	 }
	 else
	    OpenWelcomeWindow(PlayerPawn(Other)); //open the welcome window
      }
      DebugLog("24");
   }
}
//************************************************************************************************
function bool CheckForTie()
{
  local TeamInfo Best;
  local int i;
  local pawn P, BestP;
  local PlayerPawn Player;

  DebugLog("25");
  if(Level.Game.IsA('Assault'))  //cant have ties in Assault, I think ?
     return false;

  if(Level.Game.IsA('Domination'))  //cant have ties in Domination, I think ?
     return false;

  // No ties in RocketArena, StrikeForce, etc.
  if(bOther &&
     !bCheckOtherGameTie &&
     Level.Game.MapPrefix ~= OtherGameClass.default.MapPreFix)
     return false;

  if(Level.Game.IsA('TeamGamePlus'))  // check for a team game tie
  {
     DebugLog("26");
     // find best team
     for( i=0; i<TeamGamePlus(Level.Game).MaxTeams; i++ )
       if( (Best == None) || (Best.Score < TeamGamePlus(Level.Game).Teams[i].Score) )
	  Best = TeamGamePlus(Level.Game).Teams[i];

     for( i=0; i<TeamGamePlus(Level.Game).MaxTeams; i++ )
	  if( (Best.TeamIndex != i) && (Best.Score == TeamGamePlus(Level.Game).Teams[i].Score) )
	     return true;  // teams tied
  }
  else   // check for death match tie
  {
     DebugLog("27");
     // find individual winner
     for( P=Level.PawnList; P!=None; P=P.nextPawn )
	if( P.bIsPlayer && ((BestP == None) || (P.PlayerReplicationInfo.Score > BestP.PlayerReplicationInfo.Score)) )
	   BestP = P;
     // check for tie
     for ( P=Level.PawnList; P!=None; P=P.nextPawn )
	  if ( P.bIsPlayer && (BestP != P) && (P.PlayerReplicationInfo.Score == BestP.PlayerReplicationInfo.Score) )
	       return true; // tied
  }
  return false;  // No tie
}
//************************************************************************************************
//******************************************************************************
// bonehed316: Submit function for gamemode votes
function SubmitModeVote(int GameMode, Actor Voter)
{
   local int PlayerIndex,x,modenum;
   local string modename;

   modenum  = -1;
   modename = "<ERROR: Unable to determine gamemode>";
   if(GameMode == 1)
   {
      modenum  = 1;
      modename = "" @ ButtonName1;
   }
   if(GameMode == 2)
   {
      modenum  = 2;
      modename = "" @ ButtonName2;
   }
   if(GameMode == 3)
   {
      modenum  = 3;
      modename = "" @ ButtonName3;
   }
   if(GameMode == 4)
   {
      modenum  = 4;
      modename = "" @ ButtonName4;
   }
   if(GameMode == 5)
   {
      modenum  = 5;
      modename = "" @ ButtonName5;
   }
   if(GameMode == 6)
   {
      modenum  = 6;
      modename = "" @ ButtonName6;
   }
   if(GameMode == 7)
   {
      modenum  = 7;
      modename = "" @ ButtonName7;
   }
   if(GameMode == 8)
   {
      modenum  = 8;
      modename = "" @ ButtonName8;
   }

	if(bLevelSwitchPending)
	   return;

   if(Voter.IsA('Spectator') && !bLMS)
      return; // spectators can not vote in other games than LMS

   CleanUpPlayerIDs(); // Remove votes for players that leave.

   PlayerIndex = FindPlayerIndex(PlayerPawn(Voter).PlayerReplicationInfo.PlayerID);
   if(PlayerIndex == -1)
	   return;

   if(PlayerModeVote[PlayerIndex] == modenum) // voted for same mode don't tally.
      return;

   PlayerModeVote[PlayerIndex] = modenum;
   if(Mode == "Accumulation")
   {
      DebugLog("29");
	if (bShowVoterNames)
      		BroadcastMessage(PlayerPawn(Voter).PlayerReplicationInfo.PlayerName $ " has placed " $ GetAccModeVote(PlayerIndex) $ " votes for " $ modename);
	else
		BroadcastMessage("A Player has placed " $ GetAccModeVote(PlayerIndex) $ " votes for " $ modename);
   }
   else
   {
      if(Mode == "Score")
	{
		if (bShowVoterNames)
	 		BroadcastMessage(PlayerPawn(Voter).PlayerReplicationInfo.PlayerName $ " has placed " $ Int(GetPlayerScore(PlayerIndex)) $ " votes for " $ modename);
		else
			BroadcastMessage("A Player has placed " $ Int(GetPlayerScore(PlayerIndex)) $ " votes for " $ modename);
	}
      else
      {
	if(bShowVoterNames)
	     BroadcastMessage(PlayerPawn(Voter).PlayerReplicationInfo.PlayerName $ " voted for " $ modename);
   	else
	     BroadcastMessage("1 vote for " $ modename);
      }
   }


   TallyVotes(false);
}
//************************************************************************************************
function SubmitVote(string MapName,Actor Voter)
{
   local int PlayerIndex,x,MapIndex;

   DebugLog("28");
   //log(PlayerPawn(Voter).PlayerReplicationInfo.PlayerName $ " has voted for " $ MapName);

	if(bLevelSwitchPending)
	   return;

   if(Voter.IsA('Spectator'))
      return; // spectators can not vote

   if(Left(MapName,3) == "[X]") // check for maps that have been marked as not playable.
      return; // ah ah ah, no no no, you didn't say the secret password

   CleanUpPlayerIDs();

   PlayerIndex = FindPlayerIndex(PlayerPawn(Voter).PlayerReplicationInfo.PlayerID);
   if(PlayerIndex == -1)
	   return;

   //look up map index
   for(x=1; x<=MapCount; x++)
   {
      if(MapList[x] == MapName)
      {
	 MapIndex = x;
	 break;
      }
   }

   if(MapIndex == 0) // if map not found stop
      return;

   if(PlayerVote[PlayerIndex] == MapIndex) // voted for same map don't tally.
      return;

   PlayerVote[PlayerIndex] = MapIndex;
   if(Mode == "Accumulation")
   {
      DebugLog("29");
	if (bShowVoterNames)
      		BroadcastMessage(PlayerPawn(Voter).PlayerReplicationInfo.PlayerName $ " has placed " $ GetAccVote(PlayerIndex) $ " votes for " $ MapName);
	else
		BroadcastMessage("A Player has placed " $ GetAccVote(PlayerIndex) $ " votes for " $ MapName);
   }
   else
   {
      if(Mode == "Score")
	{
		if (bShowVoterNames)
	 		BroadcastMessage(PlayerPawn(Voter).PlayerReplicationInfo.PlayerName $ " has placed " $ Int(GetPlayerScore(PlayerIndex)) $ " votes for " $ MapName);
		else
			BroadcastMessage("A Player has placed " $ Int(GetPlayerScore(PlayerIndex)) $ " votes for " $ MapName);
	}
      else
	{
		if(bShowVoterNames)
	 		BroadcastMessage(PlayerPawn(Voter).PlayerReplicationInfo.PlayerName $ " voted for " $ MapName);
		else
			BroadcastMessage("A Player has voted for " $ MapName);
	}
   }

   TallyVotes(false);
}
//******************************************************************************
function SubmitKickVote(int PlayerID,Actor Voter)
{
   local Pawn aPawn;
   local int VoterNum,x,y,VoteCount[32],Lamer;

   DebugLog("30");

	if(bLevelSwitchPending)
	   return;

   if(Voter.IsA('Spectator'))
      return; // spectators can not vote

   if(!bKickVote)
      return; // kick voting disabled

   if(PlayerID < 0 || PlayerID > 999)
	   return;

   CleanUpPlayerIDs();

   // Get the index of the voter
   VoterNum = FindPlayerIndex(PlayerPawn(Voter).PlayerReplicationInfo.PlayerID);
   if(VoterNum == -1)
	   return;

	if(FindPlayerIndex(PlayerID) == -1)
	   return;

   if(PlayerKickVote[VoterNum] == FindPlayerIndex(PlayerID)) // if vote is for same player stop
      return;

   // find and store the player index of the Player bing kicked
   for( aPawn=Level.PawnList; aPawn!=None; aPawn=aPawn.NextPawn )
   {
      if(aPawn.bIsPlayer && aPawn.PlayerReplicationInfo.PlayerID == PlayerID)
      {
	 if(NetConnection(PlayerPawn(aPawn).Player) == None || PlayerPawn(aPawn).bAdmin)
	 {
	    PlayerPawn(Voter).ClientMessage("Sorry, You can Not kick the Server or the Admin.");
	    return;
	 }
	 else
	 {
	    PlayerKickVote[VoterNum] = FindPlayerIndex(PlayerID);
		if (bShowVoterNames)
			BroadcastMessage("A Kick Vote has been placed against " $ aPawn.PlayerReplicationInfo.PlayerName $ " by " $ PlayerPawn(Voter).PlayerReplicationInfo.PlayerName, true);
		else
	    		BroadcastMessage("A Kick Vote has been placed against "$aPawn.PlayerReplicationInfo.PlayerName, true);
	 }
      }
   }

   // tally up the votes
   for(x=0;x<32;x++) // for each player
   {
      if(PlayerKickVote[x] != -1) // if this player has voted
      {
	 VoteCount[PlayerKickVote[x]]++; // increment the votecount for this player
      }
   }

   // find the player with the highest number of kick votes
   Lamer = 0;
   for(x=1; x<=32; x++)
   {
      if(VoteCount[x] > VoteCount[Lamer])
	 Lamer = x;
   }

   // if more than KickPercent of the players voted to kick this lamer then kick him/her
   if( (float(VoteCount[Lamer])/float(Level.Game.NumPlayers))*100 >= KickPercent)
   {
      DebugLog("31");
      KickPlayer(PlayerIDList[Lamer]);
      PlayerVote[Lamer] = 0;
      VoteCount[Lamer] = 0;
      PlayerKickVote[Lamer] = -1;
      PlayerIDList[Lamer] = -1;
   }

   //Update kick Status
   for(x=0; x<32; x++)
   {
      if(VoteCount[x] > 0)
	 KickStatusText[y++] = GetPlayerName(PlayerIDList[x]) $ "," $ VoteCount[x];
   }
   KickStatusText[y]="";

   UpdateOpenWRI();
   DebugLog("32");
}
//************************************************************************************************
function KickPlayer(int PlayerID)
{
  local Pawn aPawn;
  local string IP;
  local string PID;
  local MapVoteWRI MVWRI;

  DebugLog("33");

  for( aPawn=Level.PawnList; aPawn!=None; aPawn=aPawn.NextPawn )
  {
     if(aPawn.bIsPlayer &&
	aPawn.PlayerReplicationInfo.PlayerID == PlayerID &&
	(PlayerPawn(aPawn)==None || NetConnection(PlayerPawn(aPawn).Player)!=None )
       )
     {
	BroadcastMessage(aPawn.PlayerReplicationInfo.PlayerName $ " has been kicked.", true);
	IP = PlayerPawn(aPawn).GetPlayerNetworkAddress();
	AddKickIP(IP);

	if(bKickVote)
	{
	   PID = right("000" $ aPawn.PlayerReplicationInfo.PlayerID,3);
	   RemovePlayerName(right("000" $ PID,3));
	}

	//close his/her voting window if open
	foreach AllActors(class'x3dfxMapVotev23.MapVoteWRI',MVWRI) // check all existing WRIs
	{
	   if(aPawn == MVWRI.Owner)
	   {
	      MVWRI.CloseWindow();
	      MVWRI.Destroy();
	      break;
	   }
	}

	aPawn.Destroy();   // kick
	return;
     }
  }
  DebugLog("34");
}
//************************************************************************************************
function AddKickIP(string IP)
{
   local int i,p;
   local string ShortIP;

   DebugLog("35");

   if(IP == "")
      return;

   p = InStr(IP,":");
   if(p > -1)
     ShortIP = left(IP,p);
   else
     ShortIP = IP;

   //log("AddKickIP >" $ ShortIP $ "<");

   for(i=0;i<49;i++)
   {
      if(KickIPList[i]=="")
      {
	 KickIPList[i] = ShortIP;
	 return;
      }
   }
   DebugLog("36");
}
//************************************************************************************************
function bool CheckKickIP(string IP)  // returns true if the address is in the kick list
{
   local int i,p;
   local string ShortIP;

   DebugLog("37");

   if(IP == "")
      return false;

   p = InStr(IP,":");
   if(p > -1)
     ShortIP = left(IP,p);
   else
     ShortIP = IP;

   //Log("CheckKickIP >" $ ShortIP $ "<");

   for(i=0;i<50;i++)
   {
      if(KickIPList[i] == ShortIP)
      {
	 return true;
      }
   }
   DebugLog("38");
   return false;
}
//************************************************************************************************
simulated function PreBeginPlay()
{
   local int x;

   DebugLog("39");

   if(!bInitialized)
   {
      DebugLog("40");
      //log("PreBeginPlay...");
      // initialize PlayerIDList
      for(x=0;x<32;x++)
      {
	 PlayerIDList[x] = -1;
	 PlayerKickVote[x] = -1;
      }

      for(x=0;x<50;x++)
	 KickIPList[x]="";

      LoadMaps();    // load all the map names in the maplist array
      SortMapList(); // sort the maplist in alphabetic order

      bInitialized = true;
   }

   DebugLog("41");

   Super.PostBeginPlay();
}
//************************************************************************************************
function Mutate(string MutateString, PlayerPawn Sender)
{
   local string MapName, GameType, RealMapName;
   local string PlayerName;
   local int PlayerID,pos,seq, PlayerIndex;
   local MapVoteReport MVReport;
   local int ObjectCount;
   local MapVoteWRI MVWRI;
   local MapVoteHistory MVHistory;

   Super.Mutate(MutateString, Sender);

   //log(">"$MutateString$"<");
   //       012345678901234567890
   //MUTATE BDBMAPVOTE VOTEMENU
   if(left(Caps(MutateString),10) == "BDBMAPVOTE")
   {
      DebugLog("42");
      if(Mid(Caps(MutateString),11,8) == "VOTEMENU")
      {
	 DebugLog("43");	//bonehed316:  allow admins to force mapswitch before 20 seconds
	 if(Level.TimeSeconds > 20 || Level.Netmode == NM_Standalone || Sender.bAdmin)  // make sure they cant vote before other players have joined server
	 {
	    if(!Sender.IsA('Spectator'))
	    {
	       CleanUpPlayerIDs();
	       OpenVoteWindow(Sender);
	    }
	    else
	       Sender.ClientMessage("Spectators are not allowed to vote.");
	 }
	 else
	 {
	    Sender.ClientMessage("Please Wait 20 seconds to vote");
	 }
      }
      //---------------------------------------------
      if(Mid(Caps(MutateString),11,3) == "MAP")
      {
	 DebugLog("44");
	 MapName = mid(MutateString,15);
	 if(Sender.bAdmin)
	 {
 	        if(Left(MapName,3) == "[X]")
			MapName = mid(MapName,3); // remove [X]
	    	PlayerIndex = FindPlayerIndex(Sender.PlayerReplicationInfo.PlayerID);
		if (PlayerModeVote[PlayerIndex] != 0)	// if admin has voted for a mode
		{
	    		DecodeGameMode(PlayerModeVote[PlayerIndex]);	//set the CurGameMode to what the admin voted for
	    		BroadcastMessage("Server Admin has forced a map switch to " $ MapName);
	    		BroadcastMessage("Game Mode will be " $ CurGameMode);
	    		//GameType = SetGameType(MapName);
	    		//RealMapName = TranslateMapName(MapName);
      	    		ServerTravelString = SetupGameMap(MapName);		//add map and gametype
	    		ServerTravelString = ServerTravelString $ "?mutator=";	//add mutators
	    		if(ExtraMutators != "")
				ServerTravelString = ServerTravelString $ ExtraMutators $ ",";
			//bonehed316:  add extra mutators for admin-selected mode, even if that mode is disabled
			//bonehed316:  i need to create a function for this, so its not in here twice.
			switch(CurGameMode)
			{
				case 1:
					ServerTravelString = ServerTravelString $ "x3dfxMapVotev23.x3dfxMapVote," $ ExtraMutators1;
					break;
				case 2:
					ServerTravelString = ServerTravelString $ "x3dfxMapVotev23.x3dfxMapVote," $ ExtraMutators2;
					break;
				case 3:
					ServerTravelString = ServerTravelString $ "x3dfxMapVotev23.x3dfxMapVote," $ ExtraMutators3;
					break;
				case 4:
					ServerTravelString = ServerTravelString $ "x3dfxMapVotev23.x3dfxMapVote," $ ExtraMutators4;
					break;
				case 5:
					ServerTravelString = ServerTravelString $ "x3dfxMapVotev23.x3dfxMapVote," $ ExtraMutators5;
					break;
				case 6:
					ServerTravelString = ServerTravelString $ "x3dfxMapVotev23.x3dfxMapVote," $ ExtraMutators6;
					break;
				case 7:
					ServerTravelString = ServerTravelString $ "x3dfxMapVotev23.x3dfxMapVote," $ ExtraMutators7;
					break;
				case 8:
					ServerTravelString = ServerTravelString $ "x3dfxMapVotev23.x3dfxMapVote," $ ExtraMutators8;
					break;
				default:
					ServerTravelString = ServerTravelString $ "x3dfxMapVotev23.x3dfxMapVote";
					BroadcastMessage("Current Game mode is invalid!");
					BroadcastMessage("Game mode is being reset to Normal Weapons!");
					CurGameMode = 1;
					SaveConfig();
					break;
			}


	    		CloseAllVoteWindows();
	    		Level.ServerTravel(ServerTravelString, false);    // change the map
	 	} // if admin has NOT voted for a mode
		else
			Sender.ClientMessage("You Must Vote for a Mode (ANY Mode) THEN a Map, or Logout as Admin");
	} // if NOT admin
	else
	{
 		SubmitVote(MapName,Sender);
	}
      }
      //---------------------------------------------
      if(Mid(Caps(MutateString),11,4) == "KICK")
      {
	 DebugLog("45");
	 //TIIINNNNNNNNN  1001BDB
	 PlayerName = mid(MutateString,16);
	 PlayerID = int(Mid(left(PlayerName,4),2));

	 if(Sender.bAdmin)
	 {
			KickPlayer(PlayerID);
		 }
		 else
		 {
			 SubmitKickVote(PlayerID,Sender);
		 }
      }
      //---------------------------------------------
      if(Mid(Caps(MutateString),11,10) == "RELOADMAPS")
      {
	 DebugLog("46");
	 if(Sender.bAdmin)
	 {
	    DebugLog("47");
	    LoadMaps();
	    SortMapList();
	    BroadcastMessage("MapVote configuration has been changed, Re-Open Voting window for updates.", true);
	 }
      }
      //---------------------------------------------
      if(Mid(Caps(MutateString),11,10) == "RELOADVOTE")
      {
	 DebugLog("46a");
	 if(Sender.bAdmin)
	 {
	    DebugLog("47a");
	    BroadcastMessage("Mode Vote configuration has been changed, Re-Open Voting window for updates.", true);
	 }
      }
      //---------------------------------------------
      if(Mid(Caps(MutateString),11,6) == "REPORT")
      {
	 DebugLog("48");

	 // count MapVoteReports
	 ObjectCount = 0;
	 foreach AllActors(class'MapVoteReport',MVReport)
	    ObjectCount++;

	 if(ObjectCount > 0)
	 {
	    Sender.ClientMessage("Sorry, The server can only run one report at a time, please try again later.");
	    return;
	 }

	 MVReport = spawn(class'MapVoteReport');
	 if(MVReport != none)
	    MVReport.RunRport(Caps(Mid(MutateString,18)), Sender, MapVoteHistoryClass);
	 else
	    log("Failed to spawn MVReport",'x3dfxMapVote');
      }
      //---------------------------------------------
      if(Mid(Caps(MutateString),11,6) == "STATUS")
      {
	 DebugLog("49");
	 Sender.ClientMessage("Total Map Count is " $ MapCount);

	 // count MapVoteWRIs
	 ObjectCount = 0;
	 foreach AllActors(class'MapVoteWRI',MVWRI)
	    ObjectCount++;
	 Sender.ClientMessage("Active MapVoteWRI count is " $ ObjectCount);

	 // count MapVoteReports
	 ObjectCount = 0;
	 foreach AllActors(class'MapVoteReport',MVReport)
	    ObjectCount++;
	 Sender.ClientMessage("Active MapVoteReport count is " $ ObjectCount);

	 // count MapVoteHistorys
	 ObjectCount = 0;
	 foreach AllActors(class'MapVoteHistory',MVHistory)
	    ObjectCount++;
	 Sender.ClientMessage("Active MapVoteHistory count is " $ ObjectCount);
      }
      //---------------------------------------------
      //       0123456789012345678901234567890
      //MUTATE BDBMAPVOTE SETSEQ MAPNAME -1
      if(Mid(Caps(MutateString),11,6) == "SETSEQ")
      {
	 DebugLog("50");
	 if(Sender.bAdmin)
	 {
	    MapName = Mid(MutateString,18);
	    pos = InStr(MapName," ");
	    if(pos < 1)
	    {
	       Sender.ClientMessage("Syntax Error");
	       return;
	    }
	    seq = int(Mid(MapName,pos+1));
	    MapName = Left(MapName,pos);
	    MVHistory = spawn(MapVoteHistoryClass);
	    MVHistory.SetMapSequence(MapName,seq);
	    MVHistory.Save();
	    MVHistory.Destroy();
	    Sender.ClientMessage("Sequence changed !");
	 }
	 else
	    Sender.ClientMessage("You must be a server admin to perform this fuction !");
      }
      //---------------------------------------------
      //       0123456789012345678901234567890
      //MUTATE BDBMAPVOTE SETPC MAPNAME -1
      if(Mid(Caps(MutateString),11,5) == "SETPC")
      {
	 DebugLog("51");
	 if(Sender.bAdmin)
	 {
	    MapName = Mid(MutateString,17);
	    pos = InStr(MapName," ");
	    if(pos < 1)
	    {
	       Sender.ClientMessage("Syntax Error");
	       return;
	    }
	    seq = int(Mid(MapName,pos+1));
	    MapName = Left(MapName,pos);
	    MVHistory = spawn(MapVoteHistoryClass);
	    MVHistory.SetPlayCount(MapName,seq);
	    MVHistory.Save();
	    MVHistory.Destroy();
	    Sender.ClientMessage("PlayCount changed !");
	 }
	 else
	    Sender.ClientMessage("You must be a server admin to perform this fuction !");
      }
	// bonehed316: Submit for mode votes
      if(Mid(Caps(MutateString),11,8) == "1")
      {
	 SubmitModeVote(1, Sender);
      }
      if(Mid(Caps(MutateString),11,13) == "2")
      {
	 SubmitModeVote(2, Sender);
      }
      if(Mid(Caps(MutateString),11,15) == "3")
      {
	 SubmitModeVote(3, Sender);
      }
      if(Mid(Caps(MutateString),11,13) == "4")
      {
	 SubmitModeVote(4, Sender);
      }
      if(Mid(Caps(MutateString),11,10) == "5")
      {
	 SubmitModeVote(5, Sender);
      }
      if(Mid(Caps(MutateString),11,11) == "6")
      {
	 SubmitModeVote(6, Sender);
      }
      if(Mid(Caps(MutateString),11,10) == "7")
      {
	 SubmitModeVote(7, Sender);
      }
      if(Mid(Caps(MutateString),11,12) == "8")
      {
	 SubmitModeVote(8, Sender);
      }
   }
   //bonehed316:  added just in case, we need to send the mutate strings up the list
   else if ( NextMutator != None )
	NextMutator.Mutate(MutateString, Sender);
}
//************************************************************************************************
function OpenVoteWindow(PlayerPawn Sender)
{
   local MapVoteWRI MVWRI;
   local int x,playercount,y,i;
   local pawn p;
   local MapVoteWRI A;
   local int TeamID;
   local string PID;

   DebugLog("52");

   if(Sender.IsA('Spectator'))
      return; // don't open voting window for spectators

	if(bLevelSwitchPending)
	   return;

   // check if window already open
   foreach AllActors(class'x3dfxMapVotev23.MapVoteWRI',A) // check all existing WRIs
   {
      if(Sender == A.Owner)
      {
	 DebugLog("53");
	 return;            // dont open if already open
      }
   }

   MVWRI = Spawn(class'x3dfxMapVotev23.MapVoteWRI',Sender,,Sender.Location);
   if(MVWRI==None)
   {
      Log("#### -- PostLogin :: Fail:: Could not spawn WRI",'x3dfxMapVote');
      return;
   }

   // transfer map list to the WRI
   MVWRI.MapCount = MapCount;
   //for(x=1;x<=MapCount;x++)
   //   MVWRI.MapList[x] = MapList[x];

   //  Map Number  List
   //  ----------- ----------
   //  1   - 255   MapList1
   //  256 - 510   MapList2
   //  511 - 765   MapList3
   //  766 - 1020  MapList4

   for(i=1;i<=MapCount;i++)
   {
      if(i < 256)
	 MVWRI.MapList1[i] = MapList[i];
      if(i >= 256 && i < 511)
	 MVWRI.MapList2[i - 255] = MapList[i];
      if(i >= 511 && i < 766)
	 MVWRI.MapList3[i - 510] = MapList[i];
      if(i >= 766)
	 MVWRI.MapList4[i - 765] = MapList[i];
   }
   MVWRI.MapVoteMutator = self;

   // transfer player list to WRI
   if(bKickVote)
   {
      DebugLog("54");
      playercount=0;
      for(p=Level.PawnList; p!=None; p=p.nextPawn)
      {
	 if(PlayerPawn(p) != none && p.bIsPlayer)
	 {
	    if(p.IsA('Spectator'))
	       TeamID = 9;
	    else
	    {
	       if(PlayerPawn(p).PlayerReplicationInfo.Team == 255)
		  TeamID = 0;
	       else
		  TeamID = PlayerPawn(p).PlayerReplicationInfo.Team;
	    }

	    PID = right("000" $ PlayerPawn(p).PlayerReplicationInfo.PlayerID,3);

	    MVWRI.PlayerName[playercount++] = TeamID $ PID $ PlayerPawn(p).PlayerReplicationInfo.PlayerName;
	    // example: 1004BDB  =  Team 1, PlayerID 4, PlayerName BDB
	 }
      }
      MVWRI.PlayerCount = playercount;
   }

   // transfer Map Voting Status to status page window
   x=0;
   while(MapStatusText[x] != "" && x<99)
   {
      MVWRI.MapVoteResults[x] = MapStatusText[x];
      x++;
   }
   MVWRI.MapVoteResults[x]="";

   y=0;
   // transfer Player Kick Voting Status to status page window
   if(bKickVote)
   {
      DebugLog("55");
      while(KickStatusText[y] != "" && y<99)
      {
	 MVWRI.KickVoteResults[y] = KickStatusText[y++];
      }
      MVWRI.KickVoteResults[y] = ""; // Mark the end
   }
   // bonehed316: Transfer ModeVote status to the status page window
   MVWRI.NumVotes1 = NumVotes1;
   MVWRI.NumVotes2 = NumVotes2;
   MVWRI.NumVotes3 = NumVotes3;
   MVWRI.NumVotes4 = NumVotes4;
   MVWRI.NumVotes5 = NumVotes5;
   MVWRI.NumVotes6 = NumVotes6;
   MVWRI.NumVotes7 = NumVotes7;
   MVWRI.NumVotes8 = NumVotes8;
   //populate the button names
   MVWRI.ButtonName1 = ButtonName1;
   MVWRI.ButtonName2 = ButtonName2;
   MVWRI.ButtonName3 = ButtonName3;
   MVWRI.ButtonName4 = ButtonName4;
   MVWRI.ButtonName5 = ButtonName5;
   MVWRI.ButtonName6 = ButtonName6;
   MVWRI.ButtonName7 = ButtonName7;
   MVWRI.ButtonName8 = ButtonName8;

//do NOT send these to non-admin players.
if ( Sender.bAdmin)
{
   MVWRI.bAllowButton1 = bAllowButton1;
   MVWRI.bAllowButton2 = bAllowButton2;
   MVWRI.bAllowButton3 = bAllowButton3;
   MVWRI.bAllowButton4 = bAllowButton4;
   MVWRI.bAllowButton5 = bAllowButton5;
   MVWRI.bAllowButton6 = bAllowButton6;
   MVWRI.bAllowButton7 = bAllowButton7;
   MVWRI.bAllowButton8 = bAllowButton8;
   MVWRI.bEnableAll = bEnableAll;
   MVWRI.bDisableAll = bDisableAll;
//populate the extra mutators edit boxes
   MVWRI.ExtraMutators = ExtraMutators;
   MVWRI.ExtraMutators1 = ExtraMutators1;
   MVWRI.ExtraMutators2 = ExtraMutators2;
   MVWRI.ExtraMutators3 = ExtraMutators3;
   MVWRI.ExtraMutators4 = ExtraMutators4;
   MVWRI.ExtraMutators5 = ExtraMutators5;
   MVWRI.ExtraMutators6 = ExtraMutators6;
   MVWRI.ExtraMutators7 = ExtraMutators7;
   MVWRI.ExtraMutators8 = ExtraMutators8;
}
   MVWRI.GetServerConfig();
   DebugLog("56");
}
//************************************************************************************************
function OpenWelcomeWindow(PlayerPawn Sender)
{
   local MVWelcomeWRI MVWWRI;
   local MVWelcomeWRI A;

   DebugLog("57");

   if(Sender.IsA('Spectator'))
      return; // don't open window for spectators

   // check if window already open
   foreach AllActors(class'x3dfxMapVotev23.MVWelcomeWRI',A) // check all existing WRIs
   {
      if(Sender == A.Owner)
	 return;            // dont open if already open
   }

   MVWWRI = Spawn(class'x3dfxMapVotev23.MVWelcomeWRI',Sender,,Sender.Location);
   if(MVWWRI==None)
   {
      Log("#### -- PostLogin :: Fail:: Could not spawn MVWelcomeWRI",'x3dfxMapVote');
      return;
   }
   if(HasStartWindow == "Yes")
      MVWWRI.bHasStartWindow = True;
   else
      MVWWRI.bHasStartWindow = False;
   MVWWRI.GetServerConfig();
   DebugLog("58");
}
//************************************************************************************************
function int FindPlayerIndex(int PlayerID)
{
   // this funtion maintains the list of players
   // uses the PlayerID which should be unique for every player
   local int x;

   DebugLog("59");

   // find the PlayerID in PlayerIDList array if it exists
   for(x=0;x<32;x++)
   {
      if(PlayerIDList[x] == PlayerID)
	 return x;
   }

   // not found, so add to bottom of array
   for(x=0;x<32;x++)
   {
      if(PlayerIDList[x]==-1)
      {
	 PlayerIDList[x]=PlayerID;
	 return x;
      }
   }
	log("MAPVOTE ERROR ---- Could not find PlayerIndex",'x3dfxMapVote');
   DebugLog("60");
	return -1;
}
//************************************************************************************************
function AddNewPlayer(string NewPlayerName)  //adds a player name to all open Voting windows
{
   local MapVoteWRI MVWRI;
   local pawn p;

   DebugLog("61");

   foreach AllActors(class'x3dfxMapVotev23.MapVoteWRI',MVWRI) // check all existing WRIs
   {
      MVWRI.AddNewPlayer(NewPlayerName);
   }
   DebugLog("62");
}
//************************************************************************************************
function RemovePlayerName(string OldPlayerName)  // removes a players name from all open Voting windows
{
   local MapVoteWRI MVWRI;
   local pawn p;

   DebugLog("63");

   //Log("RemovePlayerName(" $ OldPlayerName $ ")");

   foreach AllActors(class'x3dfxMapVotev23.MapVoteWRI',MVWRI) // check all existing WRIs
   {
      MVWRI.RemovePlayerName(OldPlayerName);
   }
}
//************************************************************************************************
function CleanUpPlayerIDs()
{
   // This fuction removes the player vote info that belongs to players
   // that have left the game
   local Pawn aPawn;
   local int x;
   local bool bFound;

   DebugLog("64");

   for(x=0;x<32;x++)
   {
      //log("x = " $ x $ " , PlayerIDList[x] = " $ PlayerIDList[x]);
      if(PlayerIDList[x]>-1)
      {
	 bFound = false;
	 for( aPawn=Level.PawnList; aPawn!=None; aPawn=aPawn.NextPawn )
	 {
	    if(aPawn.bIsPlayer && aPawn.IsA('PlayerPawn') && PlayerPawn(aPawn).PlayerReplicationInfo.PlayerID == PlayerIDList[x])
	    {
	       bFound = true;
	       break;
	    }
	 }
	 if(!bFound)
	 {
	    if(bKickVote)
	       RemovePlayerName(right("000" $ PlayerIDList[x],3));
	    PlayerVote[x] = 0;
	    PlayerKickVote[x] = -1;
	    PlayerIDList[x] = -1;
	    // bonehed316:  remove modevote entry
	    PlayerModeVote[x] = 0;
	 }
      }
   }
   DebugLog("65");
}
//************************************************************************************************
function string GetPlayerName(int PlayerID)
{
   local pawn aPawn;
   local string PlayerName;

   DebugLog("66");

   PlayerName="unknown";
   for( aPawn=Level.PawnList; aPawn!=None; aPawn=aPawn.NextPawn )
   {
      if(aPawn.bIsPlayer && PlayerPawn(aPawn) != None)
      {
	 if(PlayerPawn(aPawn).PlayerReplicationInfo.PlayerID == PlayerID)
	 {
	    PlayerName = right("000" $ PlayerID,3) $ aPawn.PlayerReplicationInfo.PlayerName;
	    break;
	 }
      }
   }
   return PlayerName;
}
//******************************************************************************
function float GetPlayerScore(int PlayerIndex)
{
   local pawn aPawn;
   local float PlayerScore;

   DebugLog("67");

   for( aPawn=Level.PawnList; aPawn!=None; aPawn=aPawn.NextPawn )
   {
      if(aPawn.bIsPlayer && PlayerPawn(aPawn) != None)
      {
	 if(PlayerPawn(aPawn).PlayerReplicationInfo.PlayerID == PlayerIDList[PlayerIndex])
	 {
	    PlayerScore = PlayerPawn(aPawn).PlayerReplicationInfo.Score;
	    break;
	 }
      }
   }
   if(PlayerScore < 1)
      PlayerScore = 1;

   return PlayerScore;
}
//******************************************************************************
function int GetAccVote(int PlayerIndex)
{
   local pawn aPawn;
   local int x,PlayerAccVotes;
   local string PlayerName;

   DebugLog("68");
   // Find the Players Name
   for( aPawn=Level.PawnList; aPawn!=None; aPawn=aPawn.NextPawn )
   {
      if(aPawn.bIsPlayer && PlayerPawn(aPawn) != None)
      {
	 if(PlayerPawn(aPawn).PlayerReplicationInfo.PlayerID == PlayerIDList[PlayerIndex])
	 {
	    PlayerName = PlayerPawn(aPawn).PlayerReplicationInfo.PlayerName;
	    break;
	 }
      }
   }

   if(PlayerName == "")
      return(0);

   // Find the players name in the saved accumulated votes
   for(x=0;x<32;x++)
   {
      if(AccName[x] == PlayerName)
      {
	 PlayerAccVotes = AccVotes[x];
	 break;
      }
   }

   if(PlayerAccVotes > 0)
      return(PlayerAccVotes); // if found return the saved vote count

   // Not found, so find an empty slot and save it
   for(x=0;x<32;x++)
   {
      if(AccName[x] == "")
      {
	 AccName[x] = PlayerName;
	 AccVotes[x] = 1;
	 break;
      }
   }
   DebugLog("69");
   return(1);
}
//******************************************************************************
function SaveAccVotes(int WinningMapIndex)
{
   local pawn aPawn;
   local int x;
   local bool bFound;

   DebugLog("70");

   for(x=0;x<32;x++)
   {
      if(AccName[x] != "")
      {
	 bFound = false;
	 for( aPawn=Level.PawnList; aPawn!=None; aPawn=aPawn.NextPawn )
	 {
	    if(aPawn.bIsPlayer && PlayerPawn(aPawn) != None)
	    {
	       if(AccName[x] == PlayerPawn(aPawn).PlayerReplicationInfo.PlayerName)
	       {
		  if(PlayerVote[FindPlayerIndex(PlayerPawn(aPawn).PlayerReplicationInfo.PlayerID)] != WinningMapIndex)
		  {
		     bFound = true;
		     AccVotes[x]++;
		  }
		  break;
	       }
	    }
	 }
	 if(!bFound)  // If this player is not here anymore remove his/her votes
	 {
	    AccName[x] = "";
	    AccVotes[x] = 0;
	 }
      }
   }
   // save votes to ini file
   for(x=0;x<32;x++)
   {
      class'x3dfxMapVotev23.x3dfxMapVote'.default.AccName[x] = AccName[x];
      class'x3dfxMapVotev23.x3dfxMapVote'.default.AccVotes[x] = AccVotes[x];
   }
   class'x3dfxMapVotev23.x3dfxMapVote'.static.StaticSaveConfig();
   DebugLog("71");
}
//******************************************************************************
function int GetAccModeVote(int PlayerIndex)
{
   local pawn aPawn;
   local int x,PlayerAccModeVotes;
   local string PlayerName;

   DebugLog("68");
   // Find the Players Name
   for( aPawn=Level.PawnList; aPawn!=None; aPawn=aPawn.NextPawn )
   {
      if(aPawn.bIsPlayer && PlayerPawn(aPawn) != None)
      {
	 if(PlayerPawn(aPawn).PlayerReplicationInfo.PlayerID == PlayerIDList[PlayerIndex])
	 {
	    PlayerName = PlayerPawn(aPawn).PlayerReplicationInfo.PlayerName;
	    break;
	 }
      }
   }

   if(PlayerName == "")
      return(0);

   // Find the players name in the saved accumulated votes
   for(x=0;x<32;x++)
   {
      if(AccName[x] == PlayerName)
      {
	 PlayerAccModeVotes = AccModeVotes[x];
	 break;
      }
   }

   if(PlayerAccModeVotes > 0)
      return(PlayerAccModeVotes); // if found return the saved vote count

   // Not found, so find an empty slot and save it
   for(x=0;x<32;x++)
   {
      if(AccName[x] == "")
      {
	 AccName[x] = PlayerName;
	 AccModeVotes[x] = 1;
	 break;
      }
   }
   DebugLog("69");
   return(1);
}
//******************************************************************************
function SaveAccModeVotes(int WinningModeIndex)
{
   local pawn aPawn;
   local int x;
   local bool bFound;

   DebugLog("70");

   for(x=0;x<32;x++)
   {
      if(AccName[x] != "")
      {
	 bFound = false;
	 for( aPawn=Level.PawnList; aPawn!=None; aPawn=aPawn.NextPawn )
	 {
	    if(aPawn.bIsPlayer && PlayerPawn(aPawn) != None)
	    {
	       if(AccName[x] == PlayerPawn(aPawn).PlayerReplicationInfo.PlayerName)
	       {
		  if(PlayerVote[FindPlayerIndex(PlayerPawn(aPawn).PlayerReplicationInfo.PlayerID)] != WinningModeIndex)
		  {
		     bFound = true;
		     AccModeVotes[x]++;
		  }
		  break;
	       }
	    }
	 }
	 if(!bFound)  // If this player is not here anymore remove his/her votes
	 {
	    AccName[x] = "";
	    AccModeVotes[x] = 0;
	 }
      }
   }
   // save votes to ini file
   for(x=0;x<32;x++)
   {
      class'x3dfxMapVotev23.x3dfxMapVote'.default.AccName[x] = AccName[x];
      class'x3dfxMapVotev23.x3dfxMapVote'.default.AccModeVotes[x] = AccModeVotes[x];
   }
   class'x3dfxMapVotev23.x3dfxMapVote'.static.StaticSaveConfig();
   DebugLog("71");
}
//******************************************************************************
function TallyVotes(bool bForceMapSwitch)
{
   local string MapName;
   local string RealMapName;
   local Actor  A;
   local int    index, modeindex,x,y,topmap;
   local int    VoteCount[1024], ModeVoteCount[9];
   local int    Ranking[32], ModeRanking[9];
   local int    PlayersThatVoted, PlayersThatModeVoted;
   local int    TieCount, ModeTieCount;
   local string GameType,CurrentMap;
   local int i,textline, V, GameMode;
   local MapVoteHistory History;

   DebugLog("72");

	if(bLevelSwitchPending)
	   return;


   PlayersThatVoted = 0;
   PlayersThatModeVoted = 0;

   for(x=0;x<32;x++) // for each player
   {
      if(PlayerVote[x] != 0) // if this player has voted
      {
	 PlayersThatVoted++;

	 if(Mode == "Score")
	 {
	    VoteCount[PlayerVote[x]] = VoteCount[PlayerVote[x]] + int(GetPlayerScore(x));
	 }

	 if(Mode == "Accumulation")
	 {
	    VoteCount[PlayerVote[x]] = VoteCount[PlayerVote[x]] + GetAccVote(x);
	 }

	 if(Mode == "Elimination" || Mode == "Majority")
	 {
	    VoteCount[PlayerVote[x]]++; // increment the votecount for this map
	    if ( ((float(VoteCount[PlayerVote[x]]) / float(Level.Game.NumPlayers)) > 0.5) && ((float(ModeVoteCount[PlayerModeVote[x]]) / float(Level.Game.NumPlayers)) > 0.5) && (Level.Game.bGameEnded) )
	       	bForceMapSwitch = true;
	 }
      }
   }
   for(x=0;x<32;x++) // for each player
   {
      if(PlayerModeVote[x] != 0) // if this player has mode voted
      {
    	 PlayersThatModeVoted++;

	 if(Mode == "Score")
	 {
	    ModeVoteCount[PlayerModeVote[x]] = ModeVoteCount[PlayerModeVote[x]] + int(GetPlayerScore(x));
	 }

	 if(Mode == "Accumulation")
	 {
	    ModeVoteCount[PlayerModeVote[x]] = ModeVoteCount[PlayerModeVote[x]] + GetAccModeVote(x);
	 }

	 if(Mode == "Elimination" || Mode == "Majority")
	 {
	   ModeVoteCount[PlayerModeVote[x]]++;  //increment the modevotecoutn for this mode
	// increment the votecount for his/her chosen mode
	   if ( ((float(VoteCount[PlayerVote[x]]) / float(Level.Game.NumPlayers)) > 0.5) && ((float(ModeVoteCount[PlayerModeVote[x]]) / float(Level.Game.NumPlayers)) > 0.5) && (Level.Game.bGameEnded) )
	       	bForceMapSwitch = true;
	 }
		NumVotes1 = ModeVoteCount[1];
		NumVotes2 = ModeVoteCount[2];
		NumVotes3 = ModeVoteCount[3];
		NumVotes4 = ModeVoteCount[4];
		NumVotes5 = ModeVoteCount[5];
		NumVotes6 = ModeVoteCount[6];
		NumVotes7 = ModeVoteCount[7];
		NumVotes8 = ModeVoteCount[8];
      }
   }


   if(!Level.Game.bGameEnded && !bMidGameVote && ( ( (float(PlayersThatVoted) / float(Level.Game.NumPlayers)) * 100 >= MidGameVotePercent) || ( (float(PlayersThatModeVoted) / float(Level.Game.NumPlayers)) * 100 >= MidGameVotePercent)) ) // Mid game vote initiated
   {
      DebugLog("73");
      BroadCastMessage("Mid-Game Map Voting has been initiated !!!!");
      bMidGameVote = true;
      // Start voting count-down timer
      TimeLeft = VoteTimeLimit;
      ScoreBoardTime = 1;
      settimer(1,true);
   }

   index = 0;
   modeindex = 0;
   for(x=1;x<=MapCount;x++) // for each map
   {
      if(VoteCount[x] > 0)
      {
	 Ranking[index++] = x; // copy all map indexes to the ranking list if someone has voted for it.
      }
   }
   for(x=1;x<9;x++) // for each mode
   {
      if(ModeVoteCount[x] > 0)
      {
	 ModeRanking[modeindex++] = x; // copy all mode indexes to the ranking list if someone has voted for it.
      }
   }

   // bubble sort rankings list by vote count
   for(x=0; x<index-1; x++)
   {
      for(y=x+1; y<index; y++)
      {
	 if(VoteCount[Ranking[x]] < VoteCount[Ranking[y]])
	 {
	    topmap = Ranking[x];
	    Ranking[x] = Ranking[y];
	    Ranking[y] = topmap;
	 }
      }
   }
   // bubble sort mode rankings list by vote count
   for(x=0; x<modeindex-1; x++)
   {
      for(y=x+1; y<modeindex; y++)
      {
	 if(ModeVoteCount[ModeRanking[x]] < ModeVoteCount[ModeRanking[y]])
	 {
	    GameMode = ModeRanking[x];
	    ModeRanking[x] = ModeRanking[y];
	    ModeRanking[y] = GameMode;
	 }
      }
   }

   //Update Status Page
   for(x=0;x<index;x++)
   {
      MapStatusText[x] = MapList[Ranking[x]] $ "," $ VoteCount[Ranking[x]];
   }
   MapStatusText[index] = "";

   UpdateOpenWRI();

   //Check for a tie
   if(VoteCount[Ranking[0]] == VoteCount[Ranking[1]] && VoteCount[Ranking[0]] != 0)//no tie, no one voted
   {
      DebugLog("74");

      TieCount = 1;
      for(x=1; x<index; x++)
      {
	if(VoteCount[Ranking[0]] == VoteCount[Ranking[x]])
	   TieCount++;
      }
      //reminder ---> int Rand( int Max ); Returns a random number from 0 to Max-1.
      topmap = Ranking[Rand(TieCount)];

      // Don't allow same map to be choosen
      CurrentMap = GetURLMap();
      if(CurrentMap != "" && !(Right(CurrentMap,4) ~= ".unr"))
	 CurrentMap = CurrentMap$".unr";

      x = 0;
      while(MapList[topmap] ~= CurrentMap)
      {
	 topmap = Ranking[Rand(TieCount)];
	 x++;
	 if(x>20)
	    break;  // just incase, don't want to waste alot of time choosing a random map
      }
   }
   else
   {
      DebugLog("75");
      topmap = Ranking[0];
   }
   //Check for Mode tie
   if(ModeVoteCount[ModeRanking[0]] == ModeVoteCount[ModeRanking[1]] && ModeVoteCount[ModeRanking[0]] != 0)//no tie, no one voted
   {
      DebugLog("74");

      ModeTieCount = 1;
      for(x=1; x<modeindex; x++)
      {
	if(ModeVoteCount[ModeRanking[0]] == ModeVoteCount[ModeRanking[x]])
	   ModeTieCount++;
      }
      //reminder ---> int Rand( int Max ); Returns a random number from 0 to Max-1.
      GameMode = ModeRanking[Rand(ModeTieCount)];//choose random mode from those that are tied
   }
   else
   {
      DebugLog("75");
      GameMode = ModeRanking[0];
   }

   // check if all players have voted
   //log("Players - " $ level.game.NumPlayers);
   //log("Voted - " $ PlayersThatVoted);

   //return; // testing

   if(bForceMapSwitch)  // forces a map change even if everyone has not voted
   {
      if(PlayersThatVoted == 0) // if noone has voted choose a map at random
      {
	 topmap = Rand(MapCount) + 1;

	 while(Left(MapList[topmap],3) == "[X]")  // don't allow elimiated maps
	    topmap = Rand(MapCount) + 1;          // select a different map
      }
      if(PlayersThatModeVoted == 0 && !bDisableAll) // if noone has voted choose a mode at random
      {
	 GameMode = Rand(9);	//randomly pick a mode
	 DecodeGameMode(GameMode);	//set the extras for this mode
	 x=0;

	 while(!CurGameModeAllowed(CurGameMode))  // while mode is disabled
	 {
	    GameMode = Rand(9);          // select a different mode
	    DecodeGameMode(GameMode);	 // set the extras for it, to see if its enabled
	    x++;
	    if ( x > 30)		// prevents the "theoretical" crash if only one mode is enabled, and the computer never randomly chooses it
		break;
	 }
      }
   }

// if everyone has voted for a map AND a mode, or if all modes are disabled and everyone has voted for a map, go ahead and change map

   if(bForceMapSwitch || ((Level.Game.NumPlayers == PlayersThatVoted) && ((Level.Game.NumPlayers == PlayersThatModeVoted) || bDisableAll)) )
   {
      DebugLog("76");
      if(MapList[topmap] == "")
	 return;

      // enable timer for mid game voting
      if(!Level.Game.bGameEnded)
	 settimer(1,true);
      History = spawn(MapVoteHistoryClass);
      History.AddMap(MapList[topmap]);
      History.Save();
      History.Destroy();

      DecodeGameMode(GameMode);	//this may be redundant...but i dont think so

      ServerTravelString = SetupGameMap(MapList[topmap]);	//add map and game type
      ServerTravelString = ServerTravelString $ "?mutator=";	//add mutators
      RealMapName = TranslateMapName(MapList[topmap]);
      BroadcastMessage("Next map will be " $ MapList[topmap] $ extra, true);
      CloseAllVoteWindows();
      bLevelSwitchPending = true;

	if(ExtraMutators != "")
		ServerTravelString = ServerTravelString $ ExtraMutators $ ",";	//add extra mutators
	//bonehed316:  add per game mutators
	switch (CurGameMode)
	{

		case 1:
			ServerTravelString = ServerTravelString $ "x3dfxMapVotev23.x3dfxMapVote," $ ExtraMutators1;
			break;
		case 2:
			ServerTravelString = ServerTravelString $ "x3dfxMapVotev23.x3dfxMapVote," $ ExtraMutators2;
			break;
		case 3:
			ServerTravelString = ServerTravelString $ "x3dfxMapVotev23.x3dfxMapVote," $ ExtraMutators3;
			break;
		case 4:
			ServerTravelString = ServerTravelString $ "x3dfxMapVotev23.x3dfxMapVote," $ ExtraMutators4;
			break;
		case 5:
			ServerTravelString = ServerTravelString $ "x3dfxMapVotev23.x3dfxMapVote," $ ExtraMutators5;
			break;
		case 6:
			ServerTravelString = ServerTravelString $ "x3dfxMapVotev23.x3dfxMapVote," $ ExtraMutators6;
			break;
		case 7:
			ServerTravelString = ServerTravelString $ "x3dfxMapVotev23.x3dfxMapVote," $ ExtraMutators7;
			break;
		case 8:
			ServerTravelString = ServerTravelString $ "x3dfxMapVotev23.x3dfxMapVote," $ ExtraMutators8;
			break;
		default:
			if( !bDisableAll )
	    		{
				ServerTravelString = ServerTravelString $ "x3dfxMapVotev23.x3dfxMapVote";
				BroadcastMessage("Current Game mode is invalid!");
				BroadcastMessage("Game mode is being reset to Normal Weapons!");
				DecodeGameMode(1);
	    		}
	    		else	//all modes must be disabled, re-add mapvote
	   		{
				ServerTravelString = ServerTravelString $ "x3dfxMapVotev23.x3dfxMapVote";
	    		}
			break;

	}

      ServerTravelTime = Level.TimeSeconds;

      if(Mode == "Elimination")
      {
	 RepeatLimit++;
	 class'x3dfxMapVotev23.x3dfxMapVote'.default.RepeatLimit = RepeatLimit;
	 class'x3dfxMapVotev23.x3dfxMapVote'.static.StaticSaveConfig();
      }

      if(Mode == "Accumulation")
      {
	 SaveAccVotes(topmap);
	 SaveAccModeVotes(GameMode);
      }
   }
   DebugLog("77");
}
//************************************************************************************************
//************************************************************************************************
function bool CurGameModeAllowed(int CurGameMode)
{
	switch(CurGameMode)
   	{
      		case 1:
	 		return bAllowButton1;
			break;
      		case 2:
	 		return bAllowButton2;
			break;
      		case 3:
	 		return bAllowButton3;
			break;
      		case 4:
	 		return bAllowButton4;
			break;
      		case 5:
	 		return bAllowButton5;
			break;
      		case 6:
	 		return bAllowButton6;
			break;
      		case 7:
	 		return bAllowButton7;
			break;
      		case 8:
	 		return bAllowButton8;
			break;
	}
}
//************************************************************************************************
function DecodeGameMode(int GameMode)
{
	switch (GameMode)
	{
		case  1:
			extra = " (" @ ButtonName1@"";
			CurGameMode = 1;
			SaveConfig();
			break;
		case  2:
			extra = " (" @ ButtonName2@"";
			CurGameMode = 2;
			SaveConfig();
			break;
		case  3:
			extra = " (" @ ButtonName3@"";
			CurGameMode = 3;
			SaveConfig();
			break;
		case  4:
			extra = " (" @ ButtonName4@"";
			CurGameMode = 4;
			SaveConfig();
			break;
		case  5:
			extra = " (" @ ButtonName5@"";
			CurGameMode = 5;
			SaveConfig();
			break;
		case  6:
			extra = " (" @ ButtonName6@"";
			CurGameMode = 6;
			SaveConfig();
			break;
		case  7:
			extra = " (" @ ButtonName7@"";
			CurGameMode = 7;
			SaveConfig();
			break;
		case  8:
			extra = " (" @ ButtonName8@"";
			CurGameMode = 8;
			SaveConfig();
			break;
		default:
			if (CurGameMode == 1)
				extra = " (" @ ButtonName1@"";
			else if (CurGameMode == 2)
				extra = " (" @ ButtonName2@"";
			else if (CurGameMode == 3)
				extra = " (" @ ButtonName3@"";
			else if (CurGameMode == 4)
				extra = " (" @ ButtonName4@"";
			else if (CurGameMode == 5)
				extra = " (" @ ButtonName5@"";
			else if (CurGameMode == 6)
				extra = " (" @ ButtonName6@"";
			else if (CurGameMode == 7)
				extra = " (" @ ButtonName7@"";
			else if (CurGameMode == 8)
				extra = " (" @ ButtonName8@"";
			else
			{
				extra = " (" @ ButtonName1@"";
				CurGameMode = 1;
				SaveConfig();
			}
			break;

	}
}


//************************************************************************************************
function string TranslateMapName(string MapName)
{
   local string PreFix;

   Prefix = Left(MapName,3);
   If(Prefix ~= "TDM" || Prefix ~= "LMS")
   {
      // Zet prefix op DM en return waarde
      return "DM" $ Right(MapName, Len(MapName) - 3);
   }

   return MapName;
}

//************************************************************************************************
function UpdateOpenWRI()
{
   local MapVoteWRI MVWRI;
   local int x,y;

   DebugLog("78");

   foreach AllActors(class'x3dfxMapVotev23.MapVoteWRI',MVWRI)
   {
      // transfer Map Voting Status to status page window
      x=0;
      MVWRI.UpdateMapVoteResults("Clear",x);
      while(MapStatusText[x] != "" && x<99)
      {
	 MVWRI.UpdateMapVoteResults(MapStatusText[x],x);
	 x++;
      }
      MVWRI.UpdateMapVoteResults("",x); // Mark the end
      y=0;
      // transfer Player Kick Voting Status to status page window
      MVWRI.UpdateKickVoteResults("Clear",y);
      if(bKickVote)
      {
	 while(KickStatusText[y] != "" && y<99)
	 {
	    MVWRI.UpdateKickVoteResults(KickStatusText[y],y++);
	 }
      }
      MVWRI.UpdateKickVoteResults("",y); // Mark the end

 	// bonehed316:  update modevote menus
    MVWRI.UpdateModeVoteResults(NumVotes1, NumVotes2, NumVotes3, NumVotes4,
    NumVotes5, NumVotes6, NumVotes7, NumVotes8,
	bAllowButton1, bAllowButton2, bAllowButton3, bAllowButton4,
	bAllowButton5, bAllowButton6, bAllowButton7, bAllowButton8);
   }
   DebugLog("79");
}
//************************************************************************************************
function SortMapList()
{
   local int a,b;
   local string TempMapName,AMap,BMap;

   DebugLog("80");

   // bubble sort the map list
   for(a=1;a<=MapCount-1;a++)
   {
      for(b=a+1;b<=MapCount;b++)
      {
	 AMap = Caps(MapList[a]);
	 BMap = Caps(MapList[b]);

	 if(Left(AMap,3) == "[X]")
	    AMap = Mid(AMap,3);

	 if(Left(BMap,3) == "[X]")
	    BMap = Mid(BMap,3);

	 if(!bSortWithPreFix) // remove prefix
	 {
   	    if(Left(AMap,Len(PreFixSwap)) == PreFixSwap)
	       AMap = Mid(AMap,Len(PreFixSwap));

	    if(Left(BMap,Len(PreFixSwap)) == PreFixSwap)
	       BMap = Mid(BMap,Len(PreFixSwap));

	    if((bCTF && Left(AMap,3) == "CTF") ||
	       (bDOM && Left(AMap,3) == "DOM") ||
	       (bTDM && Left(AMap,3) == "TDM") ||
	       (bLMS && Left(AMap,3) == "LMS"))
	       AMap = Mid(AMap,3);

	    if((bCTF && Left(BMap,3) == "CTF") ||
	       (bDOM && Left(BMap,3) == "DOM") ||
	       (bTDM && Left(BMap,3) == "TDM") ||
	       (bLMS && Left(BMap,3) == "LMS"))
	       BMap = Mid(BMap,3);

	    if((bDM && Left(AMap,2) == "DM") ||
	       (bAS && Left(AMap,2) == "AS"))
	       AMap = Mid(AMap,2);

	    if((bDM && Left(BMap,2) == "DM") ||
	       (bAS && Left(BMap,2) == "AS"))
	       BMap = Mid(BMap,2);
	 }

	 if(AMap > BMap)
	 {
	    TempMapName = MapList[a];
	    MapList[a] = MapList[b];
	    MapList[b] = TempMapName;
	 }
      }
   }
}
//************************************************************************************************
function CloseAllVoteWindows()
{
   local MapVoteWRI MVWRI;

   DebugLog("81");

   foreach AllActors(class'x3dfxMapVotev23.MapVoteWRI',MVWRI)
   {
      MVWRI.CloseWindow();
      MVWRI.Destroy();
   }
}
//************************************************************************************************
function string SetupGameMap(string MapName)
{
   local string GameType;
   local MapList myList;
   local int i;

   DebugLog("82");
   //ServerTravelString = MapList[topmap]$".unr?game="$GameType;


   if(OtherGameClass != None && bOther)
   {
	extra = extra $ ")";

      DebugLog("83");
      if(MapPreFixOverRide != "")  // MapPrefix overridden
      {
	 if(PreFixSwap == "")
	 {
	    if(left(Caps(MapName),len(MapPreFixOverRide)) ~= MapPreFixOverRide)
	       return MapName $ ".unr?game=" $ OtherClass;
	 }
	 else
	 {
	    if(left(Caps(MapName),len(PreFixSwap)) ~= PreFixSwap)
	       return MapPreFixOverRide $ Mid(MapName,Len(PreFixSwap)) $ ".unr?game=" $ OtherClass;
	 }
      }
      else
      {
	 if(PreFixSwap == "")
	 {
	    if(left(Caps(MapName),len(OtherGameClass.default.MapPreFix)) ~= OtherGameClass.default.MapPreFix)
	       return MapName$".unr?game="$OtherClass;
	 }
	 else
	 {
	    if(left(Caps(MapName),len(PreFixSwap)) ~= PreFixSwap)
	       return OtherGameClass.default.MapPreFix $ Mid(MapName,Len(PreFixSwap)) $ ".unr?game=" $ OtherClass;
	 }
      }
   }

   if(Left(Caps(MapName),2) == "DM")
   {
      GameType = DMGameType;
      	extra = extra $ "Deathmatch)";
   }

   if(Left(Caps(MapName),3) == "LMS")
   {
      GameType = LMSGameType;
	extra = extra $ "Last man standing)";
      MapName = "DM" $ Mid(MapName,3);  // change the prefix
   }

   if(Left(Caps(MapName),3) == "TDM")
   {
      GameType = TDMGameType;
	extra = extra $ "Team Deathmatch)";
      MapName = "DM" $ Mid(MapName,3);  // change the prefix
   }

   if(Left(Caps(MapName),3) == "DOM")
   {
      GameType = DOMGameType;
	extra = extra $ "Domination)";
   }

   if(Left(Caps(MapName),3) == "CTF")
   {
      GameType = CTFGameType;
	extra = extra $ "Capture the Flag)";
   }

   if(Left(Caps(MapName),2) == "AS")
   {
      GameType = ASGameType;
	 extra = extra $ "Assault)";
      // if playing assault in second half and switching to a different assault map
      if(Level.Game.IsA('Assault') &&  Assault(Level.Game).bDefenseSet)
      {
	 Assault(Level.Game).ResetGame();  // resets assault ini settings so next game starts on first half of game instead of second
      }
      else
      {
	 // this should make sure that we start in the first half
	 class'Assault'.default.bDefenseSet = false;
	 class'Assault'.static.StaticSaveConfig();
      }
   }

   return MapName$".unr?game="$GameType;
}

function string SetGameType(string MapName)
{
   local string GameType, PreFix;
   local MapList myList;
   local int i;

   if(OtherGameClass != None && left(Caps(MapName),len(OtherGameClass.default.MapPreFix)) == OtherGameClass.default.MapPreFix)
   {
      GameType = OtherClass;
      return GameType;
   }

   if(Left(Caps(MapName),2) == "DM")
	 GameType = DMGameType;

   if(Left(Caps(MapName),3) == "TDM")
	 GameType = TDMGameType;

   if(Left(Caps(MapName),3) == "LMS")
	 GameType = LMSGameType;

   if(Left(Caps(MapName),3) == "DOM")
      GameType = DOMGameType;

   if(Left(Caps(MapName),3) == "CTF")
      GameType = CTFGameType;

   if(Left(Caps(MapName),2) == "AS")
   {
      GameType = ASGameType;
      // if playing assault in second half and switching to a different assault map
      if(Level.Game.IsA('Assault') &&  Assault(Level.Game).bDefenseSet)
      {
	 Assault(Level.Game).ResetGame();  // resets assault ini settings so next game starts on first half of game instead of second
      }
      else
      {
	 // this should make sure that we start in the first half
	 class'Assault'.default.bDefenseSet = false;
	 class'Assault'.static.StaticSaveConfig();
      }
   }

   return GameType;
}
//************************************************************************************************
function LoadMaps()
{
   local MapVoteHistory History;
   local int pos,i;
   local string GamePackage,NewPreFix;
   local Mutator M;
   local bool bTeamReady;
   local pawn p;

   DebugLog("84");

   MapVoteHistoryClass = class<MapVoteHistory>(DynamicLoadObject(MapVoteHistoryType, class'Class'));
   History = spawn(MapVoteHistoryClass);

   if(History == None) // Failed to spawn MapVoteHistory
   {
      DebugLog("89");
      History = spawn(class'MapVoteHistory1');
   }

   MapCount = 0;
   MarkedMapCount = 0;
   
   if (MinPlayersForTeamGames > 0)
   {
	for (p=Level.Pawnlist;P!=none;P=P.NextPawn)
		if (PlayerPawn(P) != None)	// make sure theyre not bots
	   		i++;

	// there are enough people for team games to be enabled
	if (i >= MinPlayersForTeamGames)
		bTeamReady = True;
	
	// fallback incase admin is retarded and doesnt leave any non teamgames enabled
	if (!bTeamReady && !bDM && ! bLMS)
	{
		if (OtherClass != "")
		{
			OtherGameClass = class<GameInfo>(DynamicLoadObject(OtherClass, class'Class'));
			if (!bOther && OtherGameClass != none && OtherGameClass.default.bTeamGame)
				bAutoDetect=True;
		}
		else
			bAutoDetect=True;
	}
   }
   else
   	bTeamReady = True;	//set it to true, its easier

   if(bAutoDetect)
   {
      log("Detected GameType = "$string(Level.Game.Class),'x3dfxMapVote');
      bAS=False;
      bCTF=False;
      bDM=False;
      bLMS=False;
      bTDM=False;
      bDOM=False;
      bOther=False;
      if(string(Level.Game.Class) ~= "Botpack.Assault")
	 bAS=True;
      else if(string(Level.Game.Class) ~= "Botpack.CTFGame")
	 bCTF=True;
      else if(string(Level.Game.Class) ~= "Botpack.DeathMatchPlus")
	 bDM=True;
      else if(string(Level.Game.Class) ~= "Botpack.LastManStanding")
	 bLMS=True;
      else if(string(Level.Game.Class) ~= "Botpack.TeamGamePlus")
	 bTDM=True;
      else if(string(Level.Game.Class) ~= "Botpack.Domination")
	 bDOM=True;
      else
      {
	 bOther=True;
	 OtherClass=string(Level.Game.Class);
      }

   }

   if(bOther)
      OtherGameClass = class<GameInfo>(DynamicLoadObject(OtherClass, class'Class'));
      
  
   if(bAS)
   {
   	if ( bTeamReady || bAutoDetect)
   	{
	      if(bUseMapList)
		 LoadMapCycleList(class'Botpack.Assault'.default.MapListType,"AS","AS",History);
	      else
		 LoadMapTypes("AS","AS",History);
	}
   }

   if(bCTF) // Load Capture The Flag Maps
   {
      	if (bTeamReady || bAutoDetect)
   	{
	      if(bUseMapList)
		 LoadMapCycleList(class'Botpack.CTFGame'.default.MapListType,"CTF","CTF",History);
	      else
		 LoadMapTypes("CTF","CTF",History);
	}
   }

   if(bDM) // Load DeathMatch Maps
   {
      if(bUseMapList)
	 LoadMapCycleList(class'Botpack.DeathMatchPlus'.default.MapListType,"DM","DM",History);
      else
	 LoadMapTypes("DM","DM",History);
   }

   if(bDOM) // Load Domination Maps
   {
   	if (bTeamReady || bAutoDetect)
   	{
	      if(bUseMapList)
		 LoadMapCycleList(class'Botpack.Domination'.default.MapListType,"DOM","DOM",History);
	      else
		 LoadMapTypes("DOM","DOM",History);
	}
   }

   if(bTDM) // Load TeamDeathMatch Maps
   {
      	if (bTeamReady || bAutoDetect)
   	{
	      if(bUseMapList)
		 LoadMapCycleList(class'Botpack.TeamGamePlus'.default.MapListType,"DM","TDM",History);
	      else
		 LoadMapTypes("DM","TDM",History);
	}
   }

   if(bLMS) // Load LastManStanding Maps
   {
      if(bUseMapList)
	 LoadMapCycleList(class'Botpack.LastManStanding'.default.MapListType,"DM","LMS",History);
      else
	 LoadMapTypes("DM","LMS",History);
   }

   if(bOther && OtherGameClass != None) // Load Other Maps
   {
      	if (bTeamReady || bAutoDetect || !OtherGameClass.Default.bTeamGame)
   	{
	      DebugLog("85");
	      if(PreFixSwap != "")
		 NewPreFix = PreFixSwap;
	      else
	      {
		 if(MapPreFixOverRide == "")
		    NewPreFix = OtherGameClass.default.MapPreFix;
		 else
		    NewPreFix = MapPreFixOverRide;
	      }
	      if(bUseMapList)
	      {
		 if(MapPreFixOverRide == "")
		    LoadMapCycleList(OtherGameClass.default.MapListType,OtherGameClass.default.MapPreFix,NewPreFix,History);
		 else
		    LoadMapCycleList(OtherGameClass.default.MapListType,MapPreFixOverRide,NewPreFix,History);
	      }
	      else
	      {
		 if(MapPreFixOverRide == "")
		    LoadMapTypes(OtherGameClass.default.MapPreFix,NewPreFix,History);
		 else
		    LoadMapTypes(MapPreFixOverRide,NewPreFix,History);
	      }
	      if(HasStartWindow == "Auto")
	      {
		 GamePackage = Caps(string(Level.Game.Class));
		 pos = InStr(GamePackage,".");
		 if(pos > 0)
		    GamePackage = left(GamePackage,pos);
	
		 if(GamePackage=="S_SWAT" || GamePackage =="WFCODE" || GamePackage =="ROCKETARENA")
		    HasStartWindow = "Yes"; // these Mods have start windows
		 else
		    HasStartWindow = "No";
	      }
	}
   }
   History.Destroy();

   if(Mode == "Elimination")
   {
      //if(MapCount < MinMapCount || (MapCount == 0 && RepeatLimit > 0))
	  // fix, Thanks to Mr.Mitchell for finding this bug
      if( (MapCount-MarkedMapCount) < MinMapCount || ((MapCount-MarkedMapCount) == 0 && RepeatLimit > 0))
      {
	 RepeatLimit = 0;
	 LoadMaps();
	 return;
      }
   }
   log("Total Maps = "$ MapCount,'x3dfxMapVote');
}
//*******************************************************************************
function LoadMapTypes(string PreFix,string PreFixChange,MapVoteHistory History)
{
   local string FirstMap,NextMap,MapName,TestMap;
   local int z;

   DebugLog("86");

   FirstMap = Level.GetMapName(PreFix, "", 0);
   NextMap = FirstMap;
   while(!(FirstMap ~= TestMap))
   {
      MapName = NextMap;
      z = InStr(Caps(MapName), ".UNR");
      if(z != -1)
	 MapName = Left(MapName, z);  // remove ".unr"

      MapName = PreFixChange $ Mid(MapName,Len(PreFix));  // change the prefix

      if(InStr(Caps(NextMap),"TUTORIAL") == -1)  // dont load tutorial maps
      {
	 if(History.GetMapSequence(MapName) <= RepeatLimit)
		 {
	    MapName = "[X]" $ MapName;  // mark this map so it can't be voted for
			MarkedMapCount++;
	 }

	 MapList[++MapCount] = MapName;
      }
      NextMap = Level.GetMapName(PreFix, NextMap, 1);
      TestMap = NextMap;
      if(MapCount > 1020)
	 break;
   }
}
//*******************************************************************************
function LoadMapCycleList(class<MapList> MapListType,string PreFix,string PreFixChange,MapVoteHistory History)
{
   local MapList MapCycleList;
   local string MapName;
   local int x,z;

   DebugLog("87");

   MapCycleList = spawn(MapListType);
   if(MapCycleList != none)
   {
      x = 0;
      While(x<32 && MapCycleList.Maps[x]!="")
      {
	 MapName = MapCycleList.Maps[x++];
	 z = InStr(Caps(MapName), ".UNR");
	 if(z != -1)
	    MapName = Left(MapName, z); // remove ".unr"
	 MapName = PreFixChange $ Mid(MapName,Len(PreFix));  // change the prefix
	 if(History.GetMapSequence(MapName) <= RepeatLimit)
		 {
	    MapName = "[X]" $ MapName;  // mark this map so it can't be voted for
			MarkedMapCount++;
	 }

	 MapList[++MapCount] = MapName;
      }
      MapCycleList.Destroy();
   }
   else
      Log("MapList Spawn Failed",'x3dfxMapVote');
}

function DebugLog(string Msg)
{
   if(bDebugMode)
      Log("MV " $ Msg,'x3dfxMapVote_DEBUG');
}

//************************************************************************************************

defaultproperties
{
	bAllowButton1=True
	bAllowButton2=True
	bAllowButton3=True
	bAllowButton4=True
	bAllowButton5=True
	bAllowButton6=True
	bAllowButton7=True
	bAllowButton8=True
	b20SecOpenVoteWindow=True
	bEnableAll=True
	bDisableAll=False
	ButtonName1="BUTTON1"
	ButtonName2="BUTTON2"
	ButtonName3="BUTTON3"
	ButtonName4="BUTTON4"
	ButtonName5="BUTTON5"
	ButtonName6="BUTTON6"
	ButtonName7="BUTTON7"
	ButtonName8="BUTTON8"
	CurGameMode=""
	DMGameType="BotPack.DeathMatchPlus"
	LMSGameType="BotPack.LastManStanding"
	TDMGameType="BotPack.TeamGamePlus"
	DOMGameType="BotPack.Domination"
	CTFGameType="BotPack.CTFGame"
	ASGameType="BotPack.Assault"
	bShowVoterNames=True
	bAutoDetect=False
	bDM=True
	bLMS=True
	bTDM=True
	bDOM=True
	bCTF=True
	bAS=True
	bOther=False
	OtherClass=""
	ExtraMutators=""
	ExtraMutators1=""
	ExtraMutators2=""
	ExtraMutators3=""
	ExtraMutators4=""
	ExtraMutators5=""
	ExtraMutators6=""
	ExtraMutators7=""
	ExtraMutators8=""
	MapPreFixOverRide=""
	PreFixSwap=""
	bSortWithPreFix=True
	VoteTimeLimit=70
	KickPercent=51
	bUseMapList=False
	ScoreBoardDelay=10
	MinPlayersForTeamGames=0
	bAutoOpen=True
	bKickVote=True
	bCheckOtherGameTie=False
	RepeatLimit=0
	MapVoteHistoryType="x3dfxMapVotev23.MapVoteHistory1"
	ServerInfoURL=""
	MapInfoURL=""
	MidGameVotePercent=50
	Mode="Majority"
	MinMapCount=2
	HasStartWindow="Auto"
	bEntryWindows=True
	bDebugMode=False
	MsgTimeOut=10
	bLoadScreenShot=True
}
