// Smiling Monsters Auto Pickup
// By Ti-Lung 03/09/2007
// Version 1.0 (20070903)
// Created for the Smiling Monsters community
// http://www.smiling-monsters.com/community/
// Request by DeathMaker

class SMoAutoPickup expands Mutator
	config(SMoAutoPickup);

// Config variable
var config float
		BeginWaitTime,
		WaitTime,
		IntervalMin,
		IntervalMax,
		DurationMin,
		DurationMax;
var config string
		PickupItem,
		ItemMessage;

// Internal variable
var bool
		bInitialized,
		bItemActive;
var float
		RemainingTime,
		ItemCounter;
var int
		ItemInterval,
		Duration;
var name PickupName;


function PostBeginPlay()
{
	local string TempString;

	if ( bInitialized )
		return;

	bInitialized = True;
	Log("Mutator initialized.",'SMoTimeItem');

    ItemInterval =
		rand( IntervalMax - IntervalMin + 1 ) + IntervalMin + BeginWaitTime;
    Duration =
		rand( DurationMax - DurationMin + 1 ) + DurationMin;

	// Extract class name from string
	TempString = right( PickupItem, Len(PickupItem)-Instr(PickupItem,".")-1 );

	// Convert string to name so it is possible to use IsA function
	SetPropertyText("PickupName",TempString);

	SetTimer(0.5, True);

	if ( NextMutator != None )
		NextMutator.PostBeginPlay();
}

simulated function Timer()
{
	local Inventory Inv;
	local Pawn P;

	log("ItemCounter"@ItemCounter);
	log("RemainingTime"@RemainingTime);
	log("bItemActive"@bItemActive);

	if( !bItemActive )
	{
		ItemCounter += 0.5;
	}

	if( ItemCounter >= ItemInterval )
	{
		ItemCounter = 0;
		bItemActive = true;

		// Give pickup item to all player
		P = Level.PawnList;
		while ( P != none )
		{
			DisplayMessage( ItemMessage, P );
			if( P.IsA('PlayerPawn') || P.IsA('Bot') )
				GivePickup( P, PickupItem );
			P = P.nextPawn;
		}

		ItemInterval =
        	rand( IntervalMax - IntervalMin + 1 ) + IntervalMin + BeginWaitTime;
		Duration =
			rand( DurationMax - DurationMin + 1 ) + DurationMin;
		RemainingTime = Duration;
	}

	if( bItemActive )
	{
		RemainingTime -= 0.5;
	}

	if( RemainingTime <= 0.5 && bItemActive )
	{
		P = Level.PawnList;
		while ( P != none )
		{
			if( P.IsA('PlayerPawn') || P.IsA('Bot') )
			{
				for( Inv=P.Inventory; Inv!=None; Inv=Inv.Inventory )
				{
					log("Inv.IsA"@PickupName@Inv.IsA( PickupName ));

					if( Inv != none && Inv.IsA( PickupName ) )
					{
							log("Inv"@Inv);
							Inv.Destroy(); // Remove pickup
							break;  // Stop accessed none error
					}
				}
			}
			P = P.nextPawn;
		}

		bItemActive = false;
    }
}

// < Custom function >

// Special function to simulate Pickup
function GivePickup( Pawn P, string ItemClass )
{
	local class<TournamentPickup> PUClass;
	local Pickup PU;

	PUClass = class<TournamentPickup>(DynamicLoadObject(ItemClass, class'Class'));

	PU = Spawn( PUClass );

	if( PU != none )
	{
		PU.Touch( P ); // Touch player
		PU.Destroy();
	}
}

// Announce Item
function DisplayMessage( string Message, Pawn P )
{
	if( P != none && P.IsA('PlayerPawn') )
	{
			PlayerPawn(P).ClearProgressMessages();
			PlayerPawn(P).SetProgressTime(3);
			PlayerPawn(P).SetProgressMessage( Message,0 );
			P.ClientMessage( Message );
	}
}

defaultproperties
{
    BeginWaitTime=20
	WaitTime=20
    IntervalMin=5
    IntervalMax=5
    DurationMin=5
    DurationMax=5
	PickupItem="angelwing.bategg"
	ItemMessage="The Wings are out, Hit Crouch to fly!"
}
