//=============================================================================
// sgProtector.
//=============================================================================
class sgProtector expands sgBuilding;

var() sound FireSound;
var() class<projectile> ProjectileType;
var rotator sDir;
var actor targ;

function postbeginplay()
{
	super.postbeginplay();
	playerreplicationinfo.playername="Protector ";
}

function Shoot()
{
	local Vector FireSpot, ProjStart;
	local Projectile p;

	if(vsize(targ.location-location)<sightradius && targ!=none && fasttrace(targ.location) && (pawn(targ).health>1 || sgbuilding(targ).energy>0)) sdir = rotator(targ.Location - Location);
	else return;

	PlaySound(FireSound, SLOT_None,0.75);

	if(grade>2)
	{
	FireSpot = targ.Location + FMin(1, 1.1 + 0.6 * FRand()) * (targ.Velocity * VSize(targ.Location - location)/ProjectileType.Default.Speed);
		if ( !FastTrace(FireSpot, ProjStart) )
			FireSpot = 0.5 * (FireSpot + targ.Location);
		sDir = Rotator(FireSpot - location);
	}
	p = Spawn (ProjectileType,self,,location,sDir);
}

function FindEnemy()
{
		local Pawn P;

		sightradius=1000+1750*grade;

		foreach radiusactors(class'pawn',p,sightradius)
		{
			if(fasttrace(p.location) && p.playerreplicationinfo.team!=playerreplicationinfo.team && (p.health>1 || sgbuilding(p).energy>0) && p.bprojtarget)
			{
				if(targ==none) targ=p;
				if(vsize(p.location-location) < vsize(targ.location-location)) targ=p;
			}

		}
}

function timer()
{
	super.timer();
	
	if(frand()<0.05+grade/20 && scount<=0)
	{
		findenemy();
		shoot();
	}
}

defaultproperties
{
     FireSound=Sound'sgMedia.SFX.sgProtShot'
     ProjectileType=Class'Siege2x.sgProtProj'
     MaxEnergy=1200.000000
     DSofMFX=1.200000
     Model=LodMesh'Botpack.Crystal'
     NumOfMFX=3
     MFXrotX=(Pitch=20000,Yaw=20000,Roll=20000)
     SightRadius=3000.000000
     MultiSkins(0)=Texture'sgMedia.GFX.sgProtSpriteT0'
     MultiSkins(1)=Texture'sgMedia.GFX.sgProtSpriteT1'
}
