//=============================================================================
// sgProtProj.
//=============================================================================
class sgProtProj expands Projectile;

var bool bLighting;
var float DelayTime;

/////////////////////////////////////////////////////
auto state Flying
{
	simulated function ProcessTouch( Actor Other, Vector HitLocation )
	{
		local int hitdamage;
		local vector hitDir;
		
		if (Other != instigator &&  pawn(other).playerreplicationinfo.team!=sgProtector(owner).team)
		{
			if ( Role == ROLE_Authority )
			{
				hitDir = Normal(Velocity);
				if ( FRand() < 0.2 )
					hitDir *= 5;
				Other.TakeDamage(damage, instigator,HitLocation,
					(MomentumTransfer * hitDir), 'sgSpecial');
				other.PlaySound(MiscSound, SLOT_Misc, 0.7,,, 0.75+FRand()*0.5);
				spawn(class'Siege2x.sgprojimp');
			}
			Destroy();			
		}
	}

	simulated function HitWall( vector HitNormal, actor Wall )
	{
		Super.HitWall(HitNormal, Wall);	
		if (FRand()<0.3) 
			PlaySound(ImpactSound, SLOT_Misc, 0.5,,, 0.75+FRand()*0.5);
		
		MakeNoise(0.3);
	  	spawn(class'Siege2x.sgprojimp');
		destroy();
	}

	simulated function Timer()
	{
		local bubble1 b;
		if (Level.NetMode!=NM_DedicatedServer)
		{
	 		b=spawn(class'Bubble1'); 
 			b.DrawScale= 0.1 + FRand()*0.2;
 			b.SetLocation(Location+FRand()*vect(2,0,0)+FRand()*Vect(0,2,0)+FRand()*Vect(0,0,2));
 			b.buoyancy = b.mass+(FRand()*0.4+0.1);
 		}
		DelayTime+=FRand()*0.1+0.1;
		SetTimer(DelayTime,False); 	
	}

	simulated function ZoneChange( Zoneinfo NewZone )
	{
		if (NewZone.bWaterZone) 
		{
			Velocity=0.7*Velocity;	
			DelayTime=0.03;		
			SetTimer(DelayTime,False);
		}
	}

	function BeginState()
	{
		local rotator RandRot;

		Velocity = Vector(Rotation) * speed;
		RandRot.Pitch = FRand() * 200 - 100;
		RandRot.Yaw = FRand() * 200 - 100;
		RandRot.Roll = FRand() * 200 - 100;
		Velocity = Velocity >> RandRot;
		if( Region.zone.bWaterZone )
			Velocity=0.7*Velocity;
	}
}

///////////////////////////////////////////////////////
simulated function Explode(vector HitLocation, vector HitNormal)
{
}

simulated function AnimEnd()
{
	Destroy();
}

defaultproperties
{
     speed=1850.000000
     Damage=15.000000
     MomentumTransfer=7500
     ImpactSound=Sound'sgMedia.SFX.sgProtPhitW'
     MiscSound=Sound'sgMedia.SFX.sgProtPhitF'
     RemoteRole=ROLE_SimulatedProxy
     Style=STY_Translucent
     Skin=Texture'sgMedia.GFX.sgProjFront'
     Mesh=LodMesh'UnrealShare.plasmaM'
     DrawScale=0.400000
     ScaleGlow=2.000000
     AmbientGlow=255
     bUnlit=True
     MultiSkins(1)=Texture'sgMedia.GFX.sgProjSide'
     CollisionRadius=4.000000
     CollisionHeight=4.000000
}
