//=============================================================================
// sgConstructor.
//=============================================================================
class sgConstructor expands TournamentWeapon;

var() string OptionNames[12];
var() sound ChangeSound;
var() int BuildTimes[9];
var() float BuildCosts[9];
var() class<sgbuilding> BuildType[9];
var pawn IActor;
var int sOption;
var fontinfo myfonts;

replication
{
	// Things the server should send to the client.
	reliable if( bNetOwner && (Role==ROLE_Authority) )
		soption;
}

simulated function AltFire( float Value )
{
	GotoState('ChangeMode');
}

state changeMode
{	
	Begin:
	PlayOwnedSound(changeSound, SLOT_None, Pawn(Owner).SoundDampening*1.2,,,1+(FRand()*0.2-	0.4));
	soption++;
	if (soption>11) soption=0;
	Sleep(0.3);
	Finish();
}

function Fire( float F )
{	
	GotoState('build');
}

function getIActor()
{
	local actor Other;
	local vector HitLocation, HitNormal, StartTrace, EndTrace;

	iactor=none;

	StartTrace = Owner.Location;
	StartTrace.Z += Pawn(Owner).BaseEyeHeight;
	EndTrace = StartTrace + vector(playerPawn(Owner).ViewRotation) * 75;
	Other = Trace(HitLocation, HitNormal, EndTrace, StartTrace, true);

	if(other!=none && other.isa('pawn')) IActor=pawn(other);
}

state build
{
ignores Fire, altfire;

	function tick(float delatime)
	{
		if(sgpri(pawn(owner).playerreplicationinfo)!=none) 			ammotype.ammoamount=sgpri(pawn(owner).playerreplicationinfo).ru;
	}

	function beginstate()
	{
		super.beginstate();
	}

	function endstate()
	{
		super.endstate();
	}

Begin:
		
		if(soption<9) global.placeit();
		else
		{
			global.getiactor();
			global.interact();				
		}	
			
		sleep(1);
		
		finish();
}

function interact()
{
	local float amount, tmp;

	if(iactor!=none && iactor.playerreplicationinfo.team==pawn(owner).playerreplicationinfo.team)
	{
		if(soption==10)
		{
			if(!iactor.isa('sgbuilding'))
			{
				amount=fmin(fmin(150-iactor.health, 40), 	sgpri(pawn(owner).playerreplicationinfo).ru*2.5);
				iactor.health+=amount;
			sgpri(pawn(owner).playerreplicationinfo).addru(-0.2*amount);
			}
			else if(sgbuilding(iactor).scount<=0)
			{
				amount=fmin(fmin(sgbuilding(iactor).maxenergy-sgbuilding(iactor).energy, 60), 					sgpri(pawn(owner).playerreplicationinfo).ru*2.5);
				sgbuilding(iactor).energy+=amount;
				sgpri(pawn(owner).playerreplicationinfo).addru(-0.2*amount);
			}

			pawn(owner).playerreplicationinfo.score+=amount/100;

			if(amount>0) Owner.Playsound(Misc2Sound,SLOT_None, 				Pawn(Owner).SoundDampening*2.5);
			return;
		}
		else if(soption==9)
		{
			if(!iactor.isa('sgbuilding'))
			{
				tmp=sgpri(iactor.playerreplicationinfo).ru;
				sgpri(iactor.playerreplicationinfo).addru(fmin(50, 					sgpri(pawn(owner).playerreplicationinfo).ru));
				sgpri(pawn(owner).playerreplicationinfo).addru(-1*(sgpri(iactor.playerreplicationinfo).ru-tmp));

				pawn(owner).playerreplicationinfo.score+=
					(sgpri(iactor.playerreplicationinfo).ru-tmp)/100;

				iactor.Playsound(sound'sgmedia.sgpickrus',SLOT_None, 					iactor.SoundDampening*2.5);
				return;
			}
			else if(sgbuilding(iactor).scount<=0)
			{
				amount=fmin(fmin(5-sgbuilding(iactor).grade, 1), 					sgpri(pawn(owner).playerreplicationinfo).ru/
						(50+sgbuilding(iactor).grade*50));
				sgpri(pawn(owner).playerreplicationinfo).addru(-					1*(50+sgbuilding(iactor).grade*50)*amount);
				sgbuilding(iactor).grade+=amount;

				pawn(owner).playerreplicationinfo.score+=amount;

				if(amount>0) Owner.Playsound(Misc3Sound,SLOT_None, 					pawn(Owner).SoundDampening*2.5);
					
				return;
			}		
		}
		else
		{
			if(sgbasecore(iactor)==none && sgbuilding(iactor)!=none && sgbuilding(iactor).playerreplicationinfo.team==pawn(owner).playerreplicationinfo.team)
			{ 
			   
				sgpri(pawn(owner).playerreplicationinfo).addru(sgbuilding(iactor).buildcost/2);
				sgbuilding(iactor).destruct();	
				return;
 	
			}
		}
	}
	Owner.Playsound(Misc1Sound,SLOT_Misc, Pawn(Owner).SoundDampening*2.5);
}		

function placeIt()
{
	local sgbuilding test;	

	if(sgpri(pawn(owner).playerreplicationinfo).ru<buildcosts[soption])
	{
		Owner.Playsound(Misc1Sound,SLOT_Misc, Pawn(Owner).SoundDampening*2.5);
		return;
	}

	test=spawn(buildtype[soption],owner,,(owner.location-vect(0,0,8))+vector(pawn(owner).viewrotation)*45,pawn(owner).viewrotation);

	if(test!=none)
	{
		test.buildtime=buildtimes[soption];
		test.buildcost=buildcosts[soption];
		Owner.Playsound(FireSound,SLOT_None, Pawn(Owner).SoundDampening*2.5);
		sgpri(pawn(owner).playerreplicationinfo).ru-=buildcosts[soption];
		pawn(owner).playerreplicationinfo.score+=buildcosts[soption]/100;
	}
	else Owner.Playsound(Misc1Sound,SLOT_Misc, Pawn(Owner).SoundDampening*2.5);
}

function tick(float delatime)
{
	if(sgpri(pawn(owner).playerreplicationinfo)!=none) 		ammotype.ammoamount=sgpri(pawn(owner).playerreplicationinfo).ru;
}


state Idle
{
	function tick(float delatime)
	{
		if(sgpri(pawn(owner).playerreplicationinfo)!=none) 			ammotype.ammoamount=sgpri(pawn(owner).playerreplicationinfo).ru;
	}

	Begin:
	bPointing=False;
	if ( Pawn(Owner).bFire!=0) pawn(owner).stopfiring();	
}

function DropFrom(vector StartLocation)
{
     if ( !SetLocation(StartLocation) )
          return; 	
    destroy();
}

function playselect()
{
}

function tweendown()
{
}

defaultproperties
{
     OptionNames(0)="Protector"
     OptionNames(1)="SuperProt"
     OptionNames(2)="Supplier"
     OptionNames(3)="SupplierX"
     OptionNames(4)="HealthPod"
     OptionNames(5)="Container"
     OptionNames(6)="CubeX"
     OptionNames(7)="Warhead"
     OptionNames(8)="IWarhead"
     OptionNames(9)="Upgrade"
     OptionNames(10)="Repair"
     OptionNames(11)="Remove"
     ChangeSound=Sound'sgMedia.SFX.sgChng'
     BuildTimes(0)=30
     BuildTimes(1)=30
     BuildTimes(2)=45
     BuildTimes(3)=60
     BuildTimes(4)=45
     BuildTimes(5)=30
     BuildTimes(6)=30
     BuildTimes(7)=120
     BuildTimes(8)=240
     BuildCosts(0)=100.000000
     BuildCosts(1)=500.000000
     BuildCosts(2)=300.000000
     BuildCosts(3)=800.000000
     BuildCosts(4)=250.000000
     BuildCosts(5)=125.000000
     BuildCosts(6)=900.000000
     BuildCosts(7)=1300.000000
     BuildCosts(8)=2000.000000
     BuildType(0)=Class'Siege2x.sgProtector'
     BuildType(1)=Class'Siege2x.sgSProtector'
     BuildType(2)=Class'Siege2x.sgSupplier'
     BuildType(3)=Class'Siege2x.sgSupplierX'
     BuildType(4)=Class'Siege2x.sgHealthPod'
     BuildType(5)=Class'Siege2x.sgContainer'
     BuildType(6)=Class'Siege2x.sgContainerX'
     BuildType(7)=Class'Siege2x.sgWarhead'
     BuildType(8)=Class'Siege2x.sgIWarhead'
     AmmoName=Class'Siege2x.sgAmmo'
     bCanThrow=False
     FireSound=Sound'sgMedia.SFX.sgCnstrct'
     Misc1Sound=Sound'sgMedia.SFX.sgNoRUs'
     Misc2Sound=Sound'sgMedia.SFX.sgRepair'
     Misc3Sound=Sound'sgMedia.SFX.sgUpgrade'
     MessageNoAmmo=" has no RUs."
     DeathMessage="%o was killed %k's Orb."
     InventoryGroup=10
     PickupMessage="You are equipped with the Constructor"
     ItemName="Constructor"
}
