//=============================================================================
// sgWarhead.
// * Revised by 7DS'Lust
//=============================================================================
class sgWarhead extends sgItem;

//var bool Played;
var class<CriticalEventPlus> MessageClass;
var Pawn Damager;

function PostBeginPlay()
{
	local Pawn p;

	Super.PostBeginPlay();

    if ( MessageClass == None )
        return;

	for ( p = Level.PawnList; p != None; p = p.nextPawn )
	{
		if ( p.IsA('TournamentPlayer' ) && p.PlayerReplicationInfo != None && 
          p.PlayerReplicationInfo.Team != Team )
			p.ReceiveLocalizedMessage(MessageClass, Team);
	}
}

event TakeDamage( int damage, Pawn instigatedBy, Vector hitLocation, 
  Vector momentum, name damageType )
{
    Damager = instigatedBy;
    Super.TakeDamage(damage, instigatedBy, hitLocation, momentum, damageType);
}

function Destruct()
{
    local PlayerReplicationInfo pri1, pri2;
    if ( Pawn(Owner) != None )
        pri1 = Pawn(Owner).PlayerReplicationInfo;
    if ( Damager != None )
        pri2 = Damager.PlayerReplicationInfo;
    BroadcastLocalizedMessage(class'sgBuildingKillMsg',, pri1, pri2,
      Self);
    Super.Destruct();
}

function PlayFinishSound()
{
    PlaySound(FinishSound, SLOT_None, 5);
}

function Inventory GiveItem(Pawn target)
{
    local Pawn p;
    local Inventory inv;
    inv = Super.GiveItem(target);
    if ( inv != None )
    {
        target.PlaySound(sound'sgMedia.sgGetNuke', SLOT_None,
          target.SoundDampening*3);
	if (target.DrawScale < Target.default.DrawScale)
	{

        	for ( p = Level.PawnList; p != None; p = p.nextPawn )
            		if ( p.IsA('TournamentPlayer') &&
              		p.PlayerReplicationInfo.Team != Team )
                		TournamentPlayer(P).ReceiveLocalizedMessage(class'sgMidgetWarnMsg');
	}
    }
    return inv;
}

defaultproperties
{
    MessageClass=Class'sgNukeBuildMsg'
    FinishSound=Sound'sgMedia.SFX.sgWarAppear'
    InventoryClass=Class'sgNukeLauncher'
    AmmoAmount=1
    SwitchToWeapon=True
    BuildingName="Warhead"
    BuildCost=1300
    UpgradeCost=1000
    BuildTime=120.00
    SpriteScale=0.80
    Model=LodMesh'Botpack.missile'
    DSofMFX=1.50
}
