//=============================================================================
// sgSupplier.
// * Revised by 7DS'Lust
//=============================================================================
class sgSupplier extends sgEquipmentSupplier;

var() config string Weapons[9];
var() bool            ClassesLoaded;
var() class<Weapon> WeaponClasses[9];
var() float         EquipRate;
var bool	bProtected;
var bool AnnounceImmunity;
var int Count;
var config int SuppProtectTimeSecs;

function AnnounceTeam(string sMessage, int iTeam)
{
    local Pawn p;

    for ( p = Level.PawnList; p != None; p = p.nextPawn )
	    if ( (p.bIsPlayer || p.IsA('MessagingSpectator')) &&
          p.PlayerReplicationInfo != None && p.playerreplicationinfo.Team == iTeam )
		    p.ClientMessage(sMessage);
}


simulated event PostBeginPlay()
{
	local Pawn p;
	local sgSupplier sgS;
	local int nSuppliers;
	local string sLocation;

        if ( Pawn(owner).PlayerReplicationInfo.PlayerLocation != None )
            sLocation = PlayerReplicationInfo.PlayerLocation.LocationName;
        else if ( Pawn(owner).PlayerReplicationInfo.PlayerZone != None )
            sLocation = Pawn(owner).PlayerReplicationInfo.PlayerZone.ZoneName;
	if ( sLocation != "" && sLocation != " ")
	    sLocation = "at"@sLocation;

	Super.PostBeginPlay();
	bProtected = true;
	if (SiegeGI(Level.Game).SupplierProtection)
	{
    		for ( p = Level.PawnList; p != None; p = p.nextPawn )
	    		if ( p.IsA('sgSupplier'))
			{
				sgS=sgSupplier(p);
				if (sgS.Team == Team) nSuppliers++;
			}
	}
	if (nSuppliers>1) bProtected = false;
	else if (AnnounceImmunity)
		AnnounceTeam("Your team have built a Supplier"@sLocation, Team);
}

simulated event Timer()
{
	local string Tcolour;
	Super.Timer();
	count++;
	if (count>=(SuppProtectTimeSecs*10) && bProtected)
	{	
		bProtected = false;
		if (AnnounceImmunity) AnnounceTeam("Your team Supplier immunity has expired.", Team);
	}
}

simulated event TakeDamage( int damage, Pawn instigatedBy, Vector hitLocation, 
  Vector momentum, name damageType )
{
	if (!bProtected)
		Super.TakeDamage(damage, instigatedBy, hitLocation, momentum, damageType);
}

function int GetWeaponCount()
{
    if ( Grade < 2 )
        return 3;
    else if ( Grade < 3 )
        return 5;
    else if ( Grade < 4 )
        return 6;
	else if ( Grade < 5 )
        return 8;
	else if ( Grade >= 5 )
        return 9;
    return 3;
}

static function LoadWeaponClasses()
{
    local int i;
    local class<Weapon> weaponClass;

    default.ClassesLoaded = true;
    for ( i = 0; i < 9; i++ )
        if ( default.Weapons[i] != "" )
            default.WeaponClasses[i] =
              class<Weapon>(DynamicLoadObject(default.Weapons[i],
              class'Class'));
}

function Supply(Pawn target)
{
    local int       numWeapons,
                    i;
    local Inventory inv;

    if ( !default.ClassesLoaded )
        LoadWeaponClasses();

    numWeapons = GetWeaponCount();

    for ( i = 0; i < numWeapons; i++ )
    {
        if ( default.WeaponClasses[i] == None )
            continue;

        inv = target.FindInventoryType(default.WeaponClasses[i]);
        if ( inv != None && Weapon(inv) != None &&
          Weapon(inv).AmmoType != None )
        {
            if ( Weapon(inv).AmmoType.AmmoAmount <
              Weapon(inv).PickupAmmoCount / 2 )
                Weapon(inv).AmmoType.AmmoAmount =
                  Weapon(inv).PickupAmmoCount / 2;
            else if ( FRand() < float(Weapon(inv).AmmoType.MaxAmmo) / 400 )
                Weapon(inv).AmmoType.AmmoAmount = FMin(
                  Weapon(inv).AmmoType.AmmoAmount + 1 +
                  int(FRand()*Grade/2*EquipRate),
                  Weapon(inv).AmmoType.MaxAmmo);
        }
    }

    inv = target.FindInventoryType(class'sgArmor');
    if ( inv == None )
    {
        inv = Spawn(class'sgArmor');
        if ( inv != None )
            inv.GiveTo(target);
    }
    if ( inv != None && FRand() < 0.1 + (Grade/15) && inv.Charge < 25 +
      Grade*25 )
        inv.Charge = FMin(inv.Charge + 1, 25 + grade * 25 );

    if ( FRand() < 0.2 )
        target.PlaySound(sound'sgMedia.sgStockUp', SLOT_Misc,
          target.SoundDampening*2.5);
}

defaultproperties
{
    Weapons(0)="SiegeXXLyRC1.sgEnforcer"
    Weapons(1)="Botpack.ut_biorifle"
    Weapons(2)="Botpack.ShockRifle"
    Weapons(3)="Botpack.PulseGun"
    Weapons(4)="Botpack.ripper"
    Weapons(5)="SiegeXXLyRC1.sgMinigun"
    Weapons(6)="Botpack.UT_FlakCannon"
    Weapons(7)="Botpack.UT_Eightball"
    Weapons(8)="Botpack.SniperRifle"
    EquipRate=1.00
    AnnounceImmunity=True
    SuppProtectTimeSecs=600
    BuildingName="Supplier"
    BuildCost=300
    BuildTime=45.00
    MaxEnergy=1500.00
    Model=LodMesh'Botpack.ShockWavem'
    DSofMFX=2.00
    MFXrotX=(Pitch=5000,Yaw=5000,Roll=5000),
    MultiSkins(0)=Texture'sgMedia.GFX.sgSupSpriteT0'
    MultiSkins(1)=Texture'sgMedia.GFX.sgSupSpriteT1'
    MultiSkins(2)=Texture'sgMedia2.GFX.sgSupSpriteT2'
    MultiSkins(3)=Texture'sgMedia2.GFX.sgSupSpriteT3'
}
