//=============================================================================
// sgBooster.
// * Revised by 7DS'Lust
//=============================================================================
class sgSuperBooster extends sgBuilding;

var sound           BoostSound;
var float           RepairTimer;

simulated event Timer()
{
    Super.Timer();

    if ( SCount > 0 || Role != ROLE_Authority || RepairTimer > 0 )
        return;

    Energy = FMin(Energy + 18, MaxEnergy);
}

simulated event Tick(float deltaTime)
{
    Super.Tick(deltaTime);

    if ( Role == ROLE_Authority && RepairTimer > 0 )
        RepairTimer -= deltaTime;
}

event TakeDamage( int Damage, Pawn instigatedBy, Vector hitLocation, 
  Vector momentum, name damageType)
{
    RepairTimer = 6;
    Super.TakeDamage(Damage * (1 - Grade*0.05), instigatedBy, hitLocation,
      momentum, damageType);
}

event Touch(Actor other)
{
    if ( SCount <= 0 && Pawn(other) != None && Pawn(other).bIsPlayer &&
      Pawn(other).PlayerReplicationInfo != None &&
      Pawn(other).PlayerReplicationInfo.Team == Team )
    {
        PendingTouch = other.PendingTouch;
        other.PendingTouch = self;
        PlaySound(BoostSound);
        PlaySound(BoostSound);
    }
}

event PostTouch(Actor other)
{
    local Pawn target;
    local float boost;
    local float Zboost;

    if ( SCount > 0 || Pawn(other) == None )
        return;

    target = Pawn(other);

    if ( target.IsA('Bot') )
    {
        if ( target.Physics == PHYS_Falling )
            Bot(target).bJumpOffPawn = true;
        Bot(target).SetFall();
    }
    if ( target.Physics != PHYS_Swimming )
        target.SetPhysics(PHYS_Falling);
    Zboost = 120 * (Grade + 5);
    boost = Grade;
/*    if ( target.Velocity.Z < -1800 )
    {
        target.Velocity.X += boost;
        target.Velocity.Y += boost;
        target.Velocity.Z += Zboost;
    }
    else if ( target.Velocity.Z < boost )
    {
*/
        target.Velocity.X *= boost;
        target.Velocity.Y *= boost;
        target.Velocity.Z += Zboost;

//    }
}

defaultproperties
{
    BoostSound=Sound'UnrealI.Pickups.BootJmp'
    BuildingName="Super Booster"
    BuildCost=1200
    UpgradeCost=75
    BuildTime=15.00
    MaxEnergy=2500.00
    Model=LodMesh'Botpack.Crystal'
    DSofMFX=0.95
    MFXrotX=(Pitch=50000,Yaw=50000,Roll=50000),
    MultiSkins(0)=Texture'sgMedia.GFX.sgContSpriteT0'
    MultiSkins(1)=Texture'sgMedia.GFX.sgContSpriteT1'
    MultiSkins(2)=Texture'sgMedia2.GFX.sgContSpriteT2'
    MultiSkins(3)=Texture'sgMedia2.GFX.sgContSpriteT3'
    CollisionHeight=30.00
}
