//=============================================================================
// sgShrinker.
// Revised by nOs*Badger
//=============================================================================
class sgShrinker extends sgBuilding;

var Pawn            Target;

function Pawn FindTarget()
{
	local Pawn p;

	foreach RadiusActors(class'Pawn', p, 60)
		if ( p.bIsPlayer && p.Health > 0 &&
          p.PlayerReplicationInfo != None &&
          p.PlayerReplicationInfo.Team == Team)
			return p;

    return None;
}

function Timer()
{
	Super.Timer();

	if ( SCount > 0 )
        return;

	if ( Target == None || VSize(Location - Target.Location) > 60 )
        Target = FindTarget();

	if ( Target != None )
	{
        if ( FRand() < 0.5 )
        {
            Target.DrawScale = FMax(Target.DrawScale -
              0.01 * Target.default.DrawScale,
              (1 - Grade/10) * Target.default.DrawScale);
            Target.GroundSpeed = FMax(Target.GroundSpeed -
              0.01 * Target.default.GroundSpeed,
              (1 - Grade/10) * Target.default.GroundSpeed);
            Target.SetCollisionSize(
              FMax(Target.CollisionRadius -
              0.01 * Target.default.CollisionRadius,
              (1 - Grade/10) * Target.default.CollisionRadius),
              FMax(Target.CollisionHeight -
              0.01 * Target.default.CollisionHeight,
              (1 - Grade/10) * Target.default.CollisionHeight));
        }

        if ( FRand() < 1.00 )
            Target.PlaySound(sound'sgMedia.sgStockUp', SLOT_Misc,
              Target.SoundDampening*2.5);
	}
}

defaultproperties
{
    BuildingName="Shrinker"
    BuildCost=1500
    UpgradeCost=200
    BuildTime=15.00
    MaxEnergy=2000.00
    Model=LodMesh'Botpack.Module'
    DSofMFX=3.80
    NumOfMFX=3
    MFXrotX=(Pitch=20000,Yaw=20000,Roll=20000),
    MultiSkins(0)=Texture'sgMedia.GFX.sgContSpriteT0'
    MultiSkins(1)=Texture'sgMedia.GFX.sgContSpriteT1'
    MultiSkins(2)=Texture'sgMedia2.GFX.sgContSpriteT2'
    MultiSkins(3)=Texture'sgMedia2.GFX.sgContSpriteT3'
    CollisionHeight=32.00
}
