//=============================================================================
// KillerProtector.
// * Made by nOs*Badger
//=============================================================================
class sgKillerProtector extends sgProtector;


simulated event Timer()
{
	Super.Timer();
}


simulated function bool ShouldAttack(Pawn enemy)
{
    local UT_Invisibility inv;
    local bool bInv;


    if ( enemy == None )
        return false;
    if ( !FastTrace(enemy.Location) )
        return false;
    if (enemy.bIsPlayer && enemy.PlayerReplicationInfo != None && enemy.PlayerReplicationInfo.Team != Team)
    {
    	inv = UT_Invisibility(enemy.FindInventoryType(class'UT_Invisibility'));
    	if (inv != None && inv.charge > 160) return false;
    }
    if ( sgBuilding(enemy) != None )
    {
        if ( sgBuilding(enemy).Team == Team || sgBuilding(enemy).Energy < 0 )
            return false;
    }
    else if ( enemy.PlayerReplicationInfo == None ||
      enemy.PlayerReplicationInfo.Team == Team ||
      enemy.Health <= 0 ||
      !enemy.bProjTarget)
        return false;
    return true;
}

simulated function string KillMessage( name damageType, pawn Other )
{
    local string s;
    s=Pawn(Owner).PlayerReplicationInfo.PlayerName;
    if (s!="" && s!=" ")
         s="built by"@s;
    return (""@Other.PlayerReplicationInfo.PlayerName@"was killed by a"@BuildingName@s);
}

function bool ShouldFire()
{
    return ( FRand() < 0.05 + Grade/40 );
}


defaultproperties
{
    ProjectileType=Class'sgKillerProtProj'
    BuildingName="Killer Protector"
    BuildCost=2000
    MaxEnergy=3000.00
    Model=LodMesh'Botpack.PlainStud'
    DSofMFX=3.00
}
