//=============================================================================
// sgHealthPod.
// * Revised by 7DS'Lust
//=============================================================================
class sgHealthPod extends sgEquipmentSupplier;

function Supply(Pawn target)
{
	local Inventory inv;

    inv = target.FindInventoryType(class'sgArmor');
    if ( inv == None )
    {
        inv = Spawn(class'sgArmor', target);
        if ( inv != None )
            inv.GiveTo(target);
    }
    if ( inv != None && FRand() < 0.1 + (Grade/15) && inv.Charge < 25 +
      Grade*25 )
        inv.Charge = FMin(inv.Charge + 1, 25 + grade * 25 );
	
	if ( FRand() < 0.1 + (Grade/40) && Target.Health < 60 + (grade*15) )
        Target.Health = Target.Health + 1;
	
	if ( FRand() < 0.2 )
        Target.PlaySound(sound'sgMedia.sgStockUp', SLOT_Misc,
          Target.SoundDampening*2.5);
}

defaultproperties
{
    BuildingName="Health Pod"
    BuildCost=250
    UpgradeCost=35
    BuildTime=45.00
    MaxEnergy=2500.00
    Model=LodMesh'Botpack.BigSprocket'
    DSofMFX=1.25
    MFXrotX=(Pitch=0,Yaw=5000,Roll=0),
    MultiSkins(0)=Texture'sgMedia.GFX.sgSupSpriteT0'
    MultiSkins(1)=Texture'sgMedia.GFX.sgSupSpriteT1'
    MultiSkins(2)=Texture'sgMedia2.GFX.sgSupSpriteT2'
    MultiSkins(3)=Texture'sgMedia2.GFX.sgSupSpriteT3'
}
