//=============================================================================
// sgContainer.
// * Revised by 7DS'Lust
//=============================================================================
class sgContainer extends sgBuilding;

//var bool DoneYet;
var() int StorageAmount;

simulated event Timer()
{
	local sgBuilding building;

	Super.Timer();

	if ( SCount > 0 || Role != ROLE_Authority )
        return;

	foreach RadiusActors(class'sgBuilding', building, 224+16*Grade)
		if ( sgBaseCore(building) == None && FRand() <= 0.5 + Grade/5
          && building.Team == Team)
        {
            if ( sgContainerX(building) != None )
                building.Energy = FMin(building.Energy + (1 + Grade/5)/5,
                  building.MaxEnergy);

            else
			    building.Energy = FMin(building.Energy + 1 + Grade/5,
                  building.MaxEnergy);
        }
}

simulated function FinishBuilding()
{
    Super.FinishBuilding();

    SetCollision(true, true, true);
    bProjTarget = true;

    if ( SiegeGI(Level.Game) != None )
    {
        SiegeGI(Level.Game).MaxRus[Team] += StorageAmount;
        SiegeGI(Level.Game).MaxRus[Team] =
          FMax(SiegeGI(Level.Game).MaxRUs[Team], 300);
    }
}

event Destroyed()
{
    Super.Destroyed();

    if ( DoneBuilding && SiegeGI(Level.Game) != None )
        SiegeGI(Level.Game).MaxRUs[Team] -= StorageAmount;
}

function Upgraded()
{
    local float percent;
    local float scale;

    if ( SiegeGI(Level.Game) != None )
    {
        if ( Grade < 2 )
            scale = 1;
        else if ( Grade < 3 )
            scale = 2;
        else if ( Grade < 5 )
            scale = 3;
        else if ( Grade >= 5 )
            scale = 4;
        SiegeGI(Level.Game).MaxRus[Team] -= StorageAmount;
        StorageAmount = default.StorageAmount + 50 * scale;
        SiegeGI(Level.Game).MaxRus[Team] += StorageAmount;
        percent = Energy/MaxEnergy;
        MaxEnergy = default.MaxEnergy * (1 + Grade/2);
        Energy = percent * MaxEnergy;
    }
}

defaultproperties
{
    StorageAmount=50
    BuildingName="Container"
    BuildCost=125
    UpgradeCost=25
    MaxEnergy=2000.00
    Model=LodMesh'Botpack.CubeGem'
    DSofMFX=2.50
    MFXrotX=(Pitch=2500,Yaw=2500,Roll=2500),
    MultiSkins(0)=Texture'sgMedia.GFX.sgContSpriteT0'
    MultiSkins(1)=Texture'sgMedia.GFX.sgContSpriteT1'
    MultiSkins(2)=Texture'sgMedia2.GFX.sgContSpriteT2'
    MultiSkins(3)=Texture'sgMedia2.GFX.sgContSpriteT3'
    CollisionRadius=32.00
    CollisionHeight=32.00
}
