//=============================================================================
// sgConstructor.
// * Revised by 7DS'Lust
//=============================================================================
class sgConstructor extends TournamentWeapon
    config;

#exec Obj Load File=Activates.uax

var() Sound         ChangeSound,
                    SelectSound,
                    DeselectSound;
var() class<sgBuildCategory>
                    BuildCategories[16];
var() int           NumBuildCategories;
var() int	    NumActions;
var int             Category,
                    Selection;
var FontInfo        MyFonts;
var config bool     AllowTeamRemove;

replication
{
	// Things the server should send to the client.
	reliable if ( bNetOwner && (Role==ROLE_Authority) )
		Category, Selection;

    reliable if ( Role < ROLE_Authority )
        SetMode, SelectMode;
}

function Tick(float delaTime)
{
	if ( Pawn(Owner) != None && sgPRI(Pawn(Owner).PlayerReplicationInfo) !=
      None && AmmoType != None )
        AmmoType.AmmoAmount = sgPRI(Pawn(Owner).PlayerReplicationInfo).RU;
}

function DropFrom(vector startLocation)
{
    if ( !SetLocation(startLocation) )
        return;
    Destroy();
}

function Fire( float F )
{
	GotoState('Build');
}

function AltFire( float Value )
{
	GotoState('ChangeMode');
}

function Pawn GetTarget()
{
	local Actor other;
	local vector    hitLocation,
                    hitNormal,
                    startTrace,
                    endTrace;

	startTrace = Owner.Location;
	startTrace.Z += Pawn(Owner).BaseEyeHeight;
	endTrace = startTrace + vector(PlayerPawn(Owner).ViewRotation) * 90;
	other = Trace(hitLocation, hitNormal, endTrace, startTrace, true);

    return Pawn(other);
}

function AnnounceRemove(sgBuilding building, Pawn remover)
{
    local string removeMessage;
    local Pawn p;

    if ( building.Owner == remover || remover.PlayerReplicationInfo == None )
        return;

    if ( Pawn(building.Owner) != None && Pawn(building.Owner).bIsPlayer &&
      Pawn(building.Owner).PlayerReplicationInfo != None)
        removeMessage = remover.PlayerReplicationInfo.PlayerName@
          "removed"@Pawn(building.Owner).PlayerReplicationInfo.PlayerName$
          "'s"@building.BuildingName;
    else if (Len(building.BuildingName) >= 1 && (
      Left(building.BuildingName, 1) ~= "a" ||
      Left(building.BuildingName, 1) ~= "e" ||
      Left(building.BuildingName, 1) ~= "i" ||
      Left(building.BuildingName, 1) ~= "o" ||
      Left(building.BuildingName, 1) ~= "u") )
        removeMessage = remover.PlayerReplicationInfo.PlayerName@
          "removed an"@building.BuildingName;
    else
        removeMessage = remover.PlayerReplicationInfo.PlayerName@
          "removed a"@building.BuildingName;

    for ( p = Level.PawnList; p != None; p = p.nextPawn )
	    if ( (p.bIsPlayer || p.IsA('MessagingSpectator')) &&
          p.PlayerReplicationInfo != None &&
          p.PlayerReplicationInfo.Team == building.Team )
		    p.ClientMessage(removeMessage);
}

function AnnounceAll(string sMessage)
{
    local Pawn p;

    for ( p = Level.PawnList; p != None; p = p.nextPawn )
	    if ( (p.bIsPlayer || p.IsA('MessagingSpectator')) &&
          p.PlayerReplicationInfo != None  )
		    p.ClientMessage(sMessage);
}

function bool DoesPlayerExist(Pawn target)
{
    local Pawn p;
    for ( p = Level.PawnList; p != None; p = p.nextPawn )
	if ( p == target )
	    if ( p.bIsPlayer && p.PlayerReplicationInfo != None)
		return true;

	return false;
}

function UseFunction(Pawn target)
{
	local float     amount,
                    tmp;
    local sgPRI     ownerPRI;
	local sgRemoveProt sgRP;
	local string sMessage;


    if ( Pawn(Owner) == None || sgPRI(Pawn(Owner).PlayerReplicationInfo) ==
      None)
        return;
    ownerPRI = sgPRI(Pawn(Owner).PlayerReplicationInfo);

    if ( target == None || (sgBuilding(target) != None &&
      sgBuilding(target).Team != ownerPRI.Team) ||
      (sgBuilding(target) == None && (target.PlayerReplicationInfo == None ||
      target.PlayerReplicationInfo.Team != ownerPRI.Team)) )
    {
        Owner.Playsound(Misc1Sound, SLOT_Misc, Pawn(Owner).SoundDampening*2.5);
        return;
    }

    switch ( Category )
    {
    case 0:
        // Upgrade mode

		if ( sgBuilding(target) != None )
		{
            // Upgrade building

            if ( sgBuilding(target).SCount <= 0 )
            {
                amount = FMin(5 - sgBuilding(target).Grade, 1);

                if ( SiegeGI(Level.Game) == None ||
                  !SiegeGI(Level.Game).FreeBuild )
                {
                    amount = FMin(amount, ownerPRI.RU /
                      (sgBuilding(target).UpgradeCost *
                      (sgBuilding(target).Grade + 1)));

			        ownerPRI.AddRU(-1 * (sgBuilding(target).UpgradeCost *
                      (sgBuilding(target).Grade + 1)) * amount);
                      ownerPRI.Score += amount;
                }

			    sgBuilding(target).Grade += amount;

			    if ( amount > 0 )
                {
                    sgBuilding(target).Upgraded();
                    Owner.PlaySound(Misc3Sound, SLOT_None,
                      pawn(Owner).SoundDampening*2.5);
                }
            }
            else
                Owner.PlaySound(Misc1Sound, SLOT_Misc,
                   Pawn(Owner).SoundDampening*2.5);
		}
		else
        {
            // Give target player RU

			tmp = sgPRI(target.PlayerReplicationInfo).RU;
			sgPRI(target.PlayerReplicationInfo).AddRU(FMin(100, ownerPRI.RU));
			ownerPRI.AddRU(-1 * (sgPRI(target.PlayerReplicationInfo).RU -
              tmp));
			ownerPRI.Score += (sgPRI(target.PlayerReplicationInfo).RU - tmp) /
              100;

			target.PlaySound(sound'sgMedia.sgPickRUs', SLOT_None,
              target.SoundDampening*2.5);
				
			return;
		}
        break;

    case 1:
        // Repair mode

		if ( target.IsA('sgBuilding') )
		{
            // Repair building
            if ( sgBuilding(target).SCount <= 0 )
            {
                amount = FMin(sgBuilding(target).MaxEnergy - 
                  sgBuilding(target).Energy, 60);
                
                if ( SiegeGI(Level.Game) == None ||
                  !SiegeGI(Level.Game).FreeBuild )
                {
                    amount = FMin(amount, ownerPRI.RU * 2.5);
                    ownerPRI.AddRU(-0.2 * amount);
                }

			    sgBuilding(target).Energy += amount;
            }
		}
		else
		{
            // Repair player
			amount = FMin(FMin(150 - target.Health, 40), ownerPRI.RU * 2.5);
			target.Health += amount;

            if ( SiegeGI(Level.Game) == None ||
              !SiegeGI(Level.Game).FreeBuild )
			    ownerPRI.AddRU(-0.2 * amount);
		}

		ownerPRI.Score += amount/100;

		if( amount > 0 )
            Owner.PlaySound(Misc2Sound, SLOT_None,
              Pawn(Owner).SoundDampening*2.5);

        break;
	
    case 2:
        // Remove mode

//		if ( (sgBuilding(target) != None && sgBaseCore(target) == None &&
//         (sgBuilding(target).Team == ownerPRI.Team || AllowTeamRemove) ) && 
//	  (sgBuilding(target).sPlayerIP == PlayerPawn(Owner).GetPlayerNetworkAddress()) && DoesPlayerExist(PlayerPawn(Owner)))

		if ( (sgBuilding(target) != None && sgBaseCore(target) == None &&
          (sgBuilding(target).Team == ownerPRI.Team || AllowTeamRemove) ) )

		{
			if (sgBuilding(target).sPlayerIP != PlayerPawn(Owner).GetPlayerNetworkAddress())
			{
			sgRP=sgRemoveProt(Pawn(Owner).FindInventoryType(class'sgRemoveProt'));
			if ( sgRP != None )
			{
				sgRP.AddRemove();
				if ( sgRP.RemoveWarning() ) 
				{
					sMessage="Player "@Pawn(Owner).PlayerReplicationInfo.PlayerName@" has been warned for Team Removing.";
					AnnounceAll(sMessage);
				}
				if ( sgRP.ExcessRemove() ) 
				{
					sMessage="Player "@Pawn(Owner).PlayerReplicationInfo.PlayerName@" was kicked for being a Team Remover.";
					AnnounceAll(sMessage);
					KickPawn(Pawn(Owner));
				}
			}
			else
			{
				sgRP = Spawn(class'sgRemoveProt', Pawn(Owner), 'sgRemoveProt', Pawn(Owner).Location, Pawn(Owner).Rotation);
				if ( sgRP != None )
				{
					sgRP.bHeldItem = True;
					sgRP.GiveTo(Pawn(Owner));
					sgRP.Activate();
				}

			}
			}
	                AnnounceRemove(sgBuilding(target), Pawn(Owner));

            // Don't give back ru in free build mode
            if ( SiegeGI(Level.Game) == None ||
              !SiegeGI(Level.Game).FreeBuild )
			    ownerPRI.AddRU(sgBuilding(target).BuildCost/2);

			sgBuilding(target).Destruct();
			return;
		}
        else
            Owner.PlaySound(Misc1Sound, SLOT_Misc,
              Pawn(Owner).SoundDampening*2.5);
        break;

    case 3:
        // Cloak mode
	if ( (sgBuilding(target) != None && sgBaseCore(target) == None &&
          (sgBuilding(target).Team == ownerPRI.Team || AllowTeamRemove) ) )

		{	
			amount = sgBuilding(target).BuildCost/5;
			if (SiegeGI(Level.Game).FreeBuild) amount = 0;
			if (ownerPRI.RU >= amount && sgBuilding(target).DSofMFX > 0 && !target.IsA('sgContainer'))
			{
    				Spawn(class'sgFlash');
				sgBuilding(target).PlaySound(sound'Unreali.dampndea',, 10.0);
				/*
				sgBuilding(target).SetDisplayProperties(ERenderStyle.STY_Translucent, 
                             	FireTexture'unrealshare.Belt_fx.Invis',
                             	true,
                             	true);
				*/
				sgBuilding(target).Cloak();
				ownerPRI.AddRU(amount * -1);
			}			
			else
		            Owner.PlaySound(Misc1Sound, SLOT_Misc, Pawn(Owner).SoundDampening*2.5);
		}
        else
            Owner.PlaySound(Misc1Sound, SLOT_Misc,
              Pawn(Owner).SoundDampening*2.5);
	}
}

function KickPawn(Pawn target)
{
	target.destroy();
/*
	local PlayerPawn p;
	local string s;
	p=PlayerPawn(target);
	p.kick(Pawn(Owner).PlayerReplicationInfo.PlayerName);
	//s = p.ConsoleCommand("kickban"@target.PlayerReplicationInfo.PlayerName);
*/
}

function bool CanIMakeMoreTeleportersPlease()
{
	local Pawn p;
	local sgTeleporter teleDest;
	local int iTeleporters;
	local string sTeleporterName;

	sTeleporterName=PlayerPawn(Owner).GetPlayerNetworkAddress()@string(PlayerPawn(Owner).PlayerReplicationInfo.Team);
	//AnnounceAll(sTeleporterName);
    	for ( p = Level.PawnList; p != None; p = p.nextPawn )
		if (p.IsA('sgTeleporter'))
		{
			teleDest=sgTeleporter(p);
			if (teleDest.URL1 == sTeleporterName)
			{
				if (VSize(PlayerPawn(Owner).location - teleDest.location) < 100) return false;
				iTeleporters++;

			}
		}
	if (iTeleporters<2) return true;
	return false;
}


function PlaceIt()
{
    local sgPRI     ownerPRI;
    local class<sgBuilding>
                    type;
	local sgBuilding
                    test;


    if ( Pawn(Owner) == None || sgPRI(Pawn(Owner).PlayerReplicationInfo) ==
      None)
        return;
    ownerPRI = sgPRI(Pawn(Owner).PlayerReplicationInfo);

    type = GetBuildType();

    if ( type == None )
        return;


	if (string(type)~="SiegeXXLyRC1.sgTeleporter")
		if (!CanIMakeMoreTeleportersPlease())
		{
			Owner.PlaySound(Misc1Sound, SLOT_Misc, Pawn(Owner).SoundDampening*2.5);
			return;
		}



	if (!(SiegeGI(Level.Game) != None && SiegeGI(Level.Game).FreeBuild)
      && ownerPRI.RU < type.default.BuildCost )
	{
		Owner.PlaySound(Misc1Sound, SLOT_Misc, Pawn(Owner).SoundDampening*2.5);
		return;
	}

	test = Spawn(type, Owner,, Owner.Location - vect(0,0,8) +
      vector(Pawn(Owner).ViewRotation) * 45, Pawn(Owner).ViewRotation);


	if ( test != None)
	{
		Owner.PlaySound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*2.5);
        if ( SiegeGI(Level.Game) == None || !SiegeGI(Level.Game).FreeBuild )
		    ownerPRI.RU -= type.default.BuildCost;

		ownerPRI.Score += type.default.BuildCost / 100;
	}
	else
        Owner.PlaySound(Misc1Sound, SLOT_Misc, Pawn(Owner).SoundDampening*2.5);
}

/*--- Accessors. ------------------------------------------------------------*/

simulated function string GetOptionName()
{
    local class<sgBuildCategory> cat;


    if ( Category < NumActions )
        switch ( Category )
        {
        case 0:
            return "Upgrade";
        case 1:
            return "Repair";
        case 2:
            return "Remove";
/*
	case 3:
	    return "Cloak";
*/
        default:
            return "";
    }

    if ( Category >= NumBuildCategories + NumActions )
        return "";

    cat = BuildCategories[Category - NumActions];
    
    if ( cat == None )
        return "";
    
    if ( Selection < 0 )
        return cat.default.CategoryName;
    
    if ( Selection >= cat.default.NumSelections ||
      cat.default.Selections[Selection] == None )
        return "";

    return cat.default.Selections[Selection].default.BuildingName;
}

simulated function class<sgBuildCategory> GetBuildCategory()
{

    if ( Category < NumActions || Category >= NumBuildCategories + NumActions )
        return None;

    return BuildCategories[Category - NumActions];
}

simulated function class<sgBuilding> GetBuildType()
{
    local class<sgBuildCategory> cat;

    cat = GetBuildCategory();

    if ( cat == None || Selection < 0 ||
      Selection >= cat.default.NumSelections ||
      cat.default.Selections[Selection] == None )
        return None;

    return cat.default.Selections[Selection];
}

simulated function bool IsFunction()
{
    return ( Category < NumActions );
}

simulated function bool IsCategory()
{
    return ( Category >= NumActions && Selection == -1 );
}

simulated function bool IsBuilding()
{
    return ( Category >= NumActions && Selection != -1 );
}

function NextMode()
{
    local class<sgBuildCategory> cat;

    if ( Selection < 0 )
    {
        Category++;

        Owner.PlaySound(ChangeSound, SLOT_None,
          Pawn(Owner).SoundDampening*1.2,,, 1 + (FRand()*0.2 - 0.4));
    }
    else
    {
        cat = GetBuildCategory();
        if ( cat != None && Selection < cat.default.NumSelections - 1)
        {
            Selection++;
            Owner.PlaySound(ChangeSound, SLOT_None,
              Pawn(Owner).SoundDampening*1.2,,, 1 + (FRand()*0.2 - 0.4));
        }
        else
        {
            Category++;
            Selection = -1;
            Owner.PlaySound(DeselectSound, SLOT_None,
              Pawn(Owner).SoundDampening*1.2);
        }
    }

    if ( Category >= NumBuildCategories + NumActions )
        Category = 0;
}

function Select()
{
    local class<sgBuildCategory> cat;

    cat = GetBuildCategory();

    if ( Selection >= 0 || cat == None )
    {
        NextMode();
        return;
    }

    Selection = 0;

    Owner.PlaySound(SelectSound, SLOT_None,
      Pawn(Owner).SoundDampening*5,,, 2.0);
}

/*--- Console Functions. ----------------------------------------------------*/

exec function SetMode(int newCategory, int newSelection)
{

    if ( newCategory < 0 || newCategory >= NumBuildCategories + NumActions )
        return;
    else if ( newCategory < NumActions  || newSelection < 0 )
        newSelection = -1;
    else if ( BuildCategories[newCategory] == None )
        return;
    else if ( newSelection >=
      BuildCategories[newCategory].default.NumSelections )
        return;
    if ( Category == newCategory && Selection == newSelection )
        return;

	Owner.PlaySound(ChangeSound, SLOT_None, Pawn(Owner).SoundDampening*1.2,,,
      1 + (FRand()*0.2 - 0.4));

	Category = newCategory;
    Selection = newSelection;
}

exec function SelectMode(int newCategory, int newSelection)
{
    if ( PlayerPawn(Owner) != None )
        PlayerPawn(Owner).GetWeapon(class);
    SetMode(newCategory, newSelection);
}

/*--- Animation. ------------------------------------------------------------*/

function SetHand(float hand)
{
	if ( hand != 2 )
	{
		if ( hand == 0 )
			hand = 1;

		if ( hand == -1 )
			Mesh = mesh'Botpack.Transloc';
		else
			Mesh = mesh'Botpack.TranslocR';
	}
	Super.SetHand(hand);
}

simulated function PlayIdleAnim()
{
	if ( Mesh == PickupViewMesh )
		return;
    LoopAnim('Idle', 0.4);
	Enable('AnimEnd');
}

simulated function PlaySelect()
{
	bForceFire = false;
	bForceAltFire = false;
	TweenAnim('ThrownFrame', 0.27);
}


simulated function TweenDown()
{
	if ( IsAnimating() && AnimSequence != '' &&
      GetAnimGroup(AnimSequence) == 'Select' )
		TweenAnim(AnimSequence, AnimFrame * 0.36);
	else
        PlayAnim('Down2', 1.1, 0.05);
}

/*-----------------------------------------------------------------------------
 * STATE Idle.
 * --------------------------------------------------------------------------*/

state Idle
{
	function Tick(float delaTime)
	{
	    if ( Pawn(Owner) != None && sgPRI(Pawn(Owner).PlayerReplicationInfo) !=
          None && AmmoType != None )
            AmmoType.AmmoAmount = sgPRI(Pawn(Owner).PlayerReplicationInfo).RU;
	}

Begin:
	bPointing = false;
	if ( Pawn(Owner).bFire != 0 )
        Pawn(Owner).StopFiring();
}

/*-----------------------------------------------------------------------------
 * STATE Build.
 * --------------------------------------------------------------------------*/

state Build
{
ignores Fire, AltFire;

    function Tick(float delaTime)
    {
        if ( Pawn(Owner) != None && sgPRI(Pawn(Owner).PlayerReplicationInfo) !=
          None && AmmoType != None )
            AmmoType.AmmoAmount = sgPRI(Pawn(Owner).PlayerReplicationInfo).RU;
    }

Begin:
	if ( Category < NumActions )
    {
        UseFunction(GetTarget());
        Sleep(1);
    }
    else
    {
        if ( Selection == -1 )
        {
            Select();
            Sleep(0.3);
        }
        else
        {
            PlaceIt();
            Sleep(1);
        }
    }
	
    Finish();
}

/*-----------------------------------------------------------------------------
 * STATE ChangeMode.
 * --------------------------------------------------------------------------*/

state ChangeMode
{	
Begin:
    NextMode();
	Sleep(0.3);
	Finish();
}

/*--- Defaults. -------------------------------------------------------------*/

defaultproperties
{
    ChangeSound=Sound'sgMedia.SFX.sgChng'
    SelectSound=Sound'Activates.Beeps.mactiv62'
    DeselectSound=Sound'Activates.Beeps.mactiv63'
    BuildCategories(0)=Class'sgCategoryFortification'
    BuildCategories(1)=Class'sgCategorySupplier'
    BuildCategories(2)=Class'sgCategoryItems'
    BuildCategories(3)=Class'sgCategoryTeleport'
    BuildCategories(4)=Class'sgCategoryExplosives'
    BuildCategories(5)=Class'sgCategorySuits'
    NumBuildCategories=6
    NumActions=3
    Selection=-1
    AmmoName=Class'sgAmmo'
    bCanThrow=False
    FireSound=Sound'sgMedia.SFX.sgCnstrct'
    Misc1Sound=Sound'sgMedia.SFX.sgNoRUs'
    Misc2Sound=Sound'sgMedia.SFX.sgRepair'
    Misc3Sound=Sound'sgMedia.SFX.sgUpgrade'
    MessageNoAmmo=" has no RUs."
    DeathMessage="%o was killed %k's Orb."
    InventoryGroup=10
    PickupMessage="You are equipped with the Constructor"
    ItemName="Constructor"
    PlayerViewOffset=(X=6.00,Y=-7.00,Z=-7.00),
    PlayerViewMesh=LodMesh'Botpack.Transloc'
    PickupViewMesh=LodMesh'Botpack.Trans3loc'
    ThirdPersonMesh=LodMesh'Botpack.Trans3loc'
    Mesh=LodMesh'Botpack.Trans3loc'
}
