//=============================================================================
// sgBooster.
// * Revised by 7DS'Lust
//=============================================================================
class sgBooster extends sgBuilding;

var sound           BoostSound;
var float           RepairTimer;

simulated event Timer()
{
    Super.Timer();

    if ( SCount > 0 || Role != ROLE_Authority || RepairTimer > 0 )
        return;

    Energy = FMin(Energy + 18, MaxEnergy);
}

simulated event Tick(float deltaTime)
{
    Super.Tick(deltaTime);

    if ( Role == ROLE_Authority && RepairTimer > 0 )
        RepairTimer -= deltaTime;
}

event TakeDamage( int Damage, Pawn instigatedBy, Vector hitLocation, 
  Vector momentum, name damageType)
{
    RepairTimer = 6;
    Super.TakeDamage(Damage * (1 - Grade*0.05), instigatedBy, hitLocation,
      momentum, damageType);
}

event Touch(Actor other)
{
    if ( SCount <= 0 && Pawn(other) != None && Pawn(other).bIsPlayer &&
      Pawn(other).PlayerReplicationInfo != None &&
      Pawn(other).PlayerReplicationInfo.Team == Team )
    {
        PendingTouch = other.PendingTouch;
        other.PendingTouch = self;
        PlaySound(BoostSound);
    }
}

event PostTouch(Actor other)
{
    local Pawn target;
    local float boost;

    if ( SCount > 0 || Pawn(other) == None )
        return;

    target = Pawn(other);

    if ( target.IsA('Bot') )
    {
        if ( target.Physics == PHYS_Falling )
            Bot(target).bJumpOffPawn = true;
        Bot(target).SetFall();
    }
    if ( target.Physics != PHYS_Swimming )
        target.SetPhysics(PHYS_Falling);
    boost = 115 * (Grade + 3);
    if ( target.Velocity.Z < -1800 )
        target.Velocity.Z += boost;
    else if ( target.Velocity.Z < boost )
        target.Velocity.Z = boost;
}

defaultproperties
{
    BoostSound=Sound'UnrealI.Pickups.BootJmp'
    BuildingName="Booster"
    BuildCost=200
    UpgradeCost=25
    BuildTime=15.00
    MaxEnergy=2000.00
    Model=LodMesh'Botpack.Crystal'
    DSofMFX=0.95
    MFXrotX=(Pitch=0,Yaw=20000,Roll=0),
    MultiSkins(0)=Texture'sgMedia.GFX.sgContSpriteT0'
    MultiSkins(1)=Texture'sgMedia.GFX.sgContSpriteT1'
    MultiSkins(2)=Texture'sgMedia2.GFX.sgContSpriteT2'
    MultiSkins(3)=Texture'sgMedia2.GFX.sgContSpriteT3'
    CollisionHeight=30.00
}
