//=============================================================================
// sgBaseCore.
// * Revised by 7DS'Lust
//=============================================================================
class sgBaseCore extends sgBuilding;

event PostBeginPlay()
{
    if ( TeamGamePlus(Level.Game) == None )
    {
        Destroy();
        return;
    }

	MaxEnergy = TeamGamePlus(Level.Game).GoalTeamScore*1000;
	Energy = MaxEnergy;
	SCount = 0;
	SetTimer(0.1, true);
}

function Destruct()
{
    if ( SiegeGI(Level.Game) != None )
        SiegeGI(Level.Game).CoreDestroyed(Self);
	Spawn(class'sgFlash');
	//Spawn(class'shockWave');
	Spawn(class'shockRifleWave');
	Destroy();
}

simulated event Timer()
{
	local sgPRI a;

	Super.Timer();

    if ( SiegeGI(Level.Game) != None && SiegeGI(Level.Game).RUMax != 0 )
        SiegeGI(Level.Game).MaxRUs[Team] = SiegeGI(Level.Game).RUMax;

	foreach AllActors(class'sgPRI', a)
		if( a.Team == Team )
			a.AddRU(0.05 * (Grade * 0.85 + 0.05));
}

simulated function FinishBuilding()
{
    Super.FinishBuilding();

    if ( Team < 0 || Team > 4 )
        Team = 0;
	Texture = MultiSkins[Team];
}

event TakeDamage(int Damage, Pawn instigatedBy, Vector hitLocation, 
  Vector momentum, name damageType)
{
	local int actualDamage;
	local float tempScore;
    local Pawn p;

	if ( Role < ROLE_Authority || Level.Game == None )
        return;
	
	actualDamage = Level.Game.ReduceDamage(Damage, DamageType, Self,
      instigatedBy);

    if ( instigatedBy != None && instigatedBy.bIsPlayer )
    {
        if ( TeamGamePlus(Level.Game) != None &&
          instigatedBy.PlayerReplicationInfo.Team == Team )
        {
            actualDamage *= TeamGamePlus(Level.Game).FriendlyFireScale;
	        tempScore = -1 * FMin(Energy, actualDamage);
        }
        else
            tempScore = FMin(Energy, actualDamage);

        tempScore *= 1 + Grade/10;

        instigatedBy.PlayerReplicationInfo.Score += tempScore/500;

        if ( sgPRI(instigatedBy.PlayerReplicationInfo) != None )
            sgPRI(instigatedBy.PlayerReplicationInfo).AddRU(tempScore/15);
    }
    else if ( sgBuilding(instigatedBy) != None &&
      TeamGamePlus(Level.Game) != None &&
      sgBuilding(instigatedBy).Team == Team )
        actualDamage *= TeamGamePlus(Level.Game).FriendlyFireScale;

    if ( actualDamage > 0 && instigatedBy != None &&
      ((instigatedBy.bIsPlayer &&
      instigatedBy.PlayerReplicationInfo.Team != Team) || 
      (sgBuilding(instigatedBy) != None &&
      sgBuilding(instigatedBy).Team != Team)) )
        for ( p = Level.PawnList; p != None; p = p.nextPawn )
            if ( p.IsA('TournamentPlayer') &&
              p.PlayerReplicationInfo.Team == Team )
		if ((Energy-actualDamage)/1000 > 2)
                TournamentPlayer(P).ReceiveLocalizedMessage(
                  class'sgCoreWarnMsg', actualDamage);
		else
                TournamentPlayer(P).ReceiveLocalizedMessage(
                  class'sgCoreDyingMsg', actualDamage);
    Energy -= actualDamage;

    TeamGamePlus(Level.Game).Teams[Team].Score = Energy/1000;

    if ( Energy <= 0 )
        Destruct();
}

defaultproperties
{
    BuildingName="BaseCore"
    UpgradeCost=80
    MaxEnergy=20000.00
    Model=LodMesh'Botpack.Diamond'
    DSofMFX=2.50
    MFXrotX=(Pitch=0,Yaw=1000,Roll=0),
    MultiSkins(0)=Texture'sgMedia.GFX.sgCoreSpriteT0'
    MultiSkins(1)=Texture'sgMedia.GFX.sgCoreSpriteT1'
    MultiSkins(2)=Texture'sgMedia2.GFX.sgCoreSpriteT2'
    MultiSkins(3)=Texture'sgMedia2.GFX.sgCoreSpriteT3'
    bCollideWorld=True
}
