//=============================================================================
// SuperMine 
// Written by nOs*Badger
//=============================================================================
class SuperMine extends Mine;

simulated event Timer()
{
    	local Pawn p;
	Super.Timer();

	if ( SCount > 0 || Role != ROLE_Authority )
        	return;

		foreach RadiusActors(class'Pawn', p, 100)
			if ( p.bIsPlayer && p.Health > 0 &&
        			p.PlayerReplicationInfo != None &&
          			p.PlayerReplicationInfo.Team != Team && !p.PlayerReplicationInfo.bIsSpectator)
				if (p != None) 
					Damage();
}

function Damage()
{
	local int i;
    	local Pawn p;

    	local vector dir;
	local int x;
	local int y;
	local int z;
	local string sMessage;
	local string sName;
	local bool bWarhead;

	Self.PlaySound(sound'Botpack.targethum',, 8.0);

        for ( i = 0; i <= Grade; i++ )
	{
		dir.x = Rand(80)-40;
		dir.y = Rand(80)-40;
		dir.z = Rand(80)-40;
		spawn(class'SpriteBallExplosion',,,Location + dir); 
		foreach RadiusActors(class'Pawn', p, 50+(i*40))
			if (p != None) 
				if (ShouldAttack(p))
				{
        				dir = Location - p.Location;
        				dir = normal(dir); 
					if (p.Health>0)
					{
        					p.TakeDamage((Grade+1) * 15, instigator, 0.5 * (p.CollisionHeight + p.CollisionRadius)*dir, vect(0,0,0), 'supermine');
						sgPRI(Pawn(Owner).PlayerReplicationInfo).AddRU((Grade+1) * 4);
					}
				}
	}
	sgPRI(Pawn(Owner).PlayerReplicationInfo).AddRU(50);
}


defaultproperties
{
    BuildingName="Super Mine"
    BuildCost=800
    UpgradeCost=50
    MaxEnergy=3000.00
    SpriteScale=0.90
    DSofMFX=1.25
}
