//=============================================================================
// SiegeGI.
// * Revised by nOs*Badger
//=============================================================================
class SiegeGI extends TeamGamePlus
    config;

var config float    MaxCoreSnipeDistance;
var config int      MaxSiegeTeams;
var float           MaxRUs[4];
var globalconfig string
                    Weapons[16];
var() class<Weapon> WeaponClasses[16];
var sgBaseCore      Cores[4];
var int             Available[4];

// Cheat settings
var bool            FreeBuild;
var bool	    SupplierProtection;
var int             RUMax;


replication
{
    // Things the server should send to the client.
    reliable if ( Role == ROLE_Authority )
        MaxRUs;
}

function InitGame(string options, out string error)
{
    local Actor     f;
    local sgBaseCore
                    b;
    local int       team;
    local sgResources
                    resources;
    local string    opt;
    local int       i;

    Super.InitGame(options, error);

    opt = ParseOption(options, "FreeBuild");
    if ( opt == "1" || opt ~= "true" )
        FreeBuild = true;

    opt = ParseOption(options, "RUMax");
    if ( opt != "" )
        RUMax = int(opt);

    MaxRUs[0] = 300;
    MaxRUs[1] = 300;
    MaxRUs[2] = 300;
    MaxRUs[3] = 300;

    MaxTeams = 2;
    MaxSiegeTeams = Clamp(MaxSiegeTeams, 0, 4);

    foreach AllActors( class'Actor', f)
    {
        if ( FlagBase(f) != None )
        {
            if ( FlagBase(f).Team >= 0 && FlagBase(f).Team < MaxSiegeTeams &&
              cores[FlagBase(f).Team] == None )
            {
                b = Spawn(class'sgBaseCore',,, f.Location);
                if ( b != None )
                {
                    b.Team = FlagBase(f).Team;
                    MaxTeams = Max(MaxTeams, b.Team+1);
                    Cores[b.Team] = b;
                }
                else
                    log("SiegeGI: Failed to spawn BaseCore for team"@
                      FlagBase(f).Team$"!");
            }
        }
		else if ( Inventory(f) != None && sgResources(f) == None &&
          ScubaGear(f) == None )
			f.Destroy();
		else if ( PathNode(f) != None && FRand() < 0.2 )
        {
			resources = Spawn(class'sgResources',,, f.Location);
            if ( resources != None )
                resources.RU = 15 + 15 * FRand();
        }
    }

    for ( i = 0; i < 16; i++ )
        if ( Weapons[i] != "" )
            WeaponClasses[i] = class<Weapon>(DynamicLoadObject(Weapons[i],
              class'Class'));
}

function PostBeginPlay()
{
    local int i;
    
    Super.PostBeginPlay();

    for ( i = 0; i < 4; i++ )
        Teams[i].Score = GoalTeamScore;

    AnnounceAll(""@GameName@" - modified by nOs*Badger");
}

event PlayerPawn Login(string portal, string options, out string error,
  class<PlayerPawn> spawnClass)
{ 	
	local PlayerPawn newPlayer;
    local class<PlayerReplicationInfo> priClass;

    // Ugly hack to spawn the correct type of PRI
    priClass = spawnClass.default.PlayerReplicationInfoClass;
    spawnClass.default.PlayerReplicationInfoClass = class'sgPRI';
    newPlayer = Super.Login(portal, options, error, spawnClass);
    spawnClass.default.PlayerReplicationInfoClass = priClass;

    return newPlayer;
}

function AddDefaultInventory(Pawn playerPawn)
{
    local int i;
    local Weapon newWeapon;

    if ( PlayerPawn.IsA('Spectator') || (bRequireReady && (CountDown > 0)) )
         return;

    GivePlayerWeapon(playerPawn, WeaponClasses[12]);

    for ( i = 0; i < 12; i++ )
        if ( WeaponClasses[i] != None )
            GivePlayerWeapon(playerPawn, WeaponClasses[i]);
//    if ( sgPRI(playerPawn.PlayerReplicationInfo).GetLevel() > 2 )  


}
function GivePlayerWeapon(Pawn playerPawn, class<Weapon> weaponClass )
{
	local Weapon newWeapon;
    local int coreLevel;

	if ( playerPawn.FindInventoryType(weaponClass) != None )
		return;
	newWeapon = Spawn(weaponClass);
	if( newWeapon != None )
	{
       	newWeapon.RespawnTime = 0.0;
		newWeapon.GiveTo(playerPawn);
		newWeapon.bHeldItem = true;
		newWeapon.GiveAmmo(playerPawn);
		newWeapon.SetSwitchPriority(playerPawn);
		newWeapon.WeaponSet(playerPawn);
		newWeapon.AmbientGlow = 0;
		if ( PlayerPawn(playerPawn) != None )
			newWeapon.SetHand(PlayerPawn(playerPawn).Handedness);
		else
			newWeapon.GotoState('Idle');

        	if ( playerPawn.Weapon != None )
		    playerPawn.Weapon.GotoState('DownWeapon');

		playerPawn.PendingWeapon = None;
        	newWeapon.WeaponSet(playerPawn);
		playerPawn.Weapon = newWeapon;

        if ( Enforcer(newWeapon) != None )
        {
            if ( playerPawn.PlayerReplicationInfo != None &&
              Cores[playerPawn.PlayerReplicationInfo.Team] != None )
            {
                coreLevel = Cores[playerPawn.PlayerReplicationInfo.Team].Grade;
                if ( newWeapon.AmmoType != None )
                    newWeapon.AmmoType.AmmoAmount = 15 + 2 * coreLevel;
                if ( sgEnforcer(newWeapon) != None )
                {
                sgEnforcer(newWeapon).HitDamage = 15 + coreLevel;
                sgEnforcer(newWeapon).AccuracyScale = 1 - float(coreLevel)/10;
		}
            }
        }
        else if ( newWeapon.AmmoType != None )
            newWeapon.AmmoType.AmmoAmount = 0;
	}
}

function ScoreKill(Pawn killer, Pawn other)
{
	if ( killer == other || killer == None )
	{
        if ( other.PlayerReplicationInfo != None )
		    other.PlayerReplicationInfo.Score -= 1;
        if ( sgPRI(other.PlayerReplicationInfo) != None )
		    sgPRI(other.PlayerReplicationInfo).AddRU(-50);
	}
	else if ( killer != None )
	{
		killer.KillCount++;
		if ( killer.bIsPlayer && other.bIsPlayer &&
          killer.PlayerReplicationInfo.Team !=
          other.PlayerReplicationInfo.Team )
		{
			killer.PlayerReplicationInfo.Score += 1;
            if ( sgPRI(killer.PlayerReplicationInfo) != None )
			    sgPRI(killer.playerreplicationinfo).AddRU(50);
		}
        if ( sgPRI(other.PlayerReplicationInfo) != None )
            sgPRI(other.PlayerReplicationInfo).AddRU(-10);
	}

	other.DieCount++;

    BaseMutator.ScoreKill(Killer, Other);
}





function int ReduceDamage(int damage, name damageType, Pawn injured,  Pawn instigatedBy)
{
	local string sMessage;
	local sgSpawnProt sgSP;
	if (instigatedBy != None && injured.bIsPlayer && instigatedBy.bIsPlayer && injured.PlayerReplicationInfo.Team != instigatedBy.PlayerReplicationInfo.Team)
	{
		if (injured != instigatedBy)
		{
			sgSP=sgSpawnProt(injured.FindInventoryType(class'sgSpawnProt'));
			if (sgSP != None )
			{
				//instigatedBy.TakeDamage(damage, instigatedBy, instigatedBy.Location, vect(0,0,0), 'exploded');
				sMessage="Player "@injured.PlayerReplicationInfo.PlayerName@" is spawn protected.";

				AnnounceToPawn(instigatedBy,sMessage);

				damage=0;
				return damage;
			}
		}
		else
		{
			sgSP=sgSpawnProt(instigatedBy.FindInventoryType(class'sgSpawnProt'));
			if ( sgSP != None )
				sgSP.DisableProt();
		}
	}

	damage = Super.ReduceDamage(damage, damageType, injured, instigatedBy);

    if ( sgBaseCore(injured) != None )
    {
        if ( instigatedBy != None &&
          (SniperRifle(instigatedBy.Weapon) != None ||
          Ripper(instigatedBy.Weapon) != None) &&
          VSize(injured.Location - instigatedBy.Location) >
          MaxCoreSnipeDistance )
            damage /= 10;
    }
	else if ( sgBuilding(injured) == None && damageType == 'sgSpecial' &&
      injured.Health - damage <= 10 )
	{
		injured.Health = 10;
		damage = 0;
	}

	return damage;
}

function NavigationPoint FindPlayerStart(Pawn player, optional byte inTeam,
  optional string incomingName)
{
	local PlayerStart
                    dest,
                    candidate[16],
                    best;
	local float     score[16],
                    bestScore,
                    nextDist;
	local Pawn      otherPlayer;
	local int       i,
                    num;
	local Teleporter
                    tel;
	local NavigationPoint
                    n;
	local byte      team;
    local bool      spawnNearBase;

	if ( bStartMatch && Player != None && Player.IsA('TournamentPlayer') 
	  && Level.NetMode == NM_Standalone
      && TournamentPlayer(Player).StartSpot != None )
		return TournamentPlayer(Player).StartSpot;

	if ( Player != None && Player.PlayerReplicationInfo != None )
		team = Player.PlayerReplicationInfo.Team;
	else
		team = inTeam;

	if ( incomingName != "" )
		foreach AllActors(class 'Teleporter', tel)
			if ( string(Tel.Tag) ~= incomingName )
				return tel;

	if ( team == 255 )
		team = 0;
				
	//choose candidates	
	for ( N = Level.NavigationPointList; N != None; N = N.nextNavigationPoint )
	{
		dest = PlayerStart(N);
		if ( dest != None && dest.bEnabled &&
          (!bSpawnInTeamArea || team == dest.TeamNumber) )
		{
			if ( num < 16 )
				candidate[num] = dest;
			else if ( Rand(num) < 16 )
				candidate[Rand(16)] = dest;
			num++;
		}
	}

	if ( num == 0 )
	{
		log("Didn't find any player starts in list for team"@Team@"!!!"); 
		foreach AllActors( class'PlayerStart', dest )
		{
			if ( num < 16 )
				candidate[num] = dest;
			else if ( Rand(num) < 16 )
				candidate[Rand(16)] = dest;
			num++;
		}
		if ( num == 0 )
			return None;
	}

	if ( num > 16 )
		num = 16;
	
	//assess candidates
	for ( i = 0; i < num; i++ )
	{
		if ( candidate[i] == LastStartSpot )
			score[i] = -6000.0;
		else
			score[i] = 4000 * FRand(); //randomize
	}

    if ( FRand() <= 0.85 )
        spawnNearBase = true;
	
	for ( otherPlayer = Level.PawnList; otherPlayer != None;
      otherPlayer = otherPlayer.NextPawn)
    {
        if ( otherPlayer.bIsPlayer && otherPlayer.Health > 0 &&
          !otherPlayer.IsA('Spectator') )
        {
            for ( i = 0; i < num; i++ )
				if ( otherPlayer.Region.Zone == candidate[i].Region.Zone ) 
				{
					score[i] -= 1500;
					nextDist = VSize(otherPlayer.Location -
                      candidate[i].Location);
					if ( nextDist < 2 * (CollisionRadius + CollisionHeight) )
						Score[i] -= 1000000.0;
					else if ( NextDist < 2000 &&
                      otherPlayer.PlayerReplicationInfo.Team != team &&
                      FastTrace(candidate[i].Location, otherPlayer.Location) )
						score[i] -= 10000.0 - nextDist;
				}
        }
        else if ( spawnNearBase &&
          (sgEquipmentSupplier(otherPlayer) != None ||
          sgBaseCore(otherPlayer) != None || 
          sgProtector(otherPlayer) != None) &&
          sgBuilding(otherPlayer).Team == team )
        {
            for ( i = 0; i < num; i++ )
            {
                nextDist = VSize(otherPlayer.Location - candidate[i].Location);
                if ( nextDist < 1200 )
                {
                    if ( FastTrace(candidate[i].Location,
                      otherPlayer.Location) )
                        score[i] += 6000.0 * FRand() *
                          (sgBuilding(otherPlayer).Grade + 1)/3;
                    else
                        score[i] += (20000.0 - nextDist) * FRand() *
                          (sgBuilding(otherPlayer).Grade + 1)/3;
                }
                else if ( FastTrace(candidate[i].Location,
                  otherPlayer.Location) )
                    score[i] += 15000.0 * FRand() *
                    (sgBuilding(otherPlayer).Grade + 1)/3;
            }
        }
    }
	
	bestScore = score[0];
	best = candidate[0];
	for ( i = 1; i < num; i++)
		if (score[i] > bestScore)
		{
			bestScore = score[i];
			best = candidate[i];
		}
	LastStartSpot = best;
				
	return best;
}

function bool IsOnTeam(Pawn other, int teamNum)
{
    if ( sgBuilding(other) != None )
        return (sgBuilding(other).Team == teamNum);
    else if ( other.bIsPlayer && other.PlayerReplicationInfo != None )
        return (other.PlayerReplicationInfo.Team == teamNum);
}

function int PickTeam(Pawn defeated)
{
    local int       i,
                    j;
    local TeamInfo  small[3],
                    lowScore[3];
    local int       numSmall,
                    numLow;

    // Find smallest teams
    for ( i = 0; i < 4; i++ )
        if ( Cores[i] != None )
        {
            if ( numSmall == 0 || Teams[i].Size == small[0].Size )
            {
                small[numSmall] = Teams[i];
                numSmall++;
            }
            else if ( Teams[i].Size < small[0].Size )
            {
                small[0] = Teams[i];
                numSmall = 1;
            }
        }
    
    i = int(FRand() * (numSmall-1));

    return i;
}

function bool RestartPlayer(Pawn p)
{
    local NavigationPoint
                    startSpot;
	local bool      foundStart;
	local sgSpawnProt sgSP;


	sgSP=sgSpawnProt(p.FindInventoryType(class'sgSpawnProt'));
	if ( sgSP != None )
		sgSP.Destroy();

		sgSP = Spawn(class'sgSpawnProt', p, 'sgSpawnProt', p.Location, p.Rotation);
		if ( sgSP != None )
		{
			sgSP.bHeldItem = True;
			sgSP.GiveTo(p);
			sgSP.Activate();
		}

    p.DrawScale = p.default.DrawScale;
    p.GroundSpeed = p.default.GroundSpeed;
    p.SetCollisionSize(p.default.CollisionRadius,
      p.default.CollisionHeight);

	if ( bRestartLevel && Level.NetMode != NM_DedicatedServer &&
      Level.NetMode != NM_ListenServer )
		return true;

	if ( p.PlayerReplicationInfo != None &&
      (p.PlayerReplicationInfo.Team < 0 ||
      p.PlayerReplicationInfo.Team >= MaxSiegeTeams ||
      Cores[p.PlayerReplicationInfo.Team] == None) )
    {
        if ( p.IsA('Bot') )
	    {
		    p.PlayerReplicationInfo.bIsSpectator = true;
		    p.PlayerReplicationInfo.bWaitingPlayer = true;
		    p.GotoState('GameEnded');
		    return false;
	    }

	    startSpot = FindPlayerStart(p, 255);
	    if ( startSpot == None )
		    return false;
		
	    foundStart = p.SetLocation(startSpot.Location);
	    if ( foundStart )
	    {
		    startSpot.PlayTeleportEffect(p, true);
		    p.SetRotation(startSpot.Rotation);
		    p.ViewRotation = p.Rotation;
		    p.Acceleration = vect(0,0,0);
		    p.Velocity = vect(0,0,0);
		    p.Health = p.Default.Health;
		    p.ClientSetRotation( startSpot.Rotation );
		    p.SoundDampening = p.Default.SoundDampening;
			p.PlayerRestartState = 'PlayerSpectating';
	    }
	    return foundStart;
    }
    //else
        //p.PlayerRestartState = 'PlayerWalking';

    return Super.RestartPlayer(p);
}

function bool ChangeTeam(Pawn other, int newTeam)
{
    /*local int i;
    if ( newTeam < 0 || newTeam > 3 || Cores[newTeam] == None )
    {
        for ( i = 0; i < 4; i++ )
            if ( Cores[i] != None )
                break;
        if ( i == 4 )
            newTeam = 0;
        else
            newTeam = i;
    }

    if ( !Super.ChangeTeam(other, newTeam) )
        return false;

    if ( other.IsInState('PlayerSpectating') && !other.IsA('Spectator') )
    {
        other.PlayerRestartState = other.default.PlayerRestartState;
        other.GotoState(other.default.PlayerRestartState);
        if ( !other.IsA('Commander') && !RestartPlayer(other) )
            other.GotoState('Dying');
        other.RestartPlayer();
    }

    return true;*/

    local int i, smallest, desiredTeam;
	local Pawn aPlayer, p;
	local TeamInfo SmallestTeam;

	if ( bRatedGame && Other.PlayerReplicationInfo.Team != 255 )
		return false;
	if ( Other.IsA('Spectator') )
	{
		Other.PlayerReplicationInfo.Team = 255;
		if (LocalLog != None)
			LocalLog.LogTeamChange(Other);
		if (WorldLog != None)
			WorldLog.LogTeamChange(Other);
		return true;
	}

    for ( i = 0; i < MaxTeams; i++ )
        if ( Cores[i] != None )
        {
            smallest = i;
            break;
        }
    if ( i >= MaxTeams )
        return false;

	for( i = smallest+1; i < MaxTeams; i++ )
		if ( Teams[i].Size < Teams[smallest].Size && Cores[i] != None )
			smallest = i;

	if ( newTeam == 255 || newTeam >= MaxTeams || Cores[newTeam] == None )
		newTeam = smallest;

	if ( bPlayersBalanceTeams && Level.NetMode != NM_Standalone )
	{
		if ( Teams[newTeam].Size > Teams[smallest].Size )
			newTeam = smallest;
		if ( NumBots == 1 )
		{
			// join bot's team if sizes are equal, because he will leave
			for ( p = Level.PawnList; p != None; p = p.NextPawn )
				if ( p.IsA('Bot') )
					break;
			
			if ( p != None && p.PlayerReplicationInfo != None &&
              p.PlayerReplicationInfo.Team != 255 &&
              Teams[p.PlayerReplicationInfo.Team].Size ==
              Teams[smallest].Size )
				newTeam = p.PlayerReplicationInfo.Team;
		}
	}

	if ( other.PlayerReplicationInfo.Team == newTeam && bNoTeamChanges )
		return false;

    if ( other.IsInState('PlayerSpectating') && !other.IsA('Spectator') )
    {
        other.PlayerRestartState = other.default.PlayerRestartState;
        other.GotoState(other.default.PlayerRestartState);
        if ( !other.IsA('Commander') && !RestartPlayer(other) )
            other.GotoState('Dying');
        other.RestartPlayer();
    }

	if ( other.IsA('TournamentPlayer') )
		TournamentPlayer(Other).StartSpot = None;

	if ( other.PlayerReplicationInfo.Team != 255 )
	{
		ClearOrders(Other);
		Teams[Other.PlayerReplicationInfo.Team].Size--;
	}

	if ( Teams[newTeam].Size < MaxTeamSize )
	{
		AddToTeam(newTeam, Other);
		return true;
	}

	if ( other.PlayerReplicationInfo.Team == 255 )
	{
		AddToTeam(smallest, Other);
		return true;
	}

	return false;
}

function AnnounceAll(string sMessage)
{
    local Pawn p;

    for ( p = Level.PawnList; p != None; p = p.nextPawn )
	    if ( (p.bIsPlayer || p.IsA('MessagingSpectator')) &&
          p.PlayerReplicationInfo != None  )
		    p.ClientMessage(sMessage);
}

function AnnounceToPawn(Pawn AnnounceTo, string sMessage)
{
    local Pawn p;

    for ( p = Level.PawnList; p != None; p = p.nextPawn )
	    if ( p==AnnounceTo && p.PlayerReplicationInfo != None  )
		    AnnounceTo.ClientMessage(sMessage);
}

function CoreDestroyed(sgBaseCore core)
{
    local int       remainingTeams,
                    i;
    local Pawn      defeated;

    if ( cores[core.Team] != core )
        return;

    cores[core.Team] = None;
    Teams[core.Team].Score = 0;

    for ( i = 0; i < 4; i++ )
        if ( cores[i] != None )
            remainingTeams++;

    if ( remainingTeams <= 1 )
    {
        EndGame("teamscorelimit");
        return;
    }


    BroadcastLocalizedMessage(class'sgDefeatedMsg', core.Team);

    foreach AllActors(class'Pawn', defeated)
    {
        if ( sgBuilding(defeated) != None )
        {
            if ( sgBuilding(defeated).Team == core.Team &&
              sgBaseCore(defeated) == None )
                sgBuilding(defeated).Destruct();
        }
        else if ( defeated.PlayerReplicationInfo != None &&
          defeated.PlayerReplicationInfo.Team == core.Team )
        {
            if ( sgPRI(defeated.PlayerReplicationInfo) != None )
                sgPRI(defeated.PlayerReplicationInfo).RU = 0;
            defeated.Died(None, '', defeated.Location);
        }
    }
}

defaultproperties
{
    MaxCoreSnipeDistance=1024.00
    MaxSiegeTeams=4
    Weapons(0)="Botpack.ImpactHammer"
    Weapons(1)="Botpack.PulseGun"
    Weapons(2)="Botpack.ShockRifle"
    Weapons(3)="Botpack.UT_FlakCannon"
    Weapons(4)="Botpack.ut_biorifle"
    Weapons(5)="SiegeXXLyRC1.sgMinigun"
    Weapons(6)="Botpack.SniperRifle"
    Weapons(7)="Botpack.ripper"
    Weapons(8)="Botpack.UT_Eightball"
    Weapons(9)="SiegeXXLyRC1.sgNukeLauncher"
    Weapons(10)="SiegeXXLyRC1.sgConstructor"
    Weapons(11)="SiegeXXLyRC1.sgEnforcer"
    Weapons(12)="Botpack.Chainsaw"
    SupplierProtection=True
    bSpawnInTeamArea=True
    GoalTeamScore=20.00
    TimeLimit=100
    StartUpMessage="SiegeXXLyRC1"
    TourneyMessage="Waiting for more recruits."
    ReadyMessage="You are READY for Battle!"
    StartMessage="The Battle has begun!"
    GameEndedMessage="has won the Battle!"
    gamegoal="units of crystal damage wins the match."
    ScoreBoardType=Class'sgScore'
    HUDType=Class'sgHUD'
    MapListType=Class'Botpack.CTFMapList'
    MapPrefix="CTF"
    GameName="nOs*Badger's SiegeXXLyRC1 - Supplier Immunity Enabled"
}
