//=============================================================================
// Mine 
// Written by nOs*Badger
//=============================================================================
class Mine extends sgBuilding;

var Pawn PlayerOwner;

simulated event Timer()
{
    	local Pawn p;
	Super.Timer();

	if ( SCount > 0 || Role != ROLE_Authority )
        	return;

		foreach RadiusActors(class'Pawn', p, 75)
			if ( p.bIsPlayer && p.Health > 0 &&
        			p.PlayerReplicationInfo != None &&
          			p.PlayerReplicationInfo.Team != Team && !p.PlayerReplicationInfo.bIsSpectator)
				if (p != None) 
					Damage();
}

simulated function string KillMessage( name damageType, pawn Other )
{
    local string s;
    s=Pawn(Owner).PlayerReplicationInfo.PlayerName;
    if (s!="" && s!=" ")
         s="built by"@s;
    return (""@Other.PlayerReplicationInfo.PlayerName@"was killed by a"@BuildingName@s);
}

function bool ShouldAttack(Pawn enemy)
{
    if ( enemy == None )
        return false;
    if ( !FastTrace(enemy.Location) )
        return false;
    if ( sgBuilding(enemy) != None )
    {
        if ( sgBuilding(enemy).Team == Team || sgBuilding(enemy).Energy < 0 )
            return false;
    }
    else if ( enemy.PlayerReplicationInfo == None ||
      enemy.PlayerReplicationInfo.Team == Team ||
      !enemy.bProjTarget )
        return false;
    return true;
}


function Damage()
{
	local int i;
    	local Pawn p;

    	local vector dir;
	local int x;
	local int y;
	local int z;
	local string sMessage;
	local string sName;
	local bool bWarhead;

	Self.PlaySound(sound'Botpack.targethum',, 4.0);

        for ( i = 0; i <= Grade; i++ )
	{
		dir.x = Rand(80)-40;
		dir.y = Rand(80)-40;
		dir.z = Rand(80)-40;
		spawn(class'SpriteBallExplosion',,,Location + dir); 
		foreach RadiusActors(class'Pawn', p, 50+(i*30))
			if (p != None) 
				if (ShouldAttack(p))
				{
        				dir = Location - p.Location;
        				dir = normal(dir); 
					if (p.Health>0)
					{
						//bWarhead = DidHeHaveANuke(p);
        					p.TakeDamage((Grade+1) * 15, instigator, 0.5 * (p.CollisionHeight + p.CollisionRadius)*dir, vect(0,0,0), 'mine');
						sgPRI(Pawn(Owner).PlayerReplicationInfo).AddRU((Grade+1) * 4);
					}
				}
	}

	sgPRI(Pawn(Owner).PlayerReplicationInfo).AddRU(50);

	destroy();
}

function bool DidHeHaveANuke(Pawn p)
{
	local sgNukeLauncher sgNuke;

	sgNuke=sgNukeLauncher(p.FindInventoryType(class'sgNukeLauncher'));
	if (sgNuke != None) return true;
	return false;
}

simulated function CompleteBuilding()
{
    	DrawScale = 0.001;

}

simulated function FinishBuilding()
{
    local int i;
    local sgMeshFX newFX;
    local vector spawnLocation;


    if ( Role == ROLE_Authority )
        Spawn(class'sgFlash');

    if ( Level.NetMode == NM_DedicatedServer )
        return;

    spawnLocation = Location;
    spawnLocation.Z -= 10;
    if ( myFX == None && Model != None )
        for ( i = 0; i < numOfMFX; i++ )
        {
            newFX = Spawn(class'sgMeshFX', Self,,spawnLocation,rotator(vect(0,0,0)));
            newFX.NextFX = myFX;
            myFX = newFX;
            myFX.Mesh = Model;
            myFX.DrawScale = DSofMFX;
            myFX.RotationRate.Pitch = MFXrotX.Pitch*FRand();
            myFX.RotationRate.Roll = MFXrotX.Roll*FRand();
            myFX.RotationRate.Yaw = MFXrotX.Yaw*FRand();
	    myFX.AmbientGlow=1;
	    myFX.Style = STY_Translucent;
	    myFX.ScaleGlow = 0.2;
	    //myFX.LODBias=0.200000;
        }
}


defaultproperties
{
    BuildingName="Mine"
    BuildCost=150
    UpgradeCost=20
    BuildTime=3.00
    MaxEnergy=2000.00
    SpriteScale=0.70
    Model=LodMesh'Botpack.DiscStud'
    MFXrotX=(Pitch=0,Yaw=10000,Roll=0),
    AmbientGlow=0
    MultiSkins(0)=Texture'sgMedia.GFX.sgContSpriteT0'
    MultiSkins(1)=Texture'sgMedia.GFX.sgContSpriteT1'
    MultiSkins(2)=Texture'sgMedia2.GFX.sgContSpriteT2'
    MultiSkins(3)=Texture'sgMedia2.GFX.sgContSpriteT3'
    CollisionHeight=10.00
    LightBrightness=1
}
