// Smiling Monsters FPH Alarm
// By Ti-Lung 02/09/2007
// Version 1.0 (20070902)
// Created for the Smiling Monsters community
// http://www.smiling-monsters.com/community/

class SMoFPHAlarm expands Mutator
	config(SMoFPHAlarm);

// Config variable
var config int FPHNumber;

// Internal variable
var bool bInitialized;

function PostBeginPlay()
{
	if ( bInitialized )
		return;

	bInitialized = True;
	Log("Mutator initialized.",'SMoFPHAlarm');

	SetTimer(5.0, True);

	if ( NextMutator != None )
		NextMutator.PostBeginPlay();
}

simulated function Timer()
{
	local float TimeHour, FPH;
	local int i;
	local Pawn P;
	local string IP;

	for(i=0; i<32; i++)
	{
		if( Level.Game.GameReplicationInfo.PRIArray[i] != None)
		{
			TimeHour =
				(Level.TimeSeconds - Level.Game.GameReplicationInfo.PRIArray[i].StartTime)
				/ 3600;

			FPH = Level.Game.GameReplicationInfo.PRIArray[i].Score / TimeHour;

			if( FPH >= FPHNumber )
			{
				P = PlayerIDToPawn(i);
				IP = left(
					PlayerPawn(P).GetPlayerNetworkAddress(),
					Instr( PlayerPawn(P).GetPlayerNetworkAddress(),
					":"));

				log("PlayerName"@P.PlayerReplicationInfo.PlayerName,'SMoFPHAlarm');
				log("PlayerID"@P.PlayerReplicationInfo.PlayerID,'SMoFPHAlarm');
				log("FPH"@FPH,'SMoFPHAlarm');
			}
		}
	}
}

function Pawn PlayerIDToPawn( int PlayerID )
{
	local Pawn P;

	P = Level.PawnList;

	while ( P != none )
	{
		if( P.IsA('PlayerPawn') || P.IsA('Bot') )
		{
			if( P.PlayerReplicationInfo.PlayerID == PlayerID )
				return P;
		}

		P = P.nextPawn;
	}
}

defaultproperties
{
	FPHNumber=500
}
