// Smiling Monsters Idle Handler
// By Ti-Lung 02/09/2007
// Version 1.0 (20070902)
// Created for Herm
// http://www.smiling-monsters.com/community/
// Request by Hermskii http://www.unrealadmin.org/forums/showthread.php?t=24574

class SMoIdleHandler expands Mutator
	config(SMoIdleHandler);

// Config variable
var config float IdleRadius;
var config float VerifyTime;

// Internal variable
var bool bInitialized;

var vector LastPlayerLocation[32];
var int IdleMessage[32];

function PostBeginPlay()
{
	if ( bInitialized )
		return;

	bInitialized = True;
	Log("Mutator initialized.",'SMoIdleHandler');

	SetTimer(VerifyTime, True);

	if ( NextMutator != None )
		NextMutator.PostBeginPlay();
}

simulated function Timer()
{
	local Pawn P;
	local vector DeltaVector;
	local float DeltaDistance;

    P = Level.PawnList;

	while ( P != none )
    {
		if ( P.IsA('Bot')  || P.IsA('TournamentPlayer') )
		{
			DeltaVector = P.Location
				- LastPlayerLocation[P.PlayerReplicationInfo.PlayerID];
			DeltaDistance = VSize( DeltaVector );

			if( DeltaDistance < IdleRadius )
			{
				P.bBlockPlayers = false; // Player not collide with other player
				P.SetDisplayProperties(
					STY_Translucent,
					P.default.Texture,
					P.default.bUnLit,
					P.Default.bMeshEnviromap);

				if( P.IsA('TournamentPlayer') )
				{
					if( !bool( IdleMessage[P.PlayerReplicationInfo.PlayerID] ) )
					{
						P.ClientMessage("You are now in idle mode");
						IdleMessage[P.PlayerReplicationInfo.PlayerID] = 1;
					}
				}
			}
			else
			{
				P.bBlockPlayers = true; // Player collide with other player
				P.SetDisplayProperties(
					STY_Normal,
					P.default.Texture,
					P.default.bUnLit,
					P.Default.bMeshEnviromap);

				if( P.IsA('TournamentPlayer') )
				{
					IdleMessage[P.PlayerReplicationInfo.PlayerID] = 0;
				}
			}

			LastPlayerLocation[P.PlayerReplicationInfo.PlayerID] = P.Location;
		}

		P = P.nextPawn;
	}
}

defaultproperties
{
	IdleRadius=60
	VerifyTime=3.0
}
