// Smiling Monsters The Target mutator - Kill the Target or Be Killed !
// By Ti-Lung 22/08/2007
// Version 1.0 - 20070822
// http://www.smiling-monsters.com/community/
// Created after a suggestion by Sopa_de_letras: http://forums.beyondunreal.com/showthread.php?t=188731

class SMoTheTarget extends Mutator;

#exec OBJ LOAD File="..\System\BotPack.u"

// class variable
var bool bInitialized;
var int TheTargetPlayerID;

// Inherited function

// Stop add mutator more than twice
function AddMutator(Mutator M)
{
	if ( M != Self )
		Super.AddMutator(M);
}

function PreBeginPlay()
{
	local Actor Other;

	if ( bInitialized)
		return;

	// Remove powerup from map
	foreach AllActors( class 'Actor', Other )
	{
		if(
			Other.IsA('Armor2')
			|| Other.IsA('ThighPads')
			|| Other.IsA('UT_ShieldBelt')
			|| Other.IsA('UT_Invisibility')
			|| Other.IsA('UT_Jumpboots')
			|| Other.IsA('UDamage')
		)
		{
			if( Inventory(Other).MyMarker != None)
			{
				Other.Destroy();
			}
		}
    }

	TheTargetPlayerID = -1;

	bInitialized = True;
	Log("Mutator initialized. ",'SMoTheTarget');

	if ( NextMutator != None )
		NextMutator.PostBeginPlay();
}

// Keep Powerup in player inventory
function bool AlwaysKeep(Actor Other)
{
	if (
		Other.IsA('Armor2')
		|| Other.IsA('ThighPads')
		|| Other.IsA('UT_ShieldBelt')
		|| Other.IsA('UT_Invisibility')
		|| Other.IsA('UT_Jumpboots')
		|| Other.IsA('UDamage')
	)
		return true;

	Super.AlwaysKeep(Other);
	return false;
}

function ModifyPlayer(Pawn Other)
{
	// Give all item if TheTarget suicide
	if( Other.PlayerReplicationInfo.PlayerID == TheTargetPlayerID )
		MakeTheTarget( Other );

	Super.ModifyPlayer(Other);
}

function ScoreKill(Pawn Killer, Pawn Other)
{
	local Pawn P;
	local int Num;

	log("Scorekill:TheTargetPlayerID"@TheTargetPlayerID);
	log("Scorekill:Other"@Other);

	// First killer become the target
	if( TheTargetPlayerID == -1 )
	{
		TheTargetPlayerID = Killer.PlayerReplicationInfo.PlayerID;
		MakeTheTarget( Killer );
		Killer.ClientMessage("You are the Target! Now go kill!");
		AnnounceTheTarget( Killer.PlayerReplicationInfo.PlayerName );
	}

	// Killer of the target become new target
	if(
			Other != Killer
			&& Killer.PlayerReplicationInfo.PlayerID != TheTargetPlayerID
			&& Other.PlayerReplicationInfo.PlayerID == TheTargetPlayerID
	)
	{
		Killer.PlayerReplicationInfo.Score += 5;
		TheTargetPlayerID = Killer.PlayerReplicationInfo.PlayerID;
		MakeTheTarget( Killer );
		Killer.ClientMessage("You are the Target! Now go kill!");
		AnnounceTheTarget( Killer.PlayerReplicationInfo.PlayerName );
	}

	if ( NextMutator != None )
		NextMutator.ScoreKill(Killer, Other);
}

// Custom function

// Give all weapon with max ammo and powerup to TheTarget
function MakeTheTarget( Pawn P )
{
	local Inventory Inv;
	local Pickup PU;
	local Weapon Weap;

	// Give all weapon
	DeathMatchPlus(Level.Game).GiveWeapon( PlayerPawn(P), "BotPack.Impacthammer" );
	DeathMatchPlus(Level.Game).GiveWeapon( PlayerPawn(P), "BotPack.DoubleEnforcer" );
	DeathMatchPlus(Level.Game).GiveWeapon( PlayerPawn(P), "BotPack.UT_BioRifle" );
	DeathMatchPlus(Level.Game).GiveWeapon( PlayerPawn(P), "BotPack.ShockRifle" );
	DeathMatchPlus(Level.Game).GiveWeapon( PlayerPawn(P), "BotPack.Ripper" );
	DeathMatchPlus(Level.Game).GiveWeapon( PlayerPawn(P), "BotPack.UT_FlakCannon" );
	DeathMatchPlus(Level.Game).GiveWeapon( PlayerPawn(P), "BotPack.PulseGun" );
	DeathMatchPlus(Level.Game).GiveWeapon( PlayerPawn(P), "BotPack.Minigun2" );
	DeathMatchPlus(Level.Game).GiveWeapon( PlayerPawn(P), "BotPack.UT_Eightball" );
	DeathMatchPlus(Level.Game).GiveWeapon( PlayerPawn(P), "BotPack.SniperRifle" );
	DeathMatchPlus(Level.Game).GiveWeapon( PlayerPawn(P), "BotPack.Warheadlauncher" );

	// Set all weapon to max ammo
	for ( Inv=P.inventory; Inv!=None; Inv=Inv.inventory )
	{
		Weap = Weapon(Inv);
		if ( (Weap != None) && (Weap.AmmoType != None) )
			Weap.AmmoType.AmmoAmount = Weap.AmmoType.MaxAmmo;
	}

	// Give powerup
	GivePickup( P, "Botpack.Armor2" );
	GivePickup( P, "Botpack.ThighPads" );
	GivePickup( P, "Botpack.UT_ShieldBelt" );
	GivePickup( P, "Botpack.UT_Invisibility" );
	GivePickup( P, "Botpack.UT_Jumpboots" );
	GivePickup( P, "Botpack.UDamage" );
	GivePickup( P, "Botpack.HealthPack" );
}

// Special function to simulate Pickup
function GivePickup( Pawn P, string ItemClass )
{
	local class<TournamentPickup> PUClass;
	local Pickup PU;

	PUClass = class<TournamentPickup>(DynamicLoadObject(ItemClass, class'Class'));

	PU = Spawn( PUClass );

	if( PU != none )
	{
		PU.Touch( P ); // Touch player
		PU.Destroy();
	}
}

// Say who the target is to all player
function AnnounceTheTarget( string Playername )
{
	local Pawn P;

	P = Level.PawnList;
	while ( P != none )
	{
		if( P.IsA('PlayerPawn') )
		{
			PlayerPawn(P).ClearProgressMessages();
			PlayerPawn(P).SetProgressTime(3);
			PlayerPawn(P).SetProgressMessage(PlayerName@"is now the Target!",0);
		}

		P = P.nextPawn;
	}
}
