// Smiling Monsters FPH Alarm
// By Ti-Lung 13/09/2007
// Version 1.1 (20070913)
// Created for the Smiling Monsters community
// http://www.smiling-monsters.com/community/

class SMoFPHAlarm expands Mutator
	config(SMoFPHAlarm);

// config variable
var config bool bKick, bBan, bMessagePlayer;
var config int FPHLimit, NegativeScoreLimit, TeamKillLimit;

// Internal variable
var bool bInitialized;
var int SuicideCount[32];
var int TeamKillCount[32];

function PreBeginPlay()
{
	if ( bInitialized )
		return;

	bInitialized = True;
	Log("Mutator initialized.",'SMoFPHAlarm');

	if ( NextMutator != None )
		NextMutator.PreBeginPlay();
}

function ScoreKill( Pawn Killer, Pawn Other )
{
	local bool bFPH, bSuicide, bTeamKill;
	local int PID;
	local float TimeHour, FPH;
	local string IP, Playername, ClientMessage;

	if( Killer.IsA('PlayerPawn') ) // Verify real player
	{
		// Verify that Killer has replicationinfo to stop accessed none
		if( Killer.PlayerReplicationInfo != none )
		{
			// Get PlayerID of Killer Pawn
			PID = PawnToPlayerID( Killer );

			// Calculate frag per hour
			FPH =
				Killer.PlayerReplicationInfo.Score /
				(
					(
						Level.TimeSeconds
						- Level.Game.GameReplicationInfo.PRIArray[ PID ].StartTime
					)
					/ 3600
				);

			// log("FPH"@Killer.PlayerReplicationInfo.PlayerName@FPH);

			// FPH verify
			if( FPH >= FPHLimit )
			{
				log("FPH Limit:"@FPH,'SMoFPHAlarm');
				bFPH = true;
			}

			// Suicide in Team Death Match
			if( Killer == Other )
			{
				if( Level.Game.IsA('TeamGamePlus') )
				{
					SuicideCount[ PID ] += 1;

					if( SuicideCount[ PID ] >= -NegativeScoreLimit )
					{
						log("Suicide Limit"@SuicideCount[ PID ],'SMoFPHAlarm');
						bSuicide = true;
					}
				}
			}

			// Team kill in Team Deathmatch
			if( Killer.PlayerReplicationInfo.Team == Other.PlayerReplicationInfo.Team )
			{
				if( Level.Game.IsA('TeamGamePlus') )
				{
					TeamKillCount[ PID ] += 1;

					if( TeamKillCount[ PID ] >= TeamKillLimit )
					{
						log("TeamKill Limit"@TeamKillCount[ PID ],'SMoFPHAlarm');
					}
				}
			}

			// Log player information and kick/ban
			if( bFPH || bSuicide || bTeamKill )
			{

				// Get network address and remove ":" plus port number
				IP = left(
					PlayerPawn( Killer ).GetPlayerNetworkAddress(),
					Instr( PlayerPawn( Killer ).GetPlayerNetworkAddress(),
					":"));

				Playername = Killer.PlayerReplicationInfo.PlayerName;

				log("FPH Limit"@FPH);
				log("PlayerName"@PlayerName,'SMoFPHAlarm');
				log("PlayerID"@Killer.PlayerReplicationInfo.PlayerID,'SMoFPHAlarm');
				log("PlayerIP"@IP,'SMoFPHAlarm');

				// Kick player
				if( bKick )
				{
					log("Kick:"@Killer.PlayerReplicationInfo.PlayerName,'SMoFPHAlarm');

					// Set string for client message
					if( bFPH )
						ClientMessage = "Exceed FPH Limit on server";
					if( bSuicide )
						ClientMessage = "Exceed Suicide Limit on server";
					if( bTeamKill )
						ClientMessage = "Exceed Teamkill Limit on server";

					if( bMessagePlayer )
					{
						Killer.ClientMessage( "Kick:" @ ClientMessage );
					}

					Killer.Destroy(); // Destroy Pawn and disconnect player

					// Reset player counter
					SuicideCount[ PID ] = 0;
					TeamKillCount[ PID ] = 0;

					BroadcastMessage( PlayerName@"was kicked.");
				}

				// Ban player
				if( bBan )
				{
					log("Ban:"@Killer.PlayerReplicationInfo.PlayerName,'SMoFPHAlarm');
					BanIP( IP );
					BroadcastMessage( PlayerName@"has been banned." );
				}
			}
		}
	}

	// Execute scorekill of next mutator
	if ( NextMutator != None )
		NextMutator.ScoreKill(Killer, Other);
}

// Return playerid of a pawn
function int PawnToPlayerID( Pawn aPawn )
{
	local Pawn P;

	P = Level.PawnList;

	while ( P != none )
	{
		if( P.IsA('PlayerPawn') || P.IsA('Bot') )
		{
			if( P == aPawn )
				return P.PlayerReplicationInfo.PlayerID;
		}

		P = P.nextPawn;
	}

	return -1; // Should not happen
}

// Ban function from HiddenAdmin
function bool BanIP( string IPString )
{
	local int i;

	if ( Level.Game.CheckIPPolicy( IPString ) )
	{
		for (i=0; i<50; i++)
		{
			if ( Level.Game.IPPolicies[i] == "" )
			{
				break; // exit iterator
			}
		}

		if (i<50)
		{
			Level.Game.IPPolicies[i] = "DENY,"$IPString;
			Level.Game.SaveConfig();
			return true;
		}
	}

	return false;
}

defaultproperties
{
	bBan=False
	bKick=True
	bMessagePlayer=False
	FPHLimit=150
	NegativeScoreLimit=-10
	TeamKillLimit=10
}
