class MoreGuns expands Mutator config(MoreGuns);

/* Coders note: I used dynamic loading here to demonstrate how it's done. It's not
really necessary, you can just use the call in GiveWeapon and that will work. In this 
case the FBFMac10 has stripped code (Seriously warmaster? you stripped the code on a mod
that wasn't yours to begin with?) so you can't compile the mod with FBFMac10 in the 
EditPackages section. If that's the case then use "obj load" to manually load the package.
*/

#exec obj load file=..\System\FBFMac10.u package=FBFMac10
#exec obj load file=..\System\MHAClusterRedeemer.u package=MHAClusterRedeemer
#exec obj load file=..\System\TUC_M16A1.u package=TUC_M16A1

//ini statements to turn on/off the awarding of the weapons
var config bool GiveMac10;
var config bool GiveCluster;
var config bool GiveM16;

//ini statements to remove certain weapons
var config bool EraseEnforcer;
var config bool EraseHammer;

var bool bInitialized;

//This properly adds our package to the mutator chain
function PreBeginPlay()
{
   if ( !bInitialized )
   {
      bInitialized = True;
      Self.NextMutator = Level.Game.BaseMutator.NextMutator;
   }
}

//ModifyPlayer is called every time you spawn. We use that moment to change
//some of your gear.
function ModifyPlayer(Pawn Other)
{
   //Only players, no bots. Change this if you use bots
   if (Other.IsA('PlayerPawn'))
   {
      //Does the ini file say true?
      if(GiveMac10)
         //If it does then spawn a Mac10 to the player's inventory
         GiveWeapon(Other,class'FBFMac10.Mac10');
      if(GiveCluster)
         GiveWeapon(Other,class'MHAClusterRedeemer.MHAClusterRedeemer');
      if(GiveM16)
         GiveWeapon(Other,class'TUC_M16A1.TUC_M16A1');
   }

   if ( NextMutator != None )
      NextMutator.ModifyPlayer(Other);
}

function GiveWeapon(Pawn PlayerPawn, class<Weapon> WeaponClass )
{
   local Weapon NewWeapon;

   newWeapon = Spawn(WeaponClass);
   
   if( PlayerPawn.FindInventoryType(WeaponClass) != None )
      return;

   if(newWeapon != None)
   {
      //This sets some defaults for the weapons so it is ready for use
      newWeapon.RespawnTime = 0.0;
      newWeapon.GiveTo(PlayerPawn);
      newWeapon.bHeldItem = true;
      newWeapon.GiveAmmo(PlayerPawn);
      newWeapon.SetSwitchPriority(PlayerPawn);
      newWeapon.WeaponSet(PlayerPawn);
      newWeapon.AmbientGlow = 0;
      PlayerPawn.PendingWeapon = None;
      //Special case for the deemer since it doesn't have "ammo" like other weapons
      if ( !newWeapon.IsA('MHAClusterRedeemer'))
      {
	      newWeapon.AmmoType.AmmoAmount = newWeapon.AmmoType.MaxAmmo;
      }
   }
}

//This function checks to see if actors need replaced
function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	//Do we want to remove enforcers?
   if(EraseEnforcer)
   {
      //If yes then the false return effectively destroys the enforcer and it disappears
      if (Other.Class==Class'Enforcer')
         return False;
   }

   if(EraseHammer)
   {
      if (Other.Class==Class'ImpactHammer')
         return False;
   }

   bSuperRelevant = 0;
   return true;
}

defaultproperties
{
}
