class Kicker extends Mutator
	config(Kicker);

var config struct entry
{
	var string 	playername;
	var string 	ip;
	var string 	reason;
	var int		remaining_ban;//how many games - still
} list[256];

var bool bPreInit;
var bool bVoteActive;
var Pawn suspect;
var Pawn possible_suspect;
var string ip;
var string reason;
var string playername;
var int votingCounter;
var Pawn votes[32];
var int lastID;
var name tag;
var int leftMsgLength;
var string lastMsg;

function PreBeginPlay() 
{
	local int i;
	
	if(bPreInit)
		return;

	bPreInit = True;
	Level.Game.RegisterMessageMutator(Self);
	tag = 'Xcept_1_Kicker';
	leftMsgLength = Len(Level.Game.LeftMessage);
	//reduce bans
	for(i = 0; i < 256;i++)
	{
		if(list[i].ip != "")
		{
			list[i].remaining_ban --;
			if(list[i].remaining_ban <= 0)
			{
				list[i].ip = "";
				list[i].remaining_ban = 0;
				list[i].reason = "";
				list[i].playername = "";
			}
		}
	}
	SaveConfig();
}

function bool MutatorTeamMessage(Actor Sender, Pawn Receiver, PlayerReplicationInfo PRI, coerce string Msg, name Type, optional bool bBeep) 
{
	local int i;
	local Pawn p;
	
		
	if(Sender == Receiver) 
	{ 
		if(Msg ~= "!list")
		{
			for(p = Level.PawnList; p != None; p = p.NextPawn)
			{
				if(TournamentPlayer(p) != None)
					Receiver.ClientMessage(p.PlayerReplicationInfo.PlayerName $ " ----- ID = " $ p.PlayerReplicationInfo.PlayerID);
			}
		}
		else if(Left(Msg, 6) ~= "!kick ")
		{
			if(suspect == None)//no active vote
			{
				Msg = Mid(Msg, 6);
				i = InStr(Msg, " ");
				
				if(i == -1 || (i+1 == Len(Msg)))
					Receiver.ClientMessage("Format '!kick ID REASON' - say !list to get the ID.");
				else
				{
					suspect = FindPlayer(int(Left(Msg, i)));
					reason = Mid(Msg, i+1);
					if(suspect == None)
						Receiver.ClientMessage("Player is gone? If he reconnected !list again.");
					else
					{
						ip = PlayerPawn(suspect).GetPlayerNetworkAddress();
						i = InStr(ip, ":");
						ip = Left(ip, i);
						
						playername = suspect.PlayerReplicationInfo.PlayerName;
						
						votingCounter = 0;//reset
						ClearVotes();
						AddVote(Receiver);
						SetTimer(7, True);
						
						Self.BroadcastMessage((votingCounter+1) $ " >> Shall " $ playername $
							" be removed for '" $ reason $ "'? Say !yes then.");
							
						Log("+++++++++++++++++++++++++++++++++", tag);
						Log(Receiver.PlayerReplicationInfo.PlayerName $ " is calling a kick-vote on " $
							playername $ " reason: " $ reason, tag);
						Log("timestamp " $ Level.Year $ "/" $ Level.Month $ "/" $ Level.Day
							$ " " $ Level.Hour $ ":" $ Level.Minute, tag);
						Log("+++++++++++++++++++++++++++++++++", tag);
					}
				}
			}
		}
		else if(Msg ~= "!kick")
			Receiver.ClientMessage("Format '!kick ID REASON' - say !list to get the ID");
		else if(Msg ~= "!yes")
		{
			//if(suspect != None)
			if(bVoteActive)
				AddVote(Receiver);
			else
				Receiver.ClientMessage("Nothing to vote on.");
		}
	}
	
	if(NextMessageMutator != None)
		return NextMessageMutator.MutatorTeamMessage( Sender, Receiver, PRI, Msg, Type, bBeep );
	else
		return true;
}

function Timer()
{
	/*if(suspect == None)
	{
		Self.BroadcastMessage("Suspect gone. But keep voting if you are serious");
		//SetTimer(0.0, False);
		//return;
	}*/

	if(++votingCounter >= 5)
	{
		SetTimer(0.0, False);//stop
		
		Evaluate();
	}
	else
	{
		//repeat question
		Self.BroadcastMessage((votingCounter+1) $ " >> Shall " $ playername $
			" be removed for '" $ reason $ "'? Say !yes then.");
		if(suspect == None)
			Self.BroadcastMessage("> Suspect gone/reconnect - keep voting!");
	}
}

function ClearVotes()
{
	local int i;
	
	for(i = 0;i<32;i++)
		votes[i] = None;

	bVoteActive = True;
}

function ModifyPlayer(Pawn Other)
{
	local int i;
	local string ip_;
	local string player_name;
	local PlayerPawn p;
	
	if ( NextMutator != None )
		NextMutator.ModifyPlayer(Other);
	
	if(Other.PlayerReplicationInfo.PlayerID > lastID)
	{
		lastID = Other.PlayerReplicationInfo.PlayerID;
		p = PlayerPawn(Other);
		if(p != None)
		{
			ip_ = p.GetPlayerNetworkAddress();
			
			for(i = 0;i < 256;i++)
			{
				if(list[i].ip != "" && InStr(ip_, list[i].ip) != -1)//to kick
				{
					player_name = Other.PlayerReplicationInfo.PlayerName;
					Other.Destroy();
					Other = None;
					Self.BroadcastMessage("Kicked " $ player_name $ " - active ban."); 
					Log(list[i].ip $ " trying to come back as " $ player_name, tag);
					break;
				}
			}
			
			if(Other != None)//advertise
			{
				Other.ClientMessage("> Say !list to look up the ID.");
				Other.ClientMessage("> Say '!kick ID REASON' to start a kick-vote.");
				Other.ClientMessage("> Say !yes to agree (not needed if you started it)");
				
				if(suspect == None && bVoteActive)//lost the suspect -> maybe he returns
				{
					p = PlayerPawn(Other);
					if(p != None) // new player == suspect?
					{
						ip_ = p.GetPlayerNetworkAddress();
						if(InStr(ip_, Self.ip) != -1)//same ip
						{
							possible_suspect = Other;
							Log(">possible suspect connecting " $ Other.PlayerReplicationInfo.PlayerName, tag);
						}
					}
				}
			}
		}
	}
}

function AddVote(Pawn p)
{
	local int i, e;
	
	if(p == None)//...
		return;
	
	e = -1;
	for(i = 0;i < 32;i++)
	{
		if(votes[i] == p)//already voted
			return;
		
		if(votes[i] == None && e == -1)
			e = i;
	}
	
	votes[e] = p;
	p.ClientMessage("Got your vote.");
	
	Evaluate(True); //see if already enough votes
}

function Evaluate(optional bool bVoteCheck)
{
	local int count, i;
	
	for(i = 0;i < 32;i++)
	{
		if(votes[i] != None)
			count ++;
	}
	
	if(!bVoteCheck)
		Self.BroadcastMessage(count $ " times yes / " $ Level.Game.NumPlayers $ " players.");
	
	if(Level.Game.NumPlayers > 1 && count + 1 >= Level.Game.NumPlayers && count > 1)
	{
		Self.BroadcastMessage("Banning " $ playername $ " for " $ 
			(count * count) $ " games.");
			
		bVoteActive = False;
			
		for(i = 0;i < 256;i++)
		{
			if(list[i].ip == "")
			{
				list[i].playername = playername;
				list[i].ip = ip;
				list[i].remaining_ban = count * count;
				list[i].reason = reason;
				Log("--------------------------------", tag);
				Log("Banned: " $ playername $ " /games: " $ list[i].remaining_ban $
					" /reason: " $ reason, tag);
				Log("timestamp " $ Level.Year $ "/" $ Level.Month $ "/" $ Level.Day
					$ " " $ Level.Hour $ ":" $ Level.Minute, tag);
				Log("--------------------------------", tag);
				if(suspect != None)
				{
					suspect.Destroy();
					Self.BroadcastMessage("Removed " $ playername);
				}
				else if(possible_suspect != None)
				{
					possible_suspect.Destroy();
					Self.BroadcastMessage("Removed " $ playername);
				}
				suspect = None;
				ip = "";
				possible_suspect = None;
				SaveConfig();
				return;
			}
		}
		Log("list is full", tag);
		//just kick
		if(suspect != None)
			suspect.Destroy();
		else if(possible_suspect != None)
			possible_suspect.Destroy();
		Self.BroadcastMessage("Removed " $ playername);
		suspect = None;
		ip = "";
		possible_suspect = None;
	}
	else if(!bVoteCheck) // ending vote - vote failed
	{
		Self.BroadcastMessage("Not enough agreement. 2+ votes needed.");
		suspect = None;
		ip = "";
		possible_suspect = None;
		bVoteActive = False;
	}
}

function Pawn FindPlayer(int ID)
{
	local Pawn p;
	
	for(p = Level.PawnList; p != None; p = p.NextPawn)
	{
		if(p.bIsPlayer && p.PlayerReplicationInfo.PlayerID == ID && TournamentPlayer(p) != None)
			return p;
	}
	return None;
}

function Mutate(string MutateString, PlayerPawn Sender)
{
local int i;

	if ( NextMutator != None )
		NextMutator.Mutate(MutateString, Sender);
		
	if(Sender.bAdmin)
	{
		if(Left(MutateString, 6) ~= "unban ")
		{
			MutateString = Mid(MutateString, 6);
			if(MutateString == "")
				return;
			
			for(i = 0;i < 256;i++)
			{
				if(list[i].ip == MutateString)
				{
					Sender.ClientMessage(list[i].ip $ " -unbanned- "$list[i].playername);
					list[i].ip = "";
					list[i].playername = "";
					list[i].reason = "";
					list[i].remaining_ban = 0;
					SaveConfig();
					return;
				}
			}
		}
		else if(MutateString ~= "bans")
		{
			for(i = 0; i < 256;i++)
			{
				if(list[i].ip != "")
					Sender.ClientMessage(list[i].playername $ " --- IP: " $ list[i].ip $
						" --- games left: " $ list[i].remaining_ban $ " --- reason: " $ list[i].reason);

			}
		}
	}
}

function bool MutatorBroadcastMessage( Actor Sender, Pawn Receiver, out coerce string Msg, optional bool bBeep, out optional name Type )
{
	if(Type == 'Event' && Msg != lastMsg && Right(Msg, LeftMsgLength) == Level.Game.LeftMessage)
	{
		Evaluate(True);
		lastMsg = Msg;
	}

	if ( NextMessageMutator != None )
		return NextMessageMutator.MutatorBroadcastMessage( Sender, Receiver, Msg, bBeep, Type );
	else
		return true;
}


defaultproperties
{
	lastID=-1
}