class SmallFBubble extends Bubble1;

var texture BubbleSprites[3];
var class<SmallFBubble> Smaller, Larger;
var bool bCombine, bGetLarger;
var float MaxSpeed;

simulated function BeginPlay()
{
	Super(Effects).BeginPlay();
	if ( Level.NetMode != NM_DedicatedServer ) {
		PlayOwnedSound(EffectSound2);
		Buoyancy = Mass + FRand() + 1.5;
		Texture = BubbleSprites[Rand(3)];
		DrawScale = Default.DrawScale + FRand() * Default.DrawScale - Default.DrawScale * 0.333333;
	}
}

simulated function HitWall(vector HitNormal, actor HitWall)
{
	Velocity -= HitNormal * (Velocity Dot HitNormal);
}

simulated function TakeDamage(int Damage, Pawn InstigatedBy, vector HitLocation, vector Momentum, name DamageType)
{
	Velocity += Normal(Momentum) * FMin(VSize(Momentum), MaxSpeed);
	if ( !Level.bDropDetail && Damage > 25 && Smaller != None )
		Destroy();
}

simulated function Touch(actor Other)
{
	if ( Other.IsA('SmallFBubble') || Other.bBlockActors )
		HitWall(Normal(Other.Location - Location), Other);
	if ( Level.bDropDetail || Larger == None )
		return;
	if ( FRand() > 0.9 && Other.Class == Class && !SmallFBubble(Other).bCombine ) {
		bCombine = True;
		bGetLarger = True;
		Disable('Touch');
		Other.Disable('Touch');
		SmallFBubble(Other).bCombine = True;
		Other.Velocity += Velocity;
		Other.Velocity *= 0.5;
		Destroy();
		Other.Destroy();
	}
}

simulated function Tick(float DeltaTime)
{
	local vector AddVel;
	
	if ( Region.Zone.bWaterZone ) {
		if ( VSize(Velocity) > MaxSpeed )
			Velocity *= FMax(1 - DeltaTime * 10, 0.9);
		AddVel = VRand() * 10;
		AddVel.Z = 0;
		Velocity += AddVel;
	}
	else {
		bCombine = True;	// combine with the surrounding air
		Destroy();
	}
}

simulated function Destroyed()
{
	local SmallFBubble b;
	
	if ( !bCombine && Smaller != None ) {
		// if FrameRate is above desired amount, do something against it ;)
		if ( !Level.bDropDetail && FRand() > 0.6 && Smaller.Default.Smaller != None ) {
			// spawn many tiny bubbles
			Spawn(Smaller.Default.Smaller,,,Location + VRand() * CollisionRadius * 2);
			Spawn(Smaller.Default.Smaller,,,Location + VRand() * CollisionRadius * 2);
			if ( FRand() > 0.5 )
				Spawn(Smaller.Default.Smaller,,,Location + VRand() * CollisionRadius * 2);
			if ( FRand() > 0.5 )
				Spawn(Smaller.Default.Smaller,,,Location + VRand() * CollisionRadius * 2);
		}
		else {
			// spawn smaller bubble(s)
			Spawn(Smaller,,,Location + VRand() * CollisionRadius * 2);
			if ( !Level.bDropDetail )
				Spawn(Smaller,,,Location + VRand() * CollisionRadius * 2);
		}
	}
	else if ( bCombine && bGetLarger && Larger != None ) {
		b = Spawn(Larger,,,Location);
		b.Velocity = Velocity;
	}
	Super.Destroyed();
}

defaultproperties
{
     MaxSpeed=500.000000
     BubbleSprites(0)=Texture'S_Bubble1'
     BubbleSprites(1)=Texture'S_Bubble2'
     BubbleSprites(2)=Texture'S_Bubble3'
     Smaller=Class'TinyFBubble'
     Larger=Class'LargeFBubble'
     LifeSpan=10.000000
     DrawScale=0.150000
     RemoteRole=ROLE_None
     bNetTemporary=True
     bHighDetail=True
     CollisionRadius=2.000000
     CollisionHeight=2.000000
     bCollideWorld=True
     bBounce=True
     bCollideActors=True
}