class IceSpawner extends FlameSpawner;

simulated function Timer()
{
	local FlameParticle p;
	local IceCrystal b;
	
	if ( Instigator == None || Instigator.Health <= 0 || FlameThrower(Instigator.Weapon) == None
			|| Instigator.bAltFire == 0 ) {
		Destroy();
		return;
	}
	
	if ( !Region.Zone.bWaterZone || Region.Zone.IsA('NitrogenZone') ) {
		p = Spawn(class'IceParticle', Instigator);
		if ( p != None && Level.NetMode != NM_Client && ParticleCounter++ % 3 == 0 )
			p.bDoDamage = True;
	}
	else {
		b = Spawn(class'IceCrystal',,,,RotRand(True));
		b.Velocity = vector(Rotation) * 0.7 * class'IceParticle'.Default.Speed + 0.25 * Instigator.Velocity * FMax(Normal(Instigator.Velocity) dot vector(Rotation), 0);
	}
}

defaultproperties
{
     DrawType=DT_None
}