class IceParticle extends FlameParticle;

#exec texture import file=Textures\FreezeGunBlobA_a00.pcx name=FreezeGunBlobA_a00 group=FreezeEffect lodset=2
#exec texture import file=Textures\FreezeGunBlobA_a01.pcx name=FreezeGunBlobA_a01 group=FreezeEffect lodset=2
#exec texture import file=Textures\FreezeGunBlobA_a02.pcx name=FreezeGunBlobA_a02 group=FreezeEffect lodset=2
#exec texture import file=Textures\FreezeGunBlobA_a03.pcx name=FreezeGunBlobA_a03 group=FreezeEffect lodset=2
#exec texture import file=Textures\FreezeGunBlobA_a04.pcx name=FreezeGunBlobA_a04 group=FreezeEffect lodset=2
#exec texture import file=Textures\FreezeGunBlobA_a05.pcx name=FreezeGunBlobA_a05 group=FreezeEffect lodset=2
#exec texture import file=Textures\FreezeGunBlobA_a06.pcx name=FreezeGunBlobA_a06 group=FreezeEffect lodset=2
#exec texture import file=Textures\FreezeGunBlobA_a07.pcx name=FreezeGunBlobA_a07 group=FreezeEffect lodset=2
#exec texture import file=Textures\FreezeGunBlobA_a08.pcx name=FreezeGunBlobA_a08 group=FreezeEffect lodset=2
#exec texture import file=Textures\FreezeGunBlobA_a09.pcx name=FreezeGunBlobA_a09 group=FreezeEffect lodset=2
#exec texture import file=Textures\FreezeGunBlobA_a10.pcx name=FreezeGunBlobA_a10 group=FreezeEffect lodset=2
#exec texture import file=Textures\FreezeGunBlobA_a11.pcx name=FreezeGunBlobA_a11 group=FreezeEffect lodset=2
#exec texture import file=Textures\FreezeGunBlobA_a12.pcx name=FreezeGunBlobA_a12 group=FreezeEffect lodset=2

#exec texture import file=Textures\FreezeGunBlobB_a00.pcx name=FreezeGunBlobB_a00 group=FreezeEffect lodset=2
#exec texture import file=Textures\FreezeGunBlobB_a01.pcx name=FreezeGunBlobB_a01 group=FreezeEffect lodset=2
#exec texture import file=Textures\FreezeGunBlobB_a02.pcx name=FreezeGunBlobB_a02 group=FreezeEffect lodset=2
#exec texture import file=Textures\FreezeGunBlobB_a03.pcx name=FreezeGunBlobB_a03 group=FreezeEffect lodset=2
#exec texture import file=Textures\FreezeGunBlobB_a04.pcx name=FreezeGunBlobB_a04 group=FreezeEffect lodset=2
#exec texture import file=Textures\FreezeGunBlobB_a05.pcx name=FreezeGunBlobB_a05 group=FreezeEffect lodset=2
#exec texture import file=Textures\FreezeGunBlobB_a06.pcx name=FreezeGunBlobB_a06 group=FreezeEffect lodset=2
#exec texture import file=Textures\FreezeGunBlobB_a07.pcx name=FreezeGunBlobB_a07 group=FreezeEffect lodset=2
#exec texture import file=Textures\FreezeGunBlobB_a08.pcx name=FreezeGunBlobB_a08 group=FreezeEffect lodset=2
#exec texture import file=Textures\FreezeGunBlobB_a09.pcx name=FreezeGunBlobB_a09 group=FreezeEffect lodset=2
#exec texture import file=Textures\FreezeGunBlobB_a10.pcx name=FreezeGunBlobB_a10 group=FreezeEffect lodset=2
#exec texture import file=Textures\FreezeGunBlobB_a11.pcx name=FreezeGunBlobB_a11 group=FreezeEffect lodset=2
#exec texture import file=Textures\FreezeGunBlobB_a12.pcx name=FreezeGunBlobB_a12 group=FreezeEffect lodset=2

#exec audio import file=Sounds\FlamerFire.wav name=FlamerFire group=FlameThrower

simulated function PostBeginPlay()
{
	SetCollisionSize(1, 1);
	PlaySound(sound'Vapour');
	Velocity = vector(Rotation) * Default.Speed;
	if ( Owner != None )
		Velocity += 0.3 * Owner.Velocity * FMax(Normal(Owner.Velocity) dot vector(Rotation), 0);
	if ( FRand() > 0.5 )
		Texture = Texture'FreezeGunBlobB_a00';
	
	SetTimer(0.05, True);
	if ( Region.Zone.bWaterZone ) {
		//spawn some effect?
		Destroy();
	}
}

simulated function Tick(float DeltaTime)
{
	DrawScale = Default.DrawScale * (0.05 + Default.LifeSpan - LifeSpan);
}

function ProcessTouch(actor Other, vector HitLocation)
{
	local BurningEffect b;
	local FreezeEffect f;
	
	if ( bDoDamage && LifeSpan + 0.3 < Default.LifeSpan && !Other.IsA('FlameParticle') ) {
		DirectHit(HitLocation, Other, Normal(Velocity));
		if ( Other.bIsPawn ) {
			b = BurningEffect(Pawn(Other).FindInventoryType(class'BurningEffect'));
			if ( b != None ) {
				b.LifeSpan -= 0.5;
				if ( b.LifeSpan <= 0 )
					b.Destroy();
			}
			f = FreezeEffect(Pawn(Other).FindInventoryType(class'FreezeEffect'));
			if ( f == None || f.bDeleteMe ) {
				f = Spawn(class'FreezeEffect');
				f.GiveTo(Pawn(Other));
			}
			else
				f.LifeSpan = FMin(f.LifeSpan + 0.3, 2 * f.default.LifeSpan);
		}
	}
}

simulated function HitWall(vector HitNormal, actor Wall)
{
	Velocity -= (Velocity dot HitNormal) * HitNormal;
	LastHitNormal = HitNormal;
}

defaultproperties
{
     DirectHitString="%o was frozen by %k's %p."
     SplashHitString="%o was frozen by %k's %p."
     SuicideString=" froze himself."
     SuicideFString=" froze herself."
     ProjectileName="ice cloud"
     MyDamageType=Frozen
     Texture=Texture'FreezeGunBlobA_a00'
     LightType=LT_None
     Damage=8
}