class IceCrystal extends Effects;

#exec Texture Import File=Textures\IceSkin.pcx Name=IceSkin Group=Skins

var float MaxSpeed;

simulated function BeginPlay()
{
	if ( Level.NetMode != NM_DedicatedServer ) {
		PlayOwnedSound(EffectSound2);
		LifeSpan *= RandRange(0.8, 1.2);
		Buoyancy = Mass * RandRange(1.1, 1.2);
		DrawScale = FRand() * Default.DrawScale - Default.DrawScale * 2 / 3;
	}
}

simulated function HitWall(vector HitNormal, actor HitWall)
{
	Velocity -= 1.2 * HitNormal * (Velocity Dot HitNormal);
}

simulated function Tick(float DeltaTime)
{
	DrawScale = Default.DrawScale * LifeSpan / Default.LifeSpan;
}

simulated function TakeDamage(int Damage, Pawn InstigatedBy, vector HitLocation, vector Momentum, name DamageType)
{
	Velocity += Normal(Momentum) * FMin(VSize(Momentum) / Mass, MaxSpeed);
	if ( Damage > 20 )
		Destroy();
}

simulated function Touch(actor Other)
{
	HitWall(Normal(Other.Location - Location), Other);
	Velocity += Other.Velocity;
}

defaultproperties
{
     MaxSpeed=500.000000
     LifeSpan=5.000000
     DrawScale=0.200000
     RemoteRole=ROLE_None //ROLE_SimulatedProxy
     bNetTemporary=True
     bHighDetail=True
     Style=STY_Translucent
     Physics=PHYS_Falling
     DrawType=DT_Mesh
     Mesh=LodMesh'Botpack.Crystal'
     bMeshEnviroMap=True
     Texture=Texture'IceSkin'
     CollisionRadius=1.000000
     CollisionHeight=1.000000
     bCollideWorld=True
     bBounce=True
     bCollideActors=True
}