class FlamerScorch extends Scorch;

#exec texture import file=Textures\FlamerScorch.pcx name=FlamerScorch group=Scorch

function PostBeginPlay();/*
{
	local FlamerScorch s;
	
	ForEach RadiusActors(class'FlamerScorch', s, 10)
		if ( !s.bDeleteMe ) {
			Destroy();
			return;
		}
}*/

simulated function SetDrawScale(float NewScale)
{
	if ( bDeleteMe )
		return;
	DrawScale = NewScale;
	Super.PostBeginPlay();
}

simulated function AttachToSurface()
{
	if ( AttachDecal(50 * (DrawScale + 0.3)) == None ) {
		Destroy();
		return;
	}
}

defaultproperties
{
     Texture=Texture'FlamerScorch'
     MultiDecalLevel=4
}