//=============================================================================
// A Flame Thrower with really cool alt-fire. ("cool" as in freezing)
// Created by Wormbo
// wormbo@onlinehome.de  ICQ: 121420825  AIM: wormboeas
//=============================================================================
class FlameThrower extends EnhancedWeapon;

#exec OBJ LOAD FILE=..\Textures\BUFPack2FX.utx PACKAGE=BUFFlameThrower.BUFPack2FX

#exec texture import file=Textures\JFlamer_02.pcx name=JFlamer_02 group=Skins
#exec texture import file=Textures\JFlamer_03.pcx name=JFlamer_03 group=Skins
#exec texture import file=Textures\JFlamer3rd_01.pcx name=JFlamer3rd_01 group=Skins
#exec texture import file=Textures\JFlamerPickup_01.pcx name=JFlamerPickup_01 group=Skins

//#exec audio import file=Sounds\NapalmShot.wav name=NapalmShot group=FlameThrower

var FlameSpawner Flame;
var float Count;
//var bool bSmallFlame;
var Texture ThirdPersonSkin;

simulated event RenderOverlays(canvas Canvas)
{
	Texture'Ammoled'.NotifyActor = Self;
	MultiSkins[1] = None;
//	if ( bSmallFlame )
//		bMuzzleFlash = 1;
	Super.RenderOverlays(Canvas);
	MultiSkins[1] = ThirdPersonSkin;
	Texture'Ammoled'.NotifyActor = None;
}

function BecomePickup()
{
	Super.BecomePickup();
	MultiSkins[1] = Default.MultiSkins[1];
}

function BecomeItem()
{
	Super.BecomeItem();
	MultiSkins[1] = ThirdPersonSkin;
}

// set which hand is holding weapon
function setHand(float Hand)
{
	if ( Hand == 2 ) {
		FireOffset.Y = 0;
		bHideWeapon = true;
		return;
	}
	else
		bHideWeapon = false;
	PlayerViewOffset = Default.PlayerViewOffset * 100;
	if ( Hand == 1 ) {
		FireOffset.Y = Default.FireOffset.Y;
		Mesh = Mesh(DynamicLoadObject("Botpack.PulseGunL", class'Mesh'));
	}
	else {
		FireOffset.Y = -1 * Default.FireOffset.Y;
		Mesh = mesh'PulseGunR';
	}
}

simulated event RenderTexture(ScriptedTexture Tex)
{
	local Color C;
	local string Temp;
	local int AmmoAmount;
	
	if ( AmmoType != None )
		AmmoAmount = AmmoType.AmmoAmount;
	else
		AmmoAmount = AmmoName.default.AmmoAmount;
	
	Temp = String(AmmoAmount);
	
	while (Len(Temp) < 3)
		Temp = "0" $ Temp;
	
	Tex.DrawTile(30, 100, Min(AmmoAmount, AmmoName.Default.AmmoAmount) * 196 / AmmoName.Default.AmmoAmount, 10, 0, 0, 1, 1, Texture'AmmoCountBar', False);
	
	if ( AmmoAmount < 10 ) {
		C.R = 255;
		C.G = 0;
		C.B = 0;	
	}
	else {
		C.R = 0;
		C.G = 0;
		C.B = 255;
	}
	
	Tex.DrawColoredText(56, 14, Temp, Font'LEDFont', C);	
}

function float RateSelf( out int bUseAltMode )
{
	local Pawn P;
	
	if ( AmmoType.AmmoAmount <= 0 )
		return -2;
	
	bUseAltMode = Rand(2);
	P = Pawn(Owner);
	if ( P.Enemy == None || (Owner.IsA('Bot') && Bot(Owner).bQuickFire) )
		return AIRating;
	else if ( VSize(P.Enemy.Location - P.Location) > 700 )
		return 0;
	
	if ( P.Enemy.IsA('StationaryPawn') ) {
		bUseAltMode = 0;
		return AIRating + 0.4;
	}
	
	AIRating *= FMin(Pawn(Owner).DamageScaling, 1.5);
	return AIRating;
}

simulated function Destroyed()
{
	if ( Flame != None )
		Flame.Destroy();
	
	Super.Destroyed();
}

simulated function PlayIdleAnim()
{
	if ( Mesh == PickupViewMesh )
		return;
	
//	bSmallFlame = True;
	if ( AnimSequence == 'BoltLoop' || AnimSequence == 'BoltStart' )
		PlayAnim('BoltEnd');		
	else if ( AnimSequence != 'SpinDown' )
		TweenAnim('Idle', 0.1);
}

function Fire(float Value)
{
	if ( AmmoType == None )
		GiveAmmo(Pawn(Owner));
	if ( AmmoType.UseAmmo(1) ) {
		GotoState('NormalFire');
		bCanClientFire = true;
		bPointing = True;
		Pawn(Owner).PlayRecoil(FiringSpeed);
		ClientFire(Value);
		if ( Flame == None ) {
			Flame = FlameSpawner(ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget));
			Flame.FireOffset = FireOffset;
		}
	}
}

simulated function PlayFiring()
{
//	bSmallFlame = False;
	if ( AnimSequence == 'BoltLoop' || AnimSequence == 'BoltStart' )		
		PlayAnim('boltloop');
	else
		PlayAnim('boltstart');
}

state NormalFire
{
	ignores AnimEnd;
	
	function Tick(float DeltaTime)
	{
		local Pawn P;
		
		P = Pawn(Owner);
		if ( P == None ) {
			GotoState('Pickup');
			return;
		}
		if ( P.bFire == 0 || P.Weapon != Self || (P.IsA('Bot') && (P.Enemy == None
				|| Level.TimeSeconds - Bot(P).LastSeenTime > 5)) ) {
			P.bFire = 0;
			Finish();
			return;
		}
		
		if ( Flame == None ) {
			Flame = FlameSpawner(ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget));
			Flame.FireOffset = FireOffset;
			/*if ( FireOffset.Y == 0 )
				Flame.bCenter = true;
			else if ( Mesh != Mesh'PulseGunR' )
				Flame.bRight = false;
			*/
		}
		
		Count += Deltatime;
		if ( Count > 0.2 ) {
			if ( Owner.IsA('PlayerPawn') )
				PlayerPawn(Owner).ClientInstantFlash(InstFlash, InstFog);
			if ( Affector != None )
				Affector.FireEffect();
			Count -= 0.2;
			if ( Flame != None && !AmmoType.UseAmmo(1) )
				Finish();
		}
	}
	
	function EndState()
	{
		AmbientGlow = 0;
		if ( Flame != None ) {
			Flame.Destroy();
			Flame = None;
		}
		Super.EndState();
	}

Begin:
	AmbientGlow = 200;
	FinishAnim();	
	LoopAnim('boltloop');
}

state ClientFiring
{
	simulated function AnimEnd()
	{
		if ( AmmoType != None && AmmoType.AmmoAmount <= 0 ) {
			PlayIdleAnim();
			GotoState('');
		}
		else if ( !bCanClientFire )
			GotoState('');
		else if ( Pawn(Owner) == None || Pawn(Owner).Weapon != Self ) {
			PlayIdleAnim();
			GotoState('');
		}
		else if ( Pawn(Owner).bFire != 0 )
			LoopAnim('BoltLoop');
		else if ( Pawn(Owner).bAltFire != 0 )
			Global.ClientAltFire(0);
		else {
			PlayIdleAnim();
			GotoState('');
		}
	}
	
	simulated function BeginState()
	{
		Super.BeginState();
		SetTimer(0.4 / SpeedScale, True);
	}
	
	simulated function EndState()
	{
		SetTimer(0.0, False);
		Super.EndState();
	}
	
	simulated function Timer()
	{
		SetTimer(0.3 / SpeedScale, True);
		if ( Affector != None )
			Affector.FireEffect();
	}
}

function AltFire(float Value)
{
	if ( AmmoType == None )
		GiveAmmo(Pawn(Owner));
	if ( AmmoType.UseAmmo(1) ) {
		GotoState('AltFiring');
		bCanClientFire = true;
		bPointing = True;
		Pawn(Owner).PlayRecoil(FiringSpeed);
		ClientAltFire(Value);
		if ( Flame == None ) {
			Flame = FlameSpawner(ProjectileFire(AltProjectileClass, ProjectileSpeed, bWarnTarget));
			Flame.FireOffset = FireOffset;
			/*if ( FireOffset.Y == 0 )
				Flame.bCenter = true;
			else if ( Mesh == Mesh'PulseGunR' )
				Flame.bRight = false;*/
		}
	}
}

simulated function PlayAltFiring()
{
//	bSmallFlame = False;
	if ( AnimSequence == 'BoltLoop' || AnimSequence == 'BoltStart' )		
		PlayAnim('boltloop');
	else
		PlayAnim('boltstart');
}

state AltFiring
{
	ignores AnimEnd;
	
	function Tick(float DeltaTime)
	{
		local Pawn P;
		
		P = Pawn(Owner);
		if ( P == None ) {
			GotoState('Pickup');
			return;
		}
		if ( P.bAltFire == 0 || P.Weapon != Self || (P.IsA('Bot') && (P.Enemy == None
				|| Level.TimeSeconds - Bot(P).LastSeenTime > 5)) ) {
			P.bAltFire = 0;
			Finish();
			return;
		}
		
		if ( Flame == None ) {
			Flame = FlameSpawner(ProjectileFire(AltProjectileClass, ProjectileSpeed, bWarnTarget));
			Flame.FireOffset = FireOffset;
			/*if ( FireOffset.Y == 0 )
				Flame.bCenter = true;
			else if ( Mesh == Mesh'PulseGunR' )
				Flame.bRight = false;*/
		}
		
		Count += Deltatime;
		if ( Count > 0.2 ) {
			if ( Owner.IsA('PlayerPawn') )
				PlayerPawn(Owner).ClientInstantFlash(InstFlash, InstFog);
			if ( Affector != None )
				Affector.FireEffect();
			Count -= 0.2;
			if ( Flame != None && !AmmoType.UseAmmo(1) )
				Finish();
		}
	}
	
	function EndState()
	{
		AmbientGlow = 0;
		if ( Flame != None ) {
			Flame.Destroy();
			Flame = None;
		}
		Super.EndState();
	}

Begin:
	AmbientGlow = 200;
	FinishAnim();	
	LoopAnim('boltloop');
}

state ClientAltFiring
{
	simulated function AnimEnd()
	{
		if ( AmmoType.AmmoAmount <= 0 ) {
			PlayIdleAnim();
			GotoState('');
		}
		else if ( !bCanClientFire )
			GotoState('');
		else if ( Pawn(Owner) == None || Pawn(Owner).Weapon != Self ) {
			PlayIdleAnim();
			GotoState('');
		}
		else if ( Pawn(Owner).bAltFire != 0 )
			LoopAnim('BoltLoop');
		else if ( Pawn(Owner).bFire != 0 )
			Global.ClientFire(0);
		else {
			PlayIdleAnim();
			GotoState('');
		}
	}
	
	simulated function BeginState()
	{
		Super.BeginState();
		SetTimer(0.4 / SpeedScale, True);
	}
	
	simulated function EndState()
	{
		SetTimer(0.0, False);
		Super.EndState();
	}
	
	simulated function Timer()
	{
		SetTimer(0.3 / SpeedScale, True);
		if ( Affector != None )
			Affector.FireEffect();
	}
}

defaultproperties
{
     ProjectileClass=class'FlameSpawner'
     AltProjectileClass=class'IceSpawner'
     WeaponDescription="Classification: Flame Thrower\n\nPrimary Fire: A large flame is fired that can roast opponents within seconds.\n\nSecondary Fire: Shoots a cloud of super-cooled gas which slows down opponents.\n\nTechniques: Primary fire can be used to un-freeze players, while secondary extinguishes fire."
     InstFlash=-0.150000
     InstFog=(X=218.000000,Y=169.000000,Z=72.000000)
     AmmoName=Class'FlameAmmo'
     PickupAmmoCount=60
     bRapidFire=True
     FireOffset=(X=16.000000,Y=-14.000000,Z=-8.000000)
     shakemag=135.000000
     shakevert=8.000000
     AIRating=0.700000
     AltRefireRate=0.950000
     RefireRate=0.990000
     SelectSound=Sound'Botpack.PulseGun.PulsePickup'
     MessageNoAmmo=" has no napalm gel."
     NameColor=(R=128,B=128)
     FlashLength=0.020000
     AutoSwitchPriority=5
     InventoryGroup=5
     PickupMessage="You got a Flame Thrower"
     ItemName="Flame Thrower"
     PlayerViewOffset=(X=1.500000,Z=-2.000000)
     PlayerViewMesh=LodMesh'Botpack.PulseGunR'
     PickupViewMesh=LodMesh'Botpack.PulsePickup'
     ThirdPersonMesh=LodMesh'Botpack.PulseGun3rd'
     ThirdPersonScale=0.400000
     StatusIcon=Texture'Botpack.Icons.UsePulse'
     bDrawMuzzleFlash=True
     MFTexture=Texture'SmallFlame'
     MuzzleScale=2.000000
     FlashY=0.160000
     FlashO=0.015000
     FlashC=0.100000
     FlashLength=0.020000
     FlashS=32
     PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
     Icon=Texture'Botpack.Icons.UsePulse'
     Mesh=LodMesh'Botpack.PulsePickup'
     MultiSkins(2)=Texture'JFlamer_02'
     MultiSkins(3)=Texture'JFlamer_03'
     ThirdPersonSkin=Texture'JFlamer3rd_01'
     MultiSkins(1)=Texture'JFlamerPickup_01'
     bNoSmooth=False
     SoundRadius=64
     SoundVolume=255
     CollisionRadius=32.000000
}
