//=============================================================================
// FlameSpawner.
// Spawns FlameParticle actors seperately on server and client (completely
// simulated) while the FlameThrower's primary fire is used.
//=============================================================================
class FlameSpawner extends Projectile;

//#exec texture import file=Textures\NapalmFire_a01.pcx name=NapalmFire_a00 group=FlameEffect
//#exec texture import file=Textures\NapalmFire_a02.pcx name=NapalmFire_a01 group=FlameEffect
//#exec texture import file=Textures\NapalmFire_a03.pcx name=NapalmFire_a02 group=FlameEffect
//#exec texture import file=Textures\NapalmFire_a04.pcx name=NapalmFire_a03 group=FlameEffect
//#exec texture import file=Textures\NapalmFire_a05.pcx name=NapalmFire_a04 group=FlameEffect
//#exec texture import file=Textures\NapalmFire_a06.pcx name=NapalmFire_a05 group=FlameEffect

#exec audio import file=Sounds\Bubble.wav name=MakeBubble group=FlameThrower

var int ParticleCounter;
//var bool bRight, bCenter;
var float OldError, NewError, StartError, AimError; //used for bot aiming
var rotator AimRotation;
var vector FireOffset;

replication
{
	reliable if ( Role == ROLE_Authority )
		FireOffset;
}

simulated function PostBeginPlay()
{
	SetTimer(0.05, True);
	if ( Instigator == None )
		return;
	if ( Instigator.IsA('Bot') && Bot(Instigator).bNovice )
		AimError = 2200 + (3 - Instigator.Skill) * 300;
	else
		AimError = 1000 + (3 - Instigator.Skill) * 400;

	if ( FRand() < 0.5 )
		AimError *= -1;
}

simulated function PostNetBeginPlay()
{
	if ( Instigator == None )
		return;
	if ( Instigator.IsA('Bot') && Bot(Instigator).bNovice )
		AimError = 2200 + (3 - Instigator.Skill) * 300;
	else
		AimError = 1000 + (3 - Instigator.Skill) * 400;

	if ( FRand() < 0.5 )
		AimError *= -1;
}

simulated function Timer()
{
	local FlamePArticle p;
	local SmallFBubble b;
	
	if ( Instigator == None || Instigator.Health <= 0 || FlameThrower(Instigator.Weapon) == None
			|| Instigator.bFire == 0 ) {
		Destroy();
		return;
	}
	
	if ( !Region.Zone.bWaterZone || Region.Zone.IsA('NitrogenZone') ) {
		p = Spawn(class'FlameParticle', Instigator);
		if ( p != None && Level.NetMode != NM_Client && ParticleCounter++ % 3 == 0 )
			p.bDoDamage = True;
	}
	else {
		b = Spawn(class'SmallFBubble');
		//b.RemoteRole = ROLE_SimulatedProxy;	// purely client-side simulation
		b.Velocity = vector(Rotation) * 0.7 * class'FlameParticle'.Default.Speed + 0.25 * Instigator.Velocity * FMax(Normal(Instigator.Velocity) dot vector(Rotation), 0);
		b.PlaySound(sound'MakeBubble',,,,, RandRange(0.9, 1.1));
	}
}

simulated function Tick(float DeltaTime)
{
	local vector X, Y, Z, AimSpot, DrawOffset, AimStart;
	local int YawErr;
	local float dAdjust;
	local Bot MyBot;
	
	// orient with respect to instigator
	if ( Instigator != None ) {
		if ( Level.NetMode == NM_Client && (!Instigator.IsA('PlayerPawn')
				|| ViewPort(PlayerPawn(Instigator).Player) == None) ) {
			SetRotation(AimRotation); 
			Instigator.ViewRotation = AimRotation;
			DrawOffset = (0.01 * class'FlameThrower'.Default.PlayerViewOffset) >> Rotation;
			DrawOffset += Instigator.EyeHeight * vect(0,0,1);
		}
		else {
			MyBot = Bot(Instigator);
			if ( MyBot != None ) {
				if ( Instigator.Target == None && Instigator.Enemy != None )
					Instigator.Target = Instigator.Enemy;
				if ( Instigator.Target == Instigator.Enemy ) {
					if ( MyBot.bNovice )
						dAdjust = DeltaTime * (4 + Instigator.Skill) * 0.075;
					else
						dAdjust = DeltaTime * (4 + Instigator.Skill) * 0.12;
					if ( OldError > NewError )
						OldError = FMax(OldError - dAdjust, NewError);
					else
						OldError = FMin(OldError + dAdjust, NewError);
					
					if ( OldError == NewError )
						NewError = FRand() - 0.5;
					if ( StartError > 0 )
						StartError -= DeltaTime;
					else if ( MyBot.bNovice && Level.TimeSeconds - MyBot.LastPainTime < 0.2 )
						StartError = MyBot.LastPainTime;
					else
						StartError = 0;
					AimSpot = 1.25 * Instigator.Target.Velocity + 0.75 * Instigator.Velocity;
					if ( Abs(AimSpot.Z) < 120 )
						AimSpot.Z *= 0.25;
					else
						AimSpot.Z *= 0.5;
					if ( Instigator.Target.Physics == PHYS_Falling )
						AimSpot = Instigator.Target.Location - 0.0007 * AimError * OldError * AimSpot;
					else
						AimSpot = Instigator.Target.Location - 0.0005 * AimError * OldError * AimSpot;
					if ( Instigator.Physics == PHYS_Falling && Instigator.Velocity.Z > 0 )
						AimSpot = AimSpot - 0.0003 * AimError * OldError * AimSpot;
					
					AimStart = Instigator.Location + FireOffset.X * X + FireOffset.Y * Y + (1.2 * FireOffset.Z - 2) * Z; 
					if ( FastTrace(AimSpot - vect(0,0,10), AimStart) )
						AimSpot	= AimSpot - vect(0,0,10);
					GetAxes(Instigator.Rotation,X,Y,Z);
					AimRotation = Rotator(AimSpot - AimStart);
					AimRotation.Yaw = AimRotation.Yaw + (OldError + StartError) * 0.75 * aimerror;
					YawErr = (AimRotation.Yaw - (Instigator.Rotation.Yaw & 65535)) & 65535;
					if ( YawErr > 3000 && YawErr < 62535 ) {
						if ( YawErr < 32768 )
							AimRotation.Yaw = Instigator.Rotation.Yaw + 3000;
						else
							AimRotation.Yaw = Instigator.Rotation.Yaw - 3000;
					}
				}
				else if ( Instigator.Target != None )
					AimRotation = Rotator(Instigator.Target.Location - Instigator.Location);
				else
					AimRotation = Instigator.ViewRotation;
				Instigator.ViewRotation = AimRotation;
				SetRotation(AimRotation);
			}
			else {
				AimRotation = Instigator.ViewRotation;
				SetRotation(AimRotation);
			}
			if ( Instigator.Weapon != None )
				DrawOffset = Instigator.Weapon.CalcDrawOffset();
		}
		GetAxes(Instigator.ViewRotation, X, Y, Z);

		/*if ( bCenter ) {
			FireOffset.Z = Default.FireOffset.Z * 1.5;
			FireOffset.Y = 0;
		}
		else {
			FireOffset.Z = Default.FireOffset.Z;
			if ( bRight )
				FireOffset.Y = Default.FireOffset.Y;
			else
				FireOffset.Y = -1 * Default.FireOffset.Y;
		}*/
		SetLocation(Instigator.Location + DrawOffset + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z);
	}
}

defaultproperties
{
     FireOffset=(X=16.000000,Y=-14.000000,Z=-8.000000)
     DrawType=DT_None //DT_Sprite
     Physics=PHYS_None
     RemoteRole=ROLE_SimulatedProxy
     bAlwaysRelevant=True
//     Style=STY_Translucent
//     Texture=Texture'NapalmFire_a00'
//     bOwnerNoSee=True
//     DrawScale=0.100000
}