class FlameParticle extends EnhancedProjectile;

#exec texture import file=Textures\NapalmGunBlobA_a00.pcx name=NapalmGunBlobA_a00 group=FlameEffect lodset=2
#exec texture import file=Textures\NapalmGunBlobA_a01.pcx name=NapalmGunBlobA_a01 group=FlameEffect lodset=2
#exec texture import file=Textures\NapalmGunBlobA_a02.pcx name=NapalmGunBlobA_a02 group=FlameEffect lodset=2
#exec texture import file=Textures\NapalmGunBlobA_a03.pcx name=NapalmGunBlobA_a03 group=FlameEffect lodset=2
#exec texture import file=Textures\NapalmGunBlobA_a04.pcx name=NapalmGunBlobA_a04 group=FlameEffect lodset=2
#exec texture import file=Textures\NapalmGunBlobA_a05.pcx name=NapalmGunBlobA_a05 group=FlameEffect lodset=2
#exec texture import file=Textures\NapalmGunBlobA_a06.pcx name=NapalmGunBlobA_a06 group=FlameEffect lodset=2
#exec texture import file=Textures\NapalmGunBlobA_a07.pcx name=NapalmGunBlobA_a07 group=FlameEffect lodset=2
#exec texture import file=Textures\NapalmGunBlobA_a08.pcx name=NapalmGunBlobA_a08 group=FlameEffect lodset=2
#exec texture import file=Textures\NapalmGunBlobA_a09.pcx name=NapalmGunBlobA_a09 group=FlameEffect lodset=2
#exec texture import file=Textures\NapalmGunBlobA_a10.pcx name=NapalmGunBlobA_a10 group=FlameEffect lodset=2
#exec texture import file=Textures\NapalmGunBlobA_a11.pcx name=NapalmGunBlobA_a11 group=FlameEffect lodset=2
#exec texture import file=Textures\NapalmGunBlobA_a12.pcx name=NapalmGunBlobA_a12 group=FlameEffect lodset=2

#exec texture import file=Textures\NapalmGunBlobB_a00.pcx name=NapalmGunBlobB_a00 group=FlameEffect lodset=2
#exec texture import file=Textures\NapalmGunBlobB_a01.pcx name=NapalmGunBlobB_a01 group=FlameEffect lodset=2
#exec texture import file=Textures\NapalmGunBlobB_a02.pcx name=NapalmGunBlobB_a02 group=FlameEffect lodset=2
#exec texture import file=Textures\NapalmGunBlobB_a03.pcx name=NapalmGunBlobB_a03 group=FlameEffect lodset=2
#exec texture import file=Textures\NapalmGunBlobB_a04.pcx name=NapalmGunBlobB_a04 group=FlameEffect lodset=2
#exec texture import file=Textures\NapalmGunBlobB_a05.pcx name=NapalmGunBlobB_a05 group=FlameEffect lodset=2
#exec texture import file=Textures\NapalmGunBlobB_a06.pcx name=NapalmGunBlobB_a06 group=FlameEffect lodset=2
#exec texture import file=Textures\NapalmGunBlobB_a07.pcx name=NapalmGunBlobB_a07 group=FlameEffect lodset=2
#exec texture import file=Textures\NapalmGunBlobB_a08.pcx name=NapalmGunBlobB_a08 group=FlameEffect lodset=2
#exec texture import file=Textures\NapalmGunBlobB_a09.pcx name=NapalmGunBlobB_a09 group=FlameEffect lodset=2
#exec texture import file=Textures\NapalmGunBlobB_a10.pcx name=NapalmGunBlobB_a10 group=FlameEffect lodset=2
#exec texture import file=Textures\NapalmGunBlobB_a11.pcx name=NapalmGunBlobB_a11 group=FlameEffect lodset=2
#exec texture import file=Textures\NapalmGunBlobB_a12.pcx name=NapalmGunBlobB_a12 group=FlameEffect lodset=2

#exec audio import file=Sounds\FlamerFire.wav name=FlamerFire group=FlameThrower
#exec audio import file=Sounds\HitFire.wav name=HitFire group=FlameThrower

var float ScorchTime;
var vector LastHitNormal;
var bool bDoDamage;

simulated function PostBeginPlay()
{
	SetCollisionSize(1, 1);
	PlaySound(sound'FlamerFire');
	Velocity = vector(Rotation) * Default.Speed;
//	if ( Owner != None )
//		Velocity += 0.3 * Owner.Velocity * FMax(Normal(Owner.Velocity) dot vector(Rotation), 0);
//	Acceleration = -vector(Rotation) * Default.Speed * 0.5 + vect(0,0,5);
	if ( FRand() > 0.5 )
		Texture = Texture'NapalmGunBlobB_a00';
	
	SetTimer(0.05, True);
	if ( Region.Zone.bWaterZone ) {
		//spawn some effect?
		Destroy();
	}
}

//simulated function PostNetBeginPlay()
//{
//	Velocity =+ 0.3 * Owner.Velocity * FMax(Normal(Owner.Velocity) dot vector(Rotation), 0);
//}

simulated function Tick(float DeltaTime)
{
	local FlamerScorch s;
	
	if ( bDoDamage && LightType == LT_None && Level.bHighDetailMode && !bDropEffects )
		LightType = LT_Steady;
	
	DrawScale = Default.DrawScale * (0.05 + Default.LifeSpan - LifeSpan);
	LightRadius = Default.LightRadius * Sqrt(2 * DrawScale);
	LightBrightness =  Default.LightBrightness * FMin(FMin(3 * LifeSpan, Default.LifeSpan - LifeSpan), 1);
	ScorchTime += DeltaTime;
	if ( bDoDamage && ScorchTime > 0.2 && FRand() < 0.3 ) {
		ScorchTime -= 0.2;
		s = Spawn(class'FlamerScorch',,,, rotator(LastHitNormal));
	}
	if ( s != None )
		s.SetDrawScale(DrawScale * 0.2);
}

simulated function Timer()
{
	Velocity *= 0.97;
	Velocity += vect(0,0,1);
	SetCollisionSize(Default.CollisionRadius * DrawScale, Default.CollisionHeight * DrawScale);
//	if ( RemoteRole == ROLE_DumbProxy )
//		RemoteRole = ROLE_SimulatedProxy;
}

function ProcessTouch(actor Other, vector HitLocation)
{
	local BurningEffect b;
	local FreezeEffect f;
	
	if ( bDoDamage && Level.NetMode != NM_Client && LifeSpan + 0.3 < Default.LifeSpan && !Other.IsA('FlameParticle') ) {
		DirectHit(HitLocation, Other, Normal(Velocity));
		if ( Other.bIsPawn ) {
			f = FreezeEffect(Pawn(Other).FindInventoryType(class'FreezeEffect'));
			if ( f != None ) {
				f.LifeSpan -= 0.5;
				if ( f.LifeSpan <= 0 )
					f.Destroy();
			}
			b = BurningEffect(Pawn(Other).FindInventoryType(class'BurningEffect'));
			if ( b == None || b.bDeleteMe ) {
				b = Spawn(class'BurningEffect', Other);
				b.GiveTo(Pawn(Other));
				b.MyInstigator = Instigator;
				b.Activate();
				if ( b.ShellEffect != None )
					b.ShellEffect.PlaySound(Sound'HitFire');
			}
			else {
				b.LifeSpan = b.default.LifeSpan;
				b.MyInstigator = Instigator;
				if ( b.ShellEffect != None )
					b.ShellEffect.PlaySound(Sound'HitFire');
			}
		}
	}
}

simulated function HitWall(vector HitNormal, actor Wall)
{
	local FlamerScorch s;
	
	Velocity -= (Velocity dot HitNormal) * HitNormal;
//	Velocity = (VSize(Velocity) * (Velocity dot HitNormal)) * Normal(Velocity - (Velocity dot HitNormal) * HitNormal);
//	Acceleration -= vect(0,0,5);
//	Acceleration += (Acceleration dot HitNormal) * HitNormal;
//	Acceleration += vect(0,0,5);
	LastHitNormal = HitNormal;
	
	if ( bDoDamage && Level.bHighDetailMode && !Level.bDropDetail && FRand() < 0.3 ) {
		ScorchTime -= 0.2;
		s = Spawn(class'FlamerScorch',,,, rotator(HitNormal));
	}
	if ( s != None )
		s.SetDrawScale(DrawScale * 0.2);
}

simulated function ZoneChange(ZoneInfo NewZone)
{
	if ( NewZone.bWaterZone )
		SetPhysics(PHYS_Falling);
}

defaultproperties
{
     DirectHitString="%o was roasted by %k's %w."
     SplashHitString="%o was roasted by %k's %w."
     SuicideString=" roasted himself."
     SuicideFString=" roasted herself."
     ProjectileName="flame"
     Damage=6
     LastHitNormal=(Z=1.000000)
     MyDamageType=Burned
     MomentumTransfer=1000.000000
     DrawType=DT_SpriteAnimOnce
     RemoteRole=ROLE_None //ROLE_SimulatedProxy
     bNetTemporary=True
     MaxSpeed=1000.000000
     Speed=600.000000
     DrawScale=3.500000
     LightEffect=LE_None
     LightBrightness=255
     LightHue=20
     LightRadius=5
     CollisionHeight=15.000000
     CollisionRadius=15.000000
     bCollideWorld=True
     bBounce=True
     Physics=PHYS_Projectile
     Style=STY_Translucent
     Texture=Texture'NapalmGunBlobA_a00'
     LastHitNormal=(Z=1.000000)
     LifeSpan=1.600000
     Mass=10.000000
     Buoyancy=25.000000
     FiredFrom=class'FlameThrower'
}