class BurningEffect extends PickupPlus;

var float DamageTime;
var Pawn MyInstigator;
var FireNotify FireNotify;

function Spawned()
{
	FireNotify = Spawn(class'FireNotify');
}

function Tick(float DeltaTime)
{
	local float DamageScale;
	
	if ( Pawn(Owner) != None && Pawn(Owner).PlayerReplicationInfo != None && FireNotify != None && FireNotify.Owner != Pawn(Owner).PlayerReplicationInfo )
		FireNotify.SetOwner(Pawn(Owner).PlayerReplicationInfo);
	
	if ( bDeleteMe )
		return;
	
	if ( Pawn(Owner) == None || Pawn(Owner).HeadRegion.Zone.bWaterZone && !Pawn(Owner).HeadRegion.Zone.IsA('NitrogenZone')
			|| LifeSpan <= 0 ) {
		Destroy();
		return;
	}
	
	if ( VSize(Owner.Velocity) > 2 * Pawn(Owner).default.GroundSpeed )
		LifeSpan -= 0.5 * DeltaTime * VSize(Owner.Velocity) / Pawn(Owner).default.GroundSpeed;
	
	DamageTime += DeltaTime;
	if ( DamageTime > 0.2 ) {
		if ( Owner.Region.Zone.bWaterZone && !Owner.Region.Zone.IsA('NitrogenZone') )
			DamageScale = 0.2;
		else if ( Pawn(Owner).FootRegion.Zone.bWaterZone && !Pawn(Owner).FootRegion.Zone.IsA('NitrogenZone') )
			DamageScale = 0.4;
		else
			DamageScale = 0.5;
		
		DamageTime -= 0.2;
		SetKillType(False, False, class'FlameParticle');
		Owner.TakeDamage(DamageScale * class'FlameParticle'.default.Damage, MyInstigator, Owner.Location, vect(0,0,0), 'Burned');
		RestoreKillType();
	}
}

simulated function Destroyed()
{
	if ( ShellEffect != None )
		ShellEffect.DestroyMe();
	
	if ( FireNotify != None )
		FireNotify.LifeSpan = 0.5;
	
	Super(TournamentPickup).Destroyed();
}

defaultproperties
{
     ShellType=class'BurningShell'
     ShellSkin=FireTexture'SmallFlame'
     bShellAlwaysOn=True
     DrawType=DT_None
     bReplicateInstigator=False
     LifeSpan=2.500000
}