class BurningCarcass extends EIEffects;

#exec OBJ LOAD FILE=..\Textures\BUFPack2FX.utx PACKAGE=BUFFlameThrower.BUFPack2FX

var() float VanishTime, VisibleTime, AnimTime;
var() float MinGlow, MaxGlow;
var float CurGlow;

var float CurSize;
var() float StartSize, MinSize, MaxSize, EndSize;

function PostBeginPlay()
{
	Super.PostBeginPlay();
	
	if ( Owner != None )
		Mesh = Owner.Mesh;
}

function DestroyMe()
{
	bDestroyMe = True;
	
	VisibleTime = 0.0;
	
	if ( IsInState('Visible') ) {
		CurSize = DrawScale;
		CurGlow = ScaleGlow;
		GotoState('Vanishing', 'Begin');
	}
	else if ( bHidden || !IsInState('Vanishing') )
		Destroy();
}

auto state Visible
{
	simulated function Tick(float DeltaTime)
	{
		if ( Owner == None || Owner.bDeleteMe ) {
			CurSize = DrawScale;
			CurGlow = ScaleGlow;
			GotoState('Vanishing');
		}
	}
}

state Vanishing
{
	simulated function Tick(float DeltaTime)
	{
		AnimTime += DeltaTime;
		ScaleGlow = CurGlow * (VanishTime - AnimTime) / VanishTime;
		DrawScale = CurSize * (VanishTime - AnimTime) / VanishTime;
		AmbientGlow = Default.AmbientGlow * ScaleGlow;
	}
			
Begin:
	AnimTime = 0.0;
	Sleep(VanishTime);
	Destroy();
}

defaultproperties
{
     StartSize=0.010000
     bTrailerSameRotation=True
     bOwnerNoSee=True
     bNetTemporary=False
     bAnimByOwner=True
     Physics=PHYS_Trailer
     RemoteRole=ROLE_None
     LODBias=0.500000
     DrawType=DT_Mesh
     Style=STY_Translucent
     VanishTime=0.3
     bParticles=True
     bRandomFrame=True
     Texture=FireTexture'SmallFlame'
     ScaleGlow=0.500000
     bUnlit=True
     LightType=LT_Steady
     LightEffect=LE_FireWaver
     LightHue=25
     LightBrightness=200
     LightRadius=9
}