Class Warbringer Extends Enforcer; 

Var Float FWarbringerAnimRate; 
Var Int HeadshotDamage; 

Function SetSwitchPriority (Pawn Other) 
{
	Local Int Integer; 
	If (PlayerPawn(Other) != None) 
	{ 
		For (Integer=0; Integer<20; Integer++) 
			If (PlayerPawn(Other).WeaponPriority[Integer] == 'DoubleEnforcer') 
			{ 
				AutoSwitchPriority = Integer; 
				DoubleSwitchPriority = Integer; 
				Return; 
			} 
	} 	
} 

Function DropFrom (Vector StartLocation) 
{ 
} 

Simulated Function PlayFiring () 
{ 
	PlayOwnedSound(FireSound, SLOT_None,2.0*Pawn(Owner).SoundDampening); 
	bMuzzleFlash++; 
	PlayAnim('Shoot', FWarbringerAnimRate, 0.02); 
} 

Simulated Function PlayAltFiring () 
{ 
	PlayAnim('T1', FWarbringerAnimRate, 0.05); 
	bFirstFire = True;
} 

Simulated Function PlayRepeatFiring () 
{ 
	If (Affector != None) 
		Affector.FireEffect(); 
	If (PlayerPawn(Owner) != None) 
	{ 
		PlayerPawn(Owner).ClientInstantFlash( -0.2, vect(325, 225, 95)); 
		PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert); 
	} 
	bMuzzleFlash++; 
	PlayOwnedSound(FireSound, SLOT_None,2.0*Pawn(Owner).SoundDampening); 
	PlayAnim('Shot2', FWarbringerAnimRate, 0.05); 
} 

Function ProcessTraceHit (Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z) 
{ 
	Local UT_Shellcase Shellcase; 
	Local Vector RealLoc; 
	Local Int RoundDamage; 
	RealLoc = Owner.Location + CalcDrawOffset(); 
	Pawn(Owner).Health -= 1; 
	PlayerPawn(Owner).ClientFlash(0,Vect(255,0,0)); 
	If (Pawn(Owner).Health <= 0) 
	{ 
		Pawn(Owner).Died (None, 'Suicided', Location); 
	} 
	If (Other == Level) 
	{ 
		If (bIsSlave || (SlaveEnforcer != None)) 
			Spawn(Class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal)); 
		Else 
			Spawn(Class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal)); 
	} 
	Else If ((Other != self) && (Other != Owner) && (Other != None)) 
	{ 
		If (FRand() < 0.2) 
			X *= 5; 
		If (Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) && (Instigator.IsA('PlayerPawn') || (Instigator.IsA('Bot') && !Bot(Instigator).bNovice))) 
			Other.TakeDamage(HeadshotDamage, Pawn(Owner), HitLocation, 35000 * X, AltDamageType); 
		Other.TakeDamage(HitDamage, Pawn(Owner), HitLocation, 3000.0*X, MyDamageType); 
		If (!Other.bIsPawn && !Other.IsA('Carcass')) 
			Spawn(Class'UT_BigBloodPuff',,,HitLocation+HitNormal*9); 
		Else 
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100); 
	} 
} 

Simulated Function PlayNormRepeatFiring () 
{ 
	If (Affector != None) 
		Affector.FireEffect(); 
	If (PlayerPawn(Owner) != None) 
	{ 
		PlayerPawn(Owner).ClientInstantFlash( -0.2, vect(325, 225, 95)); 
		PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert); 
	} 
	bMuzzleFlash++; 
	PlayOwnedSound(FireSound, SLOT_None,2.0*Pawn(Owner).SoundDampening); 
	PlayAnim('Shoot', FWarbringerAnimRate, 0.05); 
} 

State NormalFire 
{ 
	Ignores Fire, AltFire, AnimEnd; 
	
	Function Timer ()
	{ 
		If (SlaveEnforcer != None) 
			SlaveEnforcer.Fire(0); 
	} 

	Function EndState () 
	{ 
		Super.EndState(); 
		OldFlashCount = FlashCount; 
	} 

	Begin: 
	If (SlaveEnforcer != None) 
		SetTimer(0.20, false); 

	Repeater:	
	If (AmmoType.UseAmmo(1)) 
	{ 
		FlashCount++; 
		TraceFire(0.2); 
		PlayNormRepeatFiring(); 
		FinishAnim(); 
	} 

	If (bIsSlave) 
	{ 
		If ((Pawn(Owner).bFire!=0) 
			&& AmmoType.AmmoAmount>0) 
			GoTo('Repeater'); 
	} 
	Else If (bChangeWeapon) 
		GoToState('DownWeapon'); 
	Else If ((Pawn(Owner).bFire!=0) 
		&& AmmoType.AmmoAmount>0) 
	{ 
		If (PlayerPawn(Owner) == None) 
			Pawn(Owner).bFire = Int(FRand() < ReFireRate); 
		GoTo('Repeater'); 
	} 
	PlayAnim('Shoot', FWarbringerAnimRate, 0.05); 
	Finish(); 
} 


State AltFiring 
{
	Ignores Fire, AltFire, AnimEnd; 

	Function Timer () 
	{ 
		If (SlaveEnforcer != None) 
			SlaveEnforcer.AltFire(0); 
	} 

	Function EndState () 
	{ 
		Super.EndState(); 
		OldFlashCount = FlashCount; 
	} 

	Begin: 
	If (SlaveEnforcer != None) 
		SetTimer(0.20, False); 
	FinishAnim(); 
	
	Repeater: 
	If (AmmoType.UseAmmo(1)) 
	{ 
		FlashCount++; 
		TraceFire(AltAccuracy); 
		PlayRepeatFiring(); 
		FinishAnim(); 
	}
	If (AltAccuracy < 3) 
		AltAccuracy += 0.5; 
	If (bIsSlave) 
	{ 
		If ((Pawn(Owner).bAltFire!=0) 
			&& AmmoType.AmmoAmount>0) 
			GoTo('Repeater'); 
	} 
	Else If (bChangeWeapon) 
		GoToState('DownWeapon'); 
	Else If ((Pawn(Owner).bAltFire!=0) 
		&& AmmoType.AmmoAmount>0) 
	{ 
		If (PlayerPawn(Owner) == None) 
			Pawn(Owner).bAltFire = Int(FRand() < AltReFireRate); 
		GoTo('Repeater'); 
	} 
	PlayAnim('T2', FWarbringerAnimRate, 0.05); 
	Finish(); 
} 

State ClientAltFiring 
{ 
	Simulated Function Bool ClientFire (Float Value) 
	{ 
		If (bIsSlave) 
			Global.ClientFire(Value); 
		Return False; 
	} 

	Simulated Function Timer() 
	{ 
		If ((SlaveEnforcer != None) && SlaveEnforcer.ClientAltFire(0)) 
			Return; 
		SetTimer(0.5, False); 
	} 

	Simulated Function AnimEnd() 
	{ 
		If (Pawn(Owner) == None) 
			GoToState(''); 
		Else If (Ammotype.AmmoAmount <= 0) 
		{ 
			PlayAnim('T2', FWarbringerAnimRate, 0.05);	
			GoToState(''); 
		} 
		Else If (!bIsSlave && !bCanClientFire) 
			GoToState(''); 
		Else If (bFirstFire || (Pawn(Owner).bAltFire != 0)) 
		{ 
			PlayRepeatFiring(); 
			bFirstFire = False; 
		} 
		Else If (Pawn(Owner).bFire != 0) 
			Global.ClientFire(0); 
		Else 
		{ 
			PlayAnim('T2', FWarbringerAnimRate, 0.05);	
			GoToState(''); 
		} 
	} 

	Simulated Function BeginState() 
	{ 
		Super.BeginState(); 
		If (SlaveEnforcer != None) 
			SetTimer(0.2, False); 
		Else 
			SetTimer(0.5, False); 
	} 

	Simulated Function EndState() 
	{ 
		Super.EndState(); 
		If (SlaveEnforcer != None) 
			SlaveEnforcer.GotoState(''); 
	} 
} 

DefaultProperties 
{ 
	HitDamage=25 
	HeadshotDamage=666 
    DoubleName="Double Warbringers" 
    MuzzleFlashVariations(0)=Texture'Botpack.Skins.Muz1' 
    MuzzleFlashVariations(1)=Texture'Botpack.Skins.Muz2' 
    MuzzleFlashVariations(2)=Texture'Botpack.Skins.Muz3' 
    MuzzleFlashVariations(3)=Texture'Botpack.Skins.Muz4' 
    MuzzleFlashVariations(4)=Texture'Botpack.Skins.Muz5' 
    DoubleSwitchPriority=0 
    WeaponDescription="Classification: Death's custom Enforcer" 
    InstFlash=-0.200000 
    InstFog=(X=325.000000,Y=225.000000,Z=95.000000) 
    AmmoName=Class'Death.WarbringerClip' 
    PickupAmmoCount=666 
    bInstantHit=True 
    bAltInstantHit=True 
    FiringSpeed=1.500000 
    FireOffset=(Y=-10.000000,Z=-4.000000) 
    MyDamageType=Shot 
	AltDamageType=Decapitated 
    Shakemag=200.000000 
    Shakevert=4.000000 
    AIRating=0.250000 
    RefireRate=0.800000 
    AltRefireRate=0.870000 
	FWarbringerAnimRate=6.0 
    FireSound=Sound'Botpack.Enforcer.E_Shot' 
    AltFireSound=Sound'UnrealShare.AutoMag.Shot' 
    CockingSound=Sound'Botpack.Enforcer.Cocking' 
    SelectSound=Sound'Botpack.Enforcer.Cocking' 
    DeathMessage="%o was sent to hell by %k's %w." 
    NameColor=(R=200,G=200) 
    bDrawMuzzleFlash=True 
    MuzzleScale=1.000000 
    FlashY=0.100000 
    FlashO=0.020000 
    FlashC=0.035000 
    FlashLength=0.020000 
    FlashS=128 
    MFTexture=Texture'Botpack.Skins.Muz1' 
    AutoSwitchPriority=0 
    InventoryGroup=2 
    PickupMessage="You picked up a Warbringer." 
    ItemName="Warbringer" 
    PlayerViewOffset=(X=3.300000,Y=-2.000000,Z=-3.000000) 
    PlayerViewMesh=LodMesh'Botpack.AutoML' 
    PickupViewMesh=LodMesh'Botpack.MagPick' 
    ThirdPersonMesh=LodMesh'Botpack.AutoHand' 
    StatusIcon=Texture'Botpack.Icons.UseAutoM' 
    bMuzzleFlashParticles=True 
    MuzzleFlashStyle=STY_Translucent 
    MuzzleFlashMesh=LodMesh'Botpack.MuzzEF3' 
    MuzzleFlashScale=0.080000 
    MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy2' 
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup' 
    Icon=Texture'Botpack.Icons.UseAutoM' 
    bHidden=True 
    Mesh=LodMesh'Botpack.MagPick' 
    bNoSmooth=False 
    CollisionRadius=24.000000 
    CollisionHeight=12.000000 
    Mass=10.000000 
} 