Class GuidedChainsaw Extends GuidedWarShell; 

Var Pawn Guider; 
Var Rotator OldGuiderRotation, GuidedRotation; 
Var Float CurrentTimeStamp, LastUpdateTime,ClientBuffer,ServerUpdate; 
Var Bool bUpdatePosition; 
Var Bool bDestroyed; 
Var SavedMove SavedMoves; 
Var SavedMove FreeMoves; 
Var Vector RealLocation, RealVelocity; 

Simulated Function Timer () 
{ 
	Local ChainsawSpriteSmokePuff B; 
	Local Float SmokeRate; 
	If ((Role == ROLE_Authority) && (Level.TimeSeconds - ServerUpdate > 4)) 
	{ 
		Explode(Location,Vect(0,0,1)); 
		Return; 
	} 
	If (Trail == None) 
		Trail = Spawn(Class'RedeemerTrail',Self); 
	CannonTimer += SmokeRate; 
	If (CannonTimer > 0.6) 
	{ 
		WarnCannons(); 
		CannonTimer -= 0.6; 
	} 
	If (Region.Zone.bWaterZone || (Level.NetMode == NM_DedicatedServer)) 
	{ 
		SetTimer(SmokeRate, False); 
		Return; 
	} 
	If (Level.bHighDetailMode) 
	{ 
		If (Level.bDropDetail) 
			SmokeRate = 0.07; 
		Else 
			SmokeRate = 0.02; 
	} 
	Else 
	{ 
		SmokeRate = 0.15; 
	} 
	B = Spawn(Class'ChainsawSpriteSmokePuff'); 
	B.RemoteRole = ROLE_None; 
	SetTimer(SmokeRate, False); 
} 

Simulated Function Destroyed () 
{ 
	Local WarheadLauncher W; 
	bDestroyed = True; 
	If ((PlayerPawn(Guider) != None)) 
		PlayerPawn(Guider).ViewTarget = None; 
	While (FreeMoves != None) 
	{ 
		FreeMoves.Destroy(); 
		FreeMoves = FreeMoves.NextMove; 
	} 
	While (SavedMoves != None) 
	{ 
		SavedMoves.Destroy(); 
		SavedMoves = SavedMoves.NextMove; 
	} 
	If ((Guider != None) && (Level.NetMode != NM_Client)) 
	{ 
		W = WarheadLauncher(Guider.FindInventoryType(Class'WarheadLauncher'));
		If (W != None) 
		{ 
			W.GuidedShell = None; 
			W.GoToState('Finishing'); 
		} 
	} 
	Super.Destroyed(); 
} 

Simulated Function Tick (Float DeltaTime) 
{ 
	Local Int DeltaYaw, DeltaPitch; 
	Local Int YawDIff, PitchDIff; 
	Local SavedMove NewMove; 
	If (Level.NetMode == NM_Client) 
	{ 
		If ((PlayerPawn(Instigator) != None) && (ViewPort(PlayerPawn(Instigator).Player) != None)) 
		{ 
			Guider = Instigator; 
			If (bDestroyed || (Instigator.health < 0)) 
			{ 
				PlayerPawn(Instigator).ViewTarget = None; 
				Destroy(); 
				If (Instigator.Weapon.IsA('WarheadLauncher')) 
					WarheadLauncher(Instigator.Weapon).bGuiding = False; 
				Return; 
			} 
			PlayerPawn(Instigator).ViewTarget = Self; 
			If (Instigator.Weapon.IsA('WarheadLauncher')) 
			{ 
				WarheadLauncher(Instigator.Weapon).GuidedShell = Self; 
				WarheadLauncher(Instigator.Weapon).bGuiding = True; 
			} 
		} 
		Else 
		{ 
			If (RealLocation != Vect(0,0,0))
			{ 
				SetLocation(RealLocation); 
				RealLocation = Vect(0,0,0); 
			} 
			If ( RealVelocity != Vect(0,0,0) ) 
			{ 
				Velocity = RealVelocity; 
				SetRotation(Rotator(Velocity)); 
				RealVelocity = Vect(0,0,0); 
			} 
			Return; 
		} 
	} 
	Else If ((Level.NetMode != NM_Standalone) && (RemoteRole == ROLE_AutonomousProxy)) 
			Return; 
	If (bUpdatePosition) 
		ClientUpdatePosition(); 
	DeltaYaw = (Guider.ViewRotation.Yaw & 65535) - (OldGuiderRotation.Yaw & 65535); 
	DeltaPitch = (Guider.ViewRotation.Pitch & 65535) - (OldGuiderRotation.Pitch & 65535); 
	If (DeltaPitch < -32768) 
		DeltaPitch += 65536; 
	Else If (DeltaPitch > 32768) 
		DeltaPitch -= 65536; 
	If (DeltaYaw < -32768) 
		DeltaYaw += 65536; 
	Else If (DeltaYaw > 32768) 
		DeltaYaw -= 65536; 
	YawDIff = (Rotation.Yaw & 65535) - (GuidedRotation.Yaw & 65535) - DeltaYaw; 
	If (DeltaYaw < 0) 
	{ 
		If (((YawDIff > 0) && (YawDIff < 16384)) || (YawDIff < -49152)) 
			GuidedRotation.Yaw += DeltaYaw; 
	} 
	Else If (((YawDIff < 0) && (YawDIff > -16384)) || (YawDIff > 49152)) 
		GuidedRotation.Yaw += DeltaYaw; 
	GuidedRotation.Pitch += DeltaPitch; 
	OldGuiderRotation = Guider.ViewRotation; 
	If (Role == ROLE_AutonomousProxy) 
	{ 
		If (ClientBuffer < 0) 
		{ 
			ClientBuffer += DeltaTime; 
			MoveRocket(DeltaTime, Velocity, GuidedRotation); 
			Return; 
		} 
		Else 
			ClientBuffer = ClientBuffer + DeltaTime - 80.0/PlayerPawn(Instigator).Player.CurrentNetSpeed; 
		If (SavedMoves == None) 
		{ 
			SavedMoves = GetFreeMove(); 
			NewMove = SavedMoves; 
		} 
		Else 
		{ 
			NewMove = SavedMoves; 
			While (NewMove.NextMove != None) 
				NewMove = NewMove.NextMove; 
			NewMove.NextMove = GetFreeMove(); 
			NewMove = NewMove.NextMove; 
		} 
		NewMove.TimeStamp = Level.TimeSeconds; 
		NewMove.Delta = DeltaTime; 
		NewMove.Velocity = Velocity; 
		NewMove.SetRotation(GuidedRotation); 
		MoveRocket(DeltaTime, Velocity, GuidedRotation); 
		ServerMove(Level.TimeSeconds, Location, NewMove.Rotation.Pitch, NewMove.Rotation.Yaw); 
		Return; 
	} 
	MoveRocket(DeltaTime, Velocity, GuidedRotation); 
} 

Simulated Function ClientAdjustPosition 
( 
	Float TimeStamp, 
	Float NewLocX, 
	Float NewLocY, 
	Float NewLocZ, 
	Float NewVelX, 
	Float NewVelY, 
	Float NewVelZ 
) 

{ 
	Local Vector NewLocation; 
	If (CurrentTimeStamp > TimeStamp) 
		Return; 
	CurrentTimeStamp = TimeStamp; 
	NewLocation.X = NewLocX; 
	NewLocation.Y = NewLocY; 
	NewLocation.Z = NewLocZ; 
	Velocity.X = NewVelX; 
	Velocity.Y = NewVelY; 
	Velocity.Z = NewVelZ; 
	SetLocation(NewLocation); 
	bUpdatePosition = True; 
} 

Simulated Function ClientUpdatePosition () 
{
	Local SavedMove CurrentMove; 
	Local Int RealbRun, RealbDuck; 
	Local Bool bRealJump; 
	bUpdatePosition = False; 
	CurrentMove = SavedMoves; 
	While (CurrentMove != None) 
	{ 
		If (CurrentMove.TimeStamp <= CurrentTimeStamp) 
		{ 
			SavedMoves = CurrentMove.NextMove; 
			CurrentMove.NextMove = FreeMoves; 
			FreeMoves = CurrentMove; 
			FreeMoves.Clear(); 
			CurrentMove = SavedMoves; 
		} 
		Else 
		{ 
			MoveRocket(CurrentMove.Delta, CurrentMove.Velocity, CurrentMove.Rotation); 
			CurrentMove = CurrentMove.NextMove; 
		} 
	} 
} 

Function ServerMove (Float TimeStamp, Vector ClientLoc, Int Pitch, Int Yaw) 
{ 
	Local Float ClientErr, DeltaTime; 
	Local Vector LocDIff; 
	If (CurrentTimeStamp >= TimeStamp) 
		Return; 
	If (CurrentTimeStamp > 0) 
		DeltaTime = TimeStamp - CurrentTimeStamp; 
	CurrentTimeStamp = TimeStamp; 
	GuidedRotation.Pitch = Pitch; 
	GuidedRotation.Yaw = Yaw; 
	If (DeltaTime > 0) 
		MoveRocket(DeltaTime, Velocity, GuidedRotation); 
	If (Level.TimeSeconds - LastUpdateTime > 0.3) 
	{ 
		ClientErr = 10000; 
	} 
	Else If (Level.TimeSeconds - LastUpdateTime > 0.07) 
	{ 
		LocDIff = Location - ClientLoc; 
		ClientErr = LocDIff Dot LocDIff; 
	} 
	If (ClientErr > 3) 
	{ 
		LastUpdateTime = Level.TimeSeconds; 
		ClientAdjustPosition(TimeStamp, Location.X, Location.Y, Location.Z, Velocity.X, Velocity.Y, Velocity.Z); 
	} 
} 

Simulated Function MoveRocket (Float DeltaTime, Vector CurrentVelocity, Rotator GuideRotation ) 
{ 
	Local Int OldRoll, RollMag; 
	Local Rotator NewRot; 
	Local Float SmoothRoll; 
	Local Vector OldVelocity, X,Y,Z; 
	If ((Role == ROLE_Authority) && ((Guider == None) || (Guider.Health <= 0) || (Guider.IsA('PlayerPawn') && (PlayerPawn(Guider).ViewTarget != Self)) || Guider.IsInState('FeigningDeath'))) 
	{ 
		Explode(Location,Vect(0,0,1)); 
		Return; 
	} 
	ServerUpdate = Level.TimeSeconds; 
	OldRoll = Rotation.Roll & 65535; 
	OldVelocity = CurrentVelocity; 
	Velocity = CurrentVelocity + Vector(GuideRotation) * 1500 * DeltaTime; 
	Velocity = Normal(Velocity) * 550; 
	NewRot = Rotator(Velocity); 
	GetAxes(NewRot, X,Y,Z); 
	RollMag = Int(10 * (Y Dot (Velocity - OldVelocity))/DeltaTime); 
	If (RollMag > 0) 
		NewRot.Roll = Min(12000, RollMag); 
	Else 
		NewRot.Roll = Max(53535, 65536 + RollMag); 
	If (NewRot.Roll > 32768) 
	{ 
		If (OldRoll < 32768) 
			OldRoll += 65536; 
	} 
	Else If (OldRoll > 32768) 
		OldRoll -= 65536; 
	SmoothRoll = FMin(1.0, 5.0 * DeltaTime); 
	NewRot.Roll = NewRot.Roll * SmoothRoll + OldRoll * (1 - SmoothRoll); 
	SetRotation(NewRot); 
	If ((Level.NetMode != NM_Standalone) && ((Level.NetMode != NM_ListenServer) || (Instigator == None) || (Instigator.IsA('PlayerPawn') && (PlayerPawn(Instigator).Player != None) && (ViewPort(PlayerPawn(Instigator).Player) == None)))) 
		AutonomousPhysics(DeltaTime); 
	If (Role == ROLE_Authority) 
	{ 
		RealLocation = Location; 
		RealVelocity = Velocity; 
	} 
} 

Simulated Function PostRender (Canvas Canvas) 
{ 
	Local Float Dist; 
	Local Pawn P; 
	Local Int XPos, YPos; 
	Local Vector X,Y,Z, Dir; 
	GetAxes(Rotation, X,Y,Z); 
	Canvas.Font = Font'TinyRedFont'; 
	If (Level.bHighDetailMode ) 
		Canvas.Style = ERenderStyle.STY_Translucent; 
	Else 
		Canvas.Style = ERenderStyle.STY_Normal; 
	ForEach VisibleCollidingActors(Class'Pawn', P, 2000,, True) 
	{ 
		Dir = P.Location - Location; 
		Dist = VSize(Dir); 
		Dir = Dir/Dist; 
		If ((Dir Dot X) > 0.7) 
		{ 
			XPos = 0.5 * Canvas.ClipX * (1 + 1.4 * (Dir Dot Y)); 
			YPos = 0.5 * Canvas.ClipY * (1 - 1.4 * (Dir Dot Z)); 
			Canvas.SetPos(XPos - 8, YPos - 8); 
			Canvas.DrawIcon(Texture'CrossHair6', 1.0); 
			Canvas.SetPos(Xpos - 12, YPos + 8); 
			Canvas.DrawText(Dist, True); 
		} 
	} 
} 	

Simulated Function SavedMove GetFreeMove () 
{ 
	Local SavedMove S; 
	If (FreeMoves == None) 
		Return Spawn(Class'SavedMove'); 
	Else 
	{ 
		S = FreeMoves; 
		FreeMoves = FreeMoves.NextMove; 
		S.NextMove = None; 
		Return S; 
	} 
} 

Auto State Flying 
{ 
	Function BeginState () 
	{ 
		ServerUpdate = Level.TimeSeconds; 
		GuidedRotation = Rotation; 
		OldGuiderRotation = Rotation; 
		Velocity = Speed*Vector(Rotation); 
		Acceleration = Vect(0,0,0); 
		If ((Level.NetMode != NM_Standalone) && (Role == ROLE_Authority)) 
		{ 
			If ((PlayerPawn(Instigator) != None) && (ViewPort(PlayerPawn(Instigator).Player) != None)) 
				RemoteRole = ROLE_SimulatedProxy; 
			Else 
				RemoteRole = ROLE_AutonomousProxy; 
		} 
	} 
} 

DefaultProperties 
{ 
	Mesh=LodMesh'Botpack.ChainSawPick' 
	AmbientSound=Sound'Botpack.ChainSaw.SawHit' 
    RemoteRole=ROLE_DumbProxy 
    NetPriority=3.000000 
} 