Class DeathMutator Extends Mutator; 

Function AddMutator (Mutator M) 
{ 
    If (M != Self) 
		Super.AddMutator(M); 
} 

Function Bool AlwaysKeep (Actor Other) 
{ 
    If (Other.IsA('Warbringer')) 
		Return True; 
	If (Other.IsA('ChainsawLauncher')) 
		Return True; 
    Return Super.AlwaysKeep(Other); 
} 

Function ModifyPlayer (Pawn Other) 
{ 
    DeathMatchPlus(Level.Game).GiveWeapon(Other, "Death.Warbringer"); 
    Super.ModifyPlayer(Other); 
} 

Function Bool CheckReplacement (Actor Other, Out Byte bSuperRelevant) 
{ 
    If (Other.IsA('Weapon')) 
	{ 
        If (Other.IsA('Enforcer')) 
		{ 
            ReplaceWith (Other, "Death.Warbringer"); 
            Return False; 
        } 
		If (Other.IsA('Warheadlauncher')) 
		{ 
            ReplaceWith (Other, "Death.ChainsawLauncher"); 
            Return False; 
        } 
    } 
    Return True; 
} 