Class ChainsawShockWave Extends ShockWave; 

Var Float OldShockDistance, ShockSize; 
Var Int ICount; 

Simulated Function Tick (Float DeltaTime) 
{ 
	If (Level.NetMode != NM_DedicatedServer) 
	{ 
		ShockSize =  10 * (Default.LifeSpan - LifeSpan) + 2/(LifeSpan/Default.LifeSpan+0.04); 
		ScaleGlow = LifeSpan; 
		AmbientGlow = ScaleGlow * 200; 
		DrawScale = ShockSize; 
	} 
} 

simulated function Timer()
{

	local actor Victims;
	local float damageScale, dist, MoScale;
	local vector dir;

	ShockSize =  13 * (Default.LifeSpan - LifeSpan) + 3.5/(LifeSpan/Default.LifeSpan+0.05);
	if ( Level.NetMode != NM_DedicatedServer )
	{
		if (ICount==4) spawn(class'WarExplosion2',,,Location);
		ICount++;

		if ( Level.NetMode == NM_Client )
		{
			foreach VisibleCollidingActors( class 'Actor', Victims, ShockSize*29, Location )
				if ( Victims.Role == ROLE_Authority )
				{
					dir = Victims.Location - Location;
					dist = FMax(1,VSize(dir));
					dir = dir/dist +vect(0,0,0.3); 
					if ( (dist> OldShockDistance) || (dir dot Victims.Velocity <= 0))
					{
						MoScale = FMax(0, 1100 - 1.1 * Dist);
						Victims.Velocity = Victims.Velocity + dir * (MoScale + 20);	
						Victims.TakeDamage
						(
							MoScale,
							Instigator, 
							Victims.Location - 0.5 * (Victims.CollisionHeight + Victims.CollisionRadius) * dir,
							(1000 * dir),
							'RedeemerDeath'
						);
					}
				}	
			return;
		}
	}

	foreach VisibleCollidingActors( class 'Actor', Victims, ShockSize*29, Location )
	{
		dir = Victims.Location - Location;
		dist = FMax(1,VSize(dir));
		dir = dir/dist + vect(0,0,0.3); 
		if (dist> OldShockDistance || (dir dot Victims.Velocity < 0))
		{
			MoScale = FMax(0, 1100 - 1.1 * Dist);
			if ( Victims.bIsPawn )
				Pawn(Victims).AddVelocity(dir * (MoScale + 20));
			else
				Victims.Velocity = Victims.Velocity + dir * (MoScale + 20);	
			Victims.TakeDamage
			(
				MoScale,
				Instigator, 
				Victims.Location - 0.5 * (Victims.CollisionHeight + Victims.CollisionRadius) * dir,
				(1000 * dir),
				'RedeemerDeath'
			);
		}
	}	
	OldShockDistance = ShockSize*29;	
}

Simulated Function PostBeginPlay () 
{
	local Pawn P;

	if ( Role == ROLE_Authority ) 
	{
		for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			if ( P.IsA('PlayerPawn') && (VSize(P.Location - Location) < 3000) )
				PlayerPawn(P).ShakeView(0.5, 600000.0/VSize(P.Location - Location), 10);

		if ( Instigator != None )
			MakeNoise(10.0);
	}

	SetTimer(0.1, True);

	if ( Level.NetMode != NM_DedicatedServer )
		SpawnEffects();
}

Simulated Function SpawnEffects () 
{ 
	Local WarExplosion W; 
	PlaySound(Sound'Expl03', SLOT_Interface, 16.0); 
	PlaySound(Sound'Expl03', SLOT_None, 16.0); 
	PlaySound(Sound'Expl03', SLOT_Misc, 16.0); 
	PlaySound(Sound'Expl03', SLOT_Talk, 16.0); 
	W = Spawn(Class'WarExplosion',,,Location); 
	W.RemoteRole = ROLE_None; 
} 

DefaultProperties 
{ 
    bAlwaysRelevant=True 
    RemoteRole=ROLE_SimulatedProxy 
    LifeSpan=1.500000 
    DrawType=DT_Mesh 
    Style=STY_Translucent 
    Mesh=LodMesh'Botpack.ShockWaveM' 
    AmbientGlow=200 
    bUnlit=True 
} 
