Class ChainsawLauncher Extends WarheadLauncher; 

Var GuidedChainsaw GuidedShell; 
Var Int Scroll; 
Var PlayerPawn GuidingPawn; 
Var Bool bGuiding, bCanFire, bShowStatic; 
Var Rotator StartRotation; 
Var Int ScrollCounter; 
Var Int ScrollSpeed; 
Var Float FChainsawRate; 

Replication 
{ 
    Reliable If (bNetOwner && (Role==ROLE_Authority)) 
        bGuiding, bShowStatic; 
} 

Function SetWeaponStay () 
{ 
    bWeaponStay = False;
} 

Function Float RateSelf (Out Int bUseAltMode) 
{ 
    Local Pawn P, E; 
    Local Bot O; 
    O = Bot(Owner); 
    If ((O == None) || (AmmoType.AmmoAmount <=0) || (O.Enemy == None)) 
        Return -2; 
    bUseAltMode = 0; 
    E = O.Enemy; 
    For (P=Level.PawnList; P!=None; P=P.NextPawn) 
        If (P.bIsPlayer && (P != O) && (P != E) && (!Level.Game.bTeamGame || (O.PlayerReplicationInfo.Team != P.PlayerReplicationInfo.Team)) && (VSize(E.Location - P.Location) < 650) && (!Level.Game.IsA('TeamGamePlus') || TeamGamePlus(Level.Game).PriorityObjective(O) < 2) && FastTrace(P.Location, E.Location)) 
        { 
            If (VSize(E.Location - O.Location) > 500) 
                Return 2.0; 
            Else 
                Return 1.0; 
        } 
    Return 0.35; 
} 

Function Float SuggestAttackStyle () 
{ 
    Return -1.0; 
} 

Simulated Function PlayFiring () 
{ 
    PlayAnim('Fire', FChainsawRate, 0.3); 
    PlayOwnedSound(FireSound, SLOT_None,4.0*Pawn(Owner).SoundDampening); 
} 

Function SetHand (Float Hand) 
{ 
    If (Hand == 2) 
    { 
        bHideWeapon = True; 
        Return; 
    } 
    Else 
        bHideWeapon = False; 
    PlayerViewOffset.Y = Default.PlayerViewOffset.Y; 
    PlayerViewOffset.X = Default.PlayerViewOffset.X; 
    PlayerViewOffset.Z = Default.PlayerViewOffset.Z; 
    PlayerViewOffset *= 100; 
} 

Function Fire (Float Value) 
{ 
    If ((AmmoType == None) && (AmmoName != None)) 
    { 
        GiveAmmo(Pawn(Owner)); 
    } 
    If (AmmoType.UseAmmo(1)) 
    { 
        GoToState('NormalFire'); 
        bPointing=True; 
        bCanClientFire = True; 
        ClientFire(Value); 
        If (bRapidFire || (FiringSpeed > 0)) 
            Pawn(Owner).PlayRecoil(FiringSpeed); 
        If (bInstantHit) 
            TraceFire(0.0); 
        Else 
			ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget); 
    } 
} 

Function AltFire (Float Value) 
{ 
    If (!Owner.IsA('PlayerPawn')) 
    { 
        Fire(Value); 
        Return; 
    } 
    If (AmmoType.UseAmmo(1)) 
    { 
        PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert); 
        bPointing=True; 
        Pawn(Owner).PlayRecoil(FiringSpeed); 
        PlayFiring(); 
        GuidedShell = GuidedChainsaw(ProjectileFire(AltProjectileClass, ProjectileSpeed, bWarnTarget)); 
        GuidedShell.SetOwner(Owner); 
        PlayerPawn(Owner).ViewTarget = GuidedShell; 
        GuidedShell.Guider = PlayerPawn(Owner); 
        ClientAltFire(0); 
        GoToState('Guiding'); 
    } 
} 

Simulated Function Bool ClientAltFire (Float Value) 
{ 
    If (bCanClientFire && ((Role == ROLE_Authority) || (AmmoType == None) || (AmmoType.AmmoAmount > 0))) 
    { 
        If (Affector != None) 
            Affector.FireEffect(); 
        PlayOwnedSound(FireSound, SLOT_None,4.0*Pawn(Owner).SoundDampening); 
        Return True; 
    } 
    Return False; 
} 

State Guiding 
{ 
    Function Fire (Float Value) 
    { 
        If (!bCanFire) 
            Return; 
        If (GuidedShell != None) 
            GuidedShell.Explode(GuidedShell.Location,Vect(0,0,1)); 
        bCanClientFire = True; 
        GoToState('Finishing'); 
    } 

    Function AltFire (Float Value) 
    { 
        Fire(Value); 
    } 

    Function BeginState () 
    { 
        Scroll = 0; 
        bGuiding = True; 
        bCanFire = False; 
        If (Owner.IsA('PlayerPawn')) 
        { 
            GuidingPawn = PlayerPawn(Owner); 
            StartRotation = PlayerPawn(Owner).ViewRotation; 
            PlayerPawn(Owner).ClientAdjustGlow(-0.2,Vect(200,0,0)); 
        } 
    } 

    Function EndState () 
    { 
        bGuiding = False; 
        If (GuidingPawn != None) 
        { 
            GuidingPawn.ClientAdjustGlow(0.2,Vect(-200,0,0)); 
            GuidingPawn.ClientSetRotation(StartRotation); 
            GuidingPawn = None; 
        } 
    } 

	Begin: 
		Sleep(1.0); 
		bCanFire = True; 
} 

State Finishing 
{ 
    Ignores Fire, AltFire; 
    Function BeginState () 
    { 
        bShowStatic = True; 
    } 

	Begin: 
		Sleep(0.3); 
		bShowStatic = False; 
		Sleep(1.0); 
		GotoState('Idle'); 
} 

DefaultProperties
{
    InstFlash=-0.4 
    InstFog=(X=950.00000,Y=650.00000,Z=290.00000) 
    AmmoName=Class'Death.ChainsawRocket' 
    ReloadCount=01 
    PickupAmmoCount=10 
    bWarnTarget=True 
    bAltWarnTarget=True 
    bSplashDamage=True 
    FireOffset=(X=18.000000,Z=-10.000000) 
    ProjectileClass=Class'Death.Chainsaw' 
    AltProjectileClass=Class'Death.GuidedChainsaw' 
    Shakemag=350.000000 
    Shaketime=0.200000 
    Shakevert=7.500000 
    AIRating=1.000000 
    RefireRate=0.250000 
    AltRefireRate=0.250000 
    FiringSpeed=1.0 
	FChainsawRate=0.5 
    AutoSwitchPriority=10 
    InventoryGroup=10 
    PickupMessage="You got the Chainsaw Launcher." 
    ItemName="Chainsaw Launcher" 
    RespawnTime=60.000000 
    PlayerViewOffset=(X=1.800000,Y=1.000000,Z=-1.890000) 
    PlayerViewMesh=Mesh'BotPack.WarHead' 
    BobDamping=0.975000 
    PickupViewMesh=Mesh'BotPack.WHPick' 
    ThirdPersonMesh=Mesh'BotPack.WHHand' 
    Mesh=Mesh'BotPack.WHPick' 
    bNoSmooth=False 
    bMeshCurvy=False 
    CollisionRadius=45.000000 
    CollisionHeight=23.000000 
    DeathMessage="%o was destroyed by %k's %w!!" 
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup' 
    SelectSound=Sound'WarheadPickupA' 
    FireSound=Sound'Botpack.Redeemer.WarheadShot' 
    Icon=Texture'Botpack.UseWarH' 
    StatusIcon=Texture'Botpack.UseWarH' 
    WeaponDescription="Classification: Death's custom Redeemer."
    NameColor=(G=128,B=128) 
}