Class Chainsaw Extends Projectile; 

Var Float CannonTimer, SmokeRate; 
Var RedeemerTrail Trail; 

Simulated Function Timer () 
{ 
    Local ChainsawSpriteSmokePuff B; 
    If (Trail == None) 
		Trail = Spawn(Class'RedeemerTrail',Self); 
    CannonTimer += SmokeRate; 
    If (CannonTimer > 0.6) 
    { 
        WarnCannons(); 
        CannonTimer -= 0.6; 
    } 
    If (Region.Zone.bWaterZone || (Level.NetMode == NM_DedicatedServer)) 
    { 
        SetTimer(SmokeRate, False); 
        Return; 
    } 
    If (Level.bHighDetailMode) 
    { 
        If (Level.bDropDetail) 
            Spawn(Class'LightSmokeTrail'); 
        Else 
            Spawn(Class'ChainsawSmokeTrail'); 
        SmokeRate = 152/Speed;  
    } 
    Else 
    { 
        SmokeRate = 0.15; 
        B = Spawn(Class'ChainsawSpriteSmokePuff'); 
        B.RemoteRole = ROLE_None; 
    } 
    SetTimer(SmokeRate, False); 
} 

Simulated Function Destroyed () 
{ 
	If (Trail != None) 
		Trail.Destroy(); 
	Super.Destroyed(); 
} 

Simulated Function PostBeginPlay () 
{ 
    SmokeRate = 0.3; 
    SetTimer(0.3,False); 
} 

Function WarnCannons () 
{ 
    Local Pawn P; 
    For (P=Level.Pawnlist; P!=None; P=P.NextPawn) 
        If (P.IsA('TeamCannon') && !P.IsInState('TrackWarhead') && P.LineOfSightTo(Self)) 
        { 
            P.Target = Self; 
            P.GoToState('TrackWarhead'); 
        } 
} 

Singular Function TakeDamage (Int NDamage, Pawn InstigatedBy, Vector HitLocation, Vector Momentum, Name DamageType) 
{ 
    If (NDamage > 5) 
    { 
        PlaySound(Sound'Expl03',,6.0); 
        Spawn(class'WarExplosion',,,Location); 
        HurtRadius(Damage,100.0, MyDamageType, MomentumTransfer, HitLocation ); 
        RemoteRole = ROLE_SimulatedProxy;             
        Destroy(); 
    } 
} 

Auto State Flying 
{ 
    Simulated Function ZoneChange (ZoneInfo NewZone) 
    { 
        Local Waterring W; 
        If (NewZone.bWaterZone != Region.Zone.bWaterZone) 
        { 
            W = Spawn(Class'WaterRing',,,,Rot(16384,0,0)); 
            W.DrawScale = 0.2; 
            W.RemoteRole = ROLE_None;  
        } 
    } 

    Function ProcessTouch (Actor Other, Vector HitLocation) 
    { 
        If (Other != Instigator) 
			Explode(HitLocation,Normal(HitLocation-Other.Location)); 
    } 

    Function Explode (Vector HitLocation, Vector HitNormal) 
    { 
		If (Role < ROLE_Authority) 
			Return; 
		HurtRadius(Damage,100.0, MyDamageType, MomentumTransfer, HitLocation); 
		Spawn(Class'ShockWave',,,HitLocation+ HitNormal*10); 
		RemoteRole = ROLE_SimulatedProxy;              
		Destroy(); 
    } 

    Function BeginState () 
    { 
        Local Vector InitialDir; 
        InitialDir = Vector(Rotation); 
        If (Role == ROLE_Authority) 
			Velocity = Speed*InitialDir; 
		Acceleration = InitialDir*50; 
    } 
} 

Simulated Function HitWall (Vector HitNormal, Actor Wall) 
{ 
    If (Role == ROLE_Authority) 
    { 
        If ((Mover(Wall) != None) && Mover(Wall).bDamageTriggered) 
            Wall.TakeDamage(Damage, instigator, Location, MomentumTransfer * Normal(Velocity),''); 
        MakeNoise(1.0); 
    } 
    Explode(Location + ExploWallOut * HitNormal, HitNormal); 
    If ((ExplosionDecal != None) && (Level.NetMode != NM_DedicatedServer)) 
       Spawn(ExplosionDecal,Self,,Location, Rotator(HitNormal)); 
       ExplosionDecal = None; 
} 

DefaultProperties 
{ 
    ExplosionDecal=Class'Botpack.NuclearMark' 
    DrawScale=1.00000 
    Speed=1000.000000 
    Damage=100.000000 
    MomentumTransfer=500 
    MyDamageType=RedeemerDeath 
    bNetTemporary=False 
    RemoteRole=ROLE_SimulatedProxy 
    Mesh=LodMesh'Botpack.ChainSawPick' 
    AmbientGlow=78 
    bUnlit=True 
    SoundRadius=100 
    SoundVolume=255 
    AmbientSound=Sound'Botpack.ChainSaw.SawHit' 
    CollisionRadius=15.000000 
    CollisionHeight=8.000000 
    bProjTarget=True 
    bFixedRotationDir=True 
    RotationRate=(Pitch=0,Yaw=0,Roll=20000), 
} 