/*
No move = no kill
Copyright (C) 2011 n0nexe
*/
class NMNK extends Mutator config(NoMoveNoKill);

var config float time;
var config float minDistance;
var float endCamping;

var float oldMinDistance;
var float oldtime;

var bool init;

var struct Tracking
{
	var Pawn p;
	var struct DataPoint
	{
		var vector location;
		var bool bWater;
	} DPoints[12];

	var byte index;
	var byte cycle;
	var bool bCampingState;
	var int	 stateCounter;
} Players[32];

function PostBeginPlay()
{
	if(init)
		return;
		
	init = True;
	SetTimer(time / 12, True);
	
	oldMinDistance = minDistance;
	oldtime = time;
	
	endCamping = minDistance - minDistance / 4;
}

function int GetIndex(Pawn _p)
{
	local int i, e;
	
	e = -1;
	
	for(i = 0;i < 32;i++)
	{
		if(_p == Players[i].p)
			return i;
		else if(e == -1 && Players[i].p == None)
			e = i;
	}
	
	//init
	Players[e].p = _p;
	ResetLocations(e, _p.Location);
	
	return e;
}

function Timer()
{
	local Pawn p;
	local PlayerPawn pp;
	local Warheadlauncher whl;
	local int index, v_index;

	if(Level.Game.bGameEnded)
	{
		SetTimer(0.0, False);
		return;
	}
		
	//react on changes
	if(oldMinDistance != minDistance)
	{
		oldMinDistance = minDistance;
		endCamping = minDistance - minDistance / 4;
	}
	
	if(oldtime != time)
	{
		oldtime = time;
		SetTimer(time / 12, True);
	}
		
	for(p = Level.PawnList; p != None; p = p.NextPawn)
	{
		pp = PlayerPawn(p);
		//typing or spec-> skip this data point
		if(!p.bIsPlayer || 
		p.bHidden ||
		p.PlayerReplicationInfo.bWaitingPlayer ||
		(pp != None && pp.bIsTyping))
			continue;
			
		//ignore if guiding a redeemer
		whl = WarHeadLauncher(p.FindInventoryType(class'WarHeadLauncher'));
		if(whl != None && whl.bGuiding)
		{
			if(p.DamageScaling == 0)
			{
				ResetDamageScaling(pp, p);
				index = GetIndex(p);
				Players[index].bCampingState = False;
			}
			continue;
		}
		
		//find
		index = GetIndex(p);
		v_index = Players[index].cycle + 3 * Players[index].index;
		
		//add data
		Players[index].DPoints[v_index].location = p.Location;
		Players[index].DPoints[v_index].bWater = p.FootRegion.Zone.bWaterZone;
			
		//not camping
		if(!Players[index].bCampingState)
		{
			//still showing good movements
			if(GoodDistance(index, Players[index].cycle, Players[index].cycle + 9, minDistance) ||
				GoodDistance(index, Players[index].cycle, Players[index].cycle + 6, minDistance) ||
				GoodDistance(index, Players[index].cycle, Players[index].cycle + 3, minDistance) ||
				GoodDistance(index, Players[index].cycle + 3, Players[index].cycle + 9, minDistance) ||
				GoodDistance(index, Players[index].cycle + 3, Players[index].cycle + 6, minDistance) ||
				GoodDistance(index, Players[index].cycle + 6, Players[index].cycle + 9, minDistance))
			{
				Players[index].stateCounter = Min(0, Players[index].stateCounter + 1);
			}
			else //didn't move enough -> camper
			{
				Players[index].stateCounter = Max(-6, Players[index].stateCounter - 2);
				
				if(Players[index].stateCounter == -6)//reached lower limit _> now this is camping
				{
					Players[index].bCampingState = True;
					if(pp != None)
					{
						p.DamageScaling = 0;
						p.ReceiveLocalizedMessage(class'CamperMessage', 0);
					}
					else //bots -> move
						p.CombatStyle = 1; //Bot(p).CampingRate = 0.0;
				}
			}
		}
		else //seen as a camper
		{
			if(DoesFinishCamping(index))//just moved enough to end camping?
			{
				Players[index].stateCounter = Min(0, Players[index].stateCounter + 2);
			
				if(Players[index].stateCounter == 0)//reached neutral state again
				{
					Players[index].bCampingState = False;
					ResetDamageScaling(pp, p);
				}
			}
			else
				Players[index].stateCounter = Max(-6, Players[index].stateCounter - 2);
		}
		
		//increment
		Players[index].cycle ++;
		if(Players[index].cycle == 3)
		{
			Players[index].cycle = 0;
			
			Players[index].index ++;
			if(Players[index].index == 4)
				Players[index].index = 0;
		}
	}
}

function bool DoesFinishCamping(int index)
{
	switch(Players[index].index)
	{
		case 0://32
			return GoodDistance(index, Players[index].cycle + 9, Players[index].cycle + 6, endCamping);
		case 1://03
			return GoodDistance(index, Players[index].cycle, Players[index].cycle + 9, endCamping);
		case 2://10
			return GoodDistance(index, Players[index].cycle + 3, Players[index].cycle, endCamping);
		case 3://21
			return GoodDistance(index, Players[index].cycle + 6, Players[index].cycle + 3, endCamping);
	}
	return False;
}

function ResetDamageScaling(PlayerPawn pp, Pawn p)
{
	local Inventory inv;
	
	inv = p.FindInventoryType(class'UDamage');
	if(inv != None)
	{
		p.DamageScaling = 3;
		if(pp != None)
			p.ReceiveLocalizedMessage(class'CamperMessage', 2);
	}
	else
	{
		p.DamageScaling = p.default.DamageScaling;
		if(pp != None)
			p.ReceiveLocalizedMessage(class'CamperMessage', 1);
	}
}

function ModifyPlayer(Pawn Other)
{
if(NextMutator != None)
	NextMutator.ModifyPlayer(Other);

	ResetLocations(GetIndex(Other), Other.Location);
	Other.ReceiveLocalizedMessage(class'CamperMessage', 5);
}


//init a new or spawning player
function ResetLocations(int index, vector startLocation)
{
	Players[index].DPoints[0].location = startLocation;
	Players[index].DPoints[0].bWater = False;
	Players[index].DPoints[3].location = startLocation;
	Players[index].DPoints[3].bWater = False;
	Players[index].DPoints[6].location = startLocation;
	Players[index].DPoints[6].bWater = False;
	Players[index].DPoints[9].location = startLocation;
	Players[index].DPoints[9].bWater = False;
	
	Players[index].DPoints[9].location.z += minDistance + 1;
	
	Players[index].DPoints[1].location = startLocation;
	Players[index].DPoints[1].bWater = False;
	Players[index].DPoints[4].location = startLocation;
	Players[index].DPoints[4].bWater = False;
	Players[index].DPoints[7].location = startLocation;
	Players[index].DPoints[7].bWater = False;
	Players[index].DPoints[10].location = startLocation;
	Players[index].DPoints[10].bWater = False;
	
	Players[index].DPoints[10].location.z += minDistance + 1;
	
	Players[index].DPoints[2].location = startLocation;
	Players[index].DPoints[2].bWater = False;
	Players[index].DPoints[5].location = startLocation;
	Players[index].DPoints[5].bWater = False;
	Players[index].DPoints[8].location = startLocation;
	Players[index].DPoints[8].bWater = False;
	Players[index].DPoints[11].location = startLocation;
	Players[index].DPoints[11].bWater = False;
	
	Players[index].DPoints[11].location.z += minDistance + 1;
	Players[index].index = 1;
	Players[index].cycle = 0;
	Players[index].bCampingState = False;
	Players[index].stateCounter = 0;
	
}

//now can consider slower speed in water 
function bool GoodDistance(int index, int v1, int v2, int limit)
{
	if(Players[index].DPoints[v1].bWater || Players[index].DPoints[v2].bWater)
		return VSize(Players[index].DPoints[v1].location - Players[index].DPoints[v2].location)*2 > limit;
	else
		return VSize(Players[index].DPoints[v1].location - Players[index].DPoints[v2].location) > limit;
}


defaultproperties
{
    time=6
    minDistance=275
}
