/*
CamperMessage
*/

class CamperMessage extends LocalMessagePlus;


static function string GetString(
    optional int Switch,
    optional PlayerReplicationInfo RelatedPRI_1, 
    optional PlayerReplicationInfo RelatedPRI_2,
    optional Object OptionalObject
    )
{
    switch(Switch)
	{
		case 0:
			return "**Camping -> 0 damage**";
		case 1:
			return "**Your camping ended -> normal damage**";
		case 2:
			return "**Your camping ended -> amped again**";
		case 3:
			return "";
	}
}

static function color GetColor(
	optional int Switch,
	optional PlayerReplicationInfo RelatedPRI_1, 
	optional PlayerReplicationInfo RelatedPRI_2
	)
{
	switch(Switch)
	{
		case 0:
			return class'DeathMessagePlus'.Default.DrawColor;
		case 1:
		case 3:
			return Default.GreenColor;
		case 2:
			return Default.DrawColor;
	}
}

static function ClientReceive( 
	PlayerPawn P,
	optional int Switch,
	optional PlayerReplicationInfo RelatedPRI_1, 
	optional PlayerReplicationInfo RelatedPRI_2,
	optional Object OptionalObject
	)
{
if(Switch == 0)
	Default.LifeTime = 12;
else
	Default.LifeTime = 2;

Super.ClientReceive(P, Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
}



defaultproperties
{
    bIsSpecial=True
    bIsUnique=True
    Lifetime=10
	FontSize=1
    DrawColor=(R=150,G=0,B=150,A=0)
    YPos=128.00
    bCenter=True
}
