//========================================================
// Berserk Monsters Mutator by Mr.Loathsome. - v1.1
//========================================================
class BM expands Mutator config(BerserkMonsters);

var() config float InsanityRate;
var() config int MaxChecks;
var() config bool bAdjustBosses;
var() config bool bAttackKin;
var() config bool bDebug;
var() config string ExcludeClass;
var class<Actor> exClass;

var int HateRadius;

function PostBeginPlay()
{

	exClass = class<Actor>(DynamicLoadObject(ExcludeClass, class'Class'));
	HateRadius = 500;
	log("BerserkMonsters Init --> InsanityRate: "$InsanityRate$"  MaxChecks: "$MaxChecks$"  bAdjustBosses: "$bAdjustBosses$"  bAttackKin: "$bAttackKin$"  bDebug: "$bDebug$"  ExcludeClass: "$ExcludeClass);
	SetTimer(InsanityRate, True);
	Super.PostBeginPlay();
}

function Timer()
{
   local ScriptedPawn SP, aVictim;
   local int NumMonsters, NumChecked, NumAdjusted;

	NumMonsters = 0; NumChecked = 0; NumAdjusted = 0;
	foreach AllActors(class'ScriptedPawn', SP)
	{
	if ((SP.Health > 10) && (!ClassIsChildOf(SP.class, exClass)))
	  {
		NumMonsters++;
		if ((!bAdjustBosses) && (SP.bIsBoss))
		{
			if (bDebug) { log("No boss adjusting... -- "$SP); }
		}
		else
		{
			if (SP.Enemy == None)
			{
				NumChecked++;
				foreach RadiusActors(class'ScriptedPawn', aVictim, HateRadius, SP.Location)
				{
					if ((aVictim.class == SP.class) && (!bAttackKin))
					{  } // skip this victim
					else
					{
						if ((aVictim != SP) && (aVictim.Health > 10))
						{
							if (bDebug) { log("BerserkMonsters --> SP: "$SP$"  SP.Health: "$SP.Health$"  aVictim: "$aVictim$"  aVictim.Health: "$aVictim.Health); }
							SP.bHateWhenTriggered=True;
							SP.Intelligence=BRAINS_Human;
							SP.bCanStrafe = True;
							SP.CombatStyle = FMin((FRand()+0.250), 1.0);
							SP.Hated = aVictim;   
							if (SP.SetEnemy(aVictim))
							{
								SP.gotostate('Attacking');
								NumAdjusted++;
							}
							break;
						}
					}
	 			}
				if ((bDebug) && (SP.Enemy == None))
				{ log("BerserkMonsters --> SP: "$SP$"  SP.Health: "$SP.Health$"  No victim in range...."); }
			}
			if (NumMonsters >= MaxChecks) { break; }
		}
	  }
	}

	if (NumChecked > 1)
	{
		if (NumAdjusted < (NumChecked*0.5))
			{ if (HateRadius < 8000) { HateRadius += (((NumChecked-NumAdjusted)) * 50); } }
		else
			{ if (HateRadius > (((NumChecked-NumAdjusted)+1) * 50) + 100) { HateRadius -= (((NumChecked-NumAdjusted)+1) * 50); } }
	}

	if (bDebug)
	{
		BroadcastMessage("BerserkMonsters --> Monster Count: "$NumMonsters@"  Number Checked: "$NumChecked@"  Number Adjusted: "$NumAdjusted@"  Current HateRadius: "$HateRadius);
		log("BerserkMonsters --> Monster Count: "$NumMonsters@"  Number Checked: "$NumChecked@"  Number Adjusted: "$NumAdjusted@"  Current HateRadius: "$HateRadius);
	}
}

defaultproperties
{
     InsanityRate=30.0
     MaxChecks=200
     bAdjustBosses=False
     bAttackKin=True
     bDebug=False
     ExcludeClass=
}
