
class BalanceGame extends Mutator config(BalanceGame);

//By default variables are initializated False
var bool preInit; 
var bool firstSpawn;
//==========================
var config float time[4];
var config float DELAY;
var config float MAX_PENDING;
var int activeReward;
var bool bRewardAll;
var bool bRewardAllWeaks;
var bool bDelayReward;
//==========================
var int pendingReceivers[16];//give reward if player wasn't spawned at time of reward being spread
var float maxPendingSeconds;
//==========================
struct PS
{
	var Pawn	p;
	var float	s;
	var int 	t;
	var bool	r;
};
var PS playerList[16];
//==========================
var int	zeroSpree[16];
var int zeroSpreeIndex;
//==========================
var PathNode PN[200];
var int pn_count;
var int placedOn[5];
//==========================
var DeathMatchPlus dmp;


function PreBeginPlay()
{
	local int i;
	local NavigationPoint np;
	
	// dont do twice
	if (preInit)
		return;
	preInit = True;

	Super.PreBeginPlay(); // Run the super class function (Mutator.PreBeginPlay). 
	
	dmp = DeathMatchPlus(Level.Game);

	if(Level.Game.MaxPlayers > 16)
	{
		Log("BalanceGame v0.36 supports up to 16 players - not "$Level.Game.MaxPlayers);
		Self.Destroy();
		return;
	}
	
	Log("================================");
	Log("BalanceGame v0.36 mutator loaded.");    // Write our log message
	Log("================================");
	
	for(i = 0;i<16;i++)
		zeroSpree[i] = -1;
		
	for(np = Level.NavigationPointList; np != None ; np = np.nextNavigationPoint)
	{
		if(np.class == class'PathNode')
		{
			PN[pn_count++] = PathNode(np);
			Log(np.name);
			if(pn_count == 200)//enough
				break;
		}
	}
}


//==========================
function Timer()
{
local Pawn Other;
local int i;

if(Level.Game.bGameEnded)
	return;

if(!bDelayReward)//decide next reward
{	
	NewReward();
		
	if(!bRewardAll)
	{
		//bRewardAll = True;
		if(!RewardWeaks())//failed to determine appropriatly weak player
		{
			//if(!bRewardAll)//next is not a reward-to-all -> we skip next weak reward and move to rewarding all!
			//{
			
			//make sure
			bRewardAll = True;
			bRewardAllWeaks = True;
			
			//}
			
			Timer();//instantly move to reward-to-all
		}
		else
			SetTimer(time[Rand(4)], False);
	}
	else
	{
		if(dmp == None || (Level.Game.NumPlayers + dmp.NumBots) > 1)//once reaching this we move away only if there is more than one player @todo += DM+(Level.Game).NumBots -> one cast
			bRewardAll = False;
		
		switch(activeReward)
		{
			case 0:
				AnnounceRewardToAll();
				break;
			case 1:
				SpreadPickups();
				SetTimer(time[Rand(4)], False);
				break;
			case 2:
				AnnounceRewardToAll();
				break;
		}
	}
}
else //give the reward as the delay is passed now
{
	bDelayReward = False;
	i = 0;

	//reward now:
	Self.BroadcastMessage("AND ACTION", True, 'CriticalEvent');
	
	for(Other=Level.PawnList; Other!=None; Other=Other.NextPawn)
	{
		if(Other.bIsPlayer && !Other.PlayerReplicationInfo.bIsSpectator && !Other.PlayerReplicationInfo.bWaitingPlayer)
		{
			//if player respawns within 5 seconds gametime he/she gets it too
			if(Other.bHidden || Other.Health <= 0)
			{
				Log(Other.PlayerReplicationInfo.PlayerName $ " = pending reward " $ Other.PlayerReplicationInfo.PlayerID);
				pendingReceivers[i++] = Other.PlayerReplicationInfo.PlayerID;
			}
			else
				GiveReward(Other);
		}
	}
	if(i != 0)
		maxPendingSeconds = Level.TimeSeconds + MAX_PENDING;//dead players: get reward at respawn within MAX_PENDING seconds
	
	//now keep the rewarding-cycle up
	SetTimer(time[Rand(4)] - DELAY, False);
}
}

//==========================
function bool PreventDeath(Pawn Killed, Pawn Killer, name damageType, vector HitLocation)
{
	//remember players that died without doing one kill
	if(Killed.bIsPlayer && Killed.Spree == 0 && Killer != None && Killer != Killed)	
	{
		if(zeroSpreeIndex < 15)
			zeroSpree[zeroSpreeIndex++] = Killed.PlayerReplicationInfo.PlayerID;
		else
		{
			zeroSpree[15] = Killed.PlayerReplicationInfo.PlayerID;
			zeroSpreeIndex = 0;
		}
	}
	
    if ( NextMutator != None )
        return NextMutator.PreventDeath(Killed, Killer, damageType, HitLocation);
    return False;
}

//==========================
function GiveReward(Pawn Other)
{
	local TournamentPlayer tp;
	
	tp = TournamentPlayer(Other);
	if(tp != None && activeReward > 4)
		tp.ClientPlaySound(Sound'Botpack.CTF.CaptureSound', True);//??? true, true works online
	

	switch(activeReward)
	{
		case 0:
			RewardRedeemer(Other, 1);
			break;
		case 2:
			RewardAmplifier(Other);
			break;
		//==========================
		case 5://Cat. I
		case 11:
			RewardRedeemer(Other, 1);
			break;
		case 6://Cat. II
			Other.Health = Max(Other.Health, 300);
			break;
		case 7://Cat. III
			RewardRedeemer(Other, 2);
			break;
		case 8://Cat. IV
			RewardAmplifier(Other);
			RewardRedeemer(Other, 1);
			Other.Health = Max(Other.Health, 200);
			break;
		case 9://Cat. V
			RewardAmplifier(Other);
			RewardRedeemer(Other, 2);
			Other.Health = Max(Other.Health, 600);
			break;
	}
}

//==========================
function NewReward()
{
	local int i;
	Log("///////////////////////");
	//can't get old & pending rewards anymore
	for(i = 0;i<16;i++)
		pendingReceivers[i] = -1;
		
	if(bRewardAll)//to all -> choose random one
		activeReward = Rand(3);
}


//==========================
function ModifyPlayer(Pawn Other)
{
	local int i, ID;
	
	if ( NextMutator != None )
		NextMutator.ModifyPlayer(Other);
		
	if(!firstSpawn && !Other.PlayerReplicationInfo.bWaitingPlayer)
	{
		Log("firstSpawn starts timer");
		firstSpawn = True;
		SetTimer(time[Rand(4)], False);
	}
	
	ID = Other.PlayerReplicationInfo.PlayerID;
	//I: zeroSpree bonus
	for(i = 0;i<16;i++)
	{
		if(zeroSpree[i] == ID)
		{
			zeroSpree[i] = -1;
			Other.Health = 150;
		}
	}
	
	//II: receive pending reward
	if(Level.TimeSeconds < maxPendingSeconds)
	{
		for(i = 0;i<16;i++)
		{
			if(pendingReceivers[i] != -1 && 
				(ID == pendingReceivers[i]))
			{
				pendingReceivers[i] = -1;
				GiveReward(Other);
				break;
			}
		}
	}
}


//==========================
function RewardAmplifier(Pawn Player){
	
	local UDamage damage;
	local Inventory inv;
	local TournamentPlayer tp;

	Log("rewardAmp " $ Player.PlayerReplicationInfo.PlayerName);
	
	if(Player.FindInventoryType(class'RelicStrengthInventory') != None) 
		return;
		
	//renew old one
	inv = Player.FindInventoryType(class'UDamage');
	if(inv != None)
		inv.Destroy();
	
	damage = spawn(class'UDamage',Player,,Player.Location);
	
	if( damage != None )
	{
		damage.RespawnTime = 0.0;
//		damage.bHeldItem = True;
		damage.GiveTo(Player);
		damage.Activate();
		//Player.DamageScaling = 3.0;
	}
	
	tp = TournamentPlayer(Player);
	if(tp != None)
		tp.ClientPlaySound(class'UDamage'.Default.PickupSound, True);

}

//==========================
function RewardRedeemer(Pawn Player, int ammo)
{
	local WarHeadLauncher redeemer;
	local Inventory inv;
	local TournamentPlayer tp;
		
	Log("rewarddeemer " $ Player.PlayerReplicationInfo.PlayerName $ " / " $ ammo);
	
	inv = Player.FindInventoryType(class'WarHeadLauncher');
	
	if(inv != None)
	{
		redeemer = WarHeadLauncher(inv);

		if(redeemer.AmmoType != None)
			redeemer.AmmoType.AmmoAmount = Min(ammo + redeemer.AmmoType.AmmoAmount, redeemer.AmmoType.MaxAmmo);
		else
		{
			redeemer.GiveAmmo(Player);
			redeemer.AmmoType.AmmoAmount = ammo;
		}
				
		Player.PendingWeapon = redeemer;
		Player.Weapon.PutDown();
	}
	else
	{
		redeemer = spawn(class'WarHeadLauncher',Player,,Player.Location);

		if(redeemer != None)
		{
			redeemer.RespawnTime = 0.0;
			redeemer.GiveAmmo(Player);
			redeemer.AmmoType.AmmoAmount = ammo;
			
			redeemer.GiveTo(Player);
			redeemer.bHeldItem = True;
			//redeemer.WeaponSet(Player);
							
			Player.PendingWeapon = redeemer;
			Player.Weapon.PutDown();
		}
	}
}


//==========================
//RewardWeaks - determines 1 player (playing >= 70 gameseconds) deserving a balancing reward or reward all weaker players; returns if this was possible
function bool RewardWeaks()
{
	local Pawn Other;
	local int index, i, j, max;
	local float helper, avg;
	local PS tempPS;
	local bool found;
	
	Log("RewardWeaks all?" $ bRewardAllWeaks);
	
	//judge all players
	for(Other=Level.PawnList; Other!=None; Other=Other.NextPawn)
	{
		if(Other.bIsPlayer && !Other.PlayerReplicationInfo.bIsSpectator && !Other.PlayerReplicationInfo.bWaitingPlayer)
		{
			playerList[index].p = Other;
			playerList[index].s = 0.0;
			playerList[index].t = Level.TimeSeconds - Other.PlayerReplicationInfo.StartTime;
			playerList[index].r = False;
			
			if(!bRewardAllWeaks && playerList[index].t < 70)
				continue;//ignore fresh players -> want the weakest of those playing some time
			
			if(Other.KillCount != 0 && playerList[index].t > 0)
			{
				if(bRewardAllWeaks && playerList[index].t < 70)
				{
					helper = Lerp(playerList[index].t / 70, 0.25, 0);
					helper = helper + (1 - helper) * Other.KillCount * Other.KillCount / ((Other.KillCount + Other.DieCount)*(Other.KillCount + Other.DieCount));
					
					playerList[index].s = helper * Other.KillCount * Lerp(playerList[index].t / 70, 0.5, 1) / (playerList[index].t ** 0.8);
				}
				else
					playerList[index].s =  Other.KillCount * Other.KillCount * Other.KillCount / ((Other.KillCount + Other.DieCount) * (Other.KillCount + Other.DieCount) * (playerList[index].t ** 0.8));
					
				avg += playerList[index].s;
			}
			
			Log(Other.PlayerReplicationInfo.PlayerName $ ": 	" $ Other.KillCount $ " k,d " $ Other.DieCount $ " -> " $ playerList[index].s $ " t= " $ playerList[index].t);
			
			index ++;
		}
	}
	
	if(index < 2 || avg == 0.0)//at least 2 players on the list and some action happened
	{
		//stupid setup or sleeping players or many new players
		if(!bRewardAllWeaks)
			bRewardAll = True;
		bRewardAllWeaks = !bRewardAllWeaks;
		return False;
	}
	
	avg /= index;
	Log("avg = " $ avg);
	//==========================		
	//sort
	
	for ( i=0; i<index-1; i++ )
    {
        max = i;
        for ( j=i+1; j<index; j++ )
        {
            if(playerList[j].s > playerList[max].s)
                max = j;
        }
	
        tempPS = playerList[max];
        playerList[max] = playerList[i];
        playerList[i] = tempPS;
    }
	
	Log("======================-");
	for(i = 0;i<index;i++)
		Log(playerList[i].p.PlayerReplicationInfo.PlayerName $ " = " $ playerList[i].s);

	if(!bRewardAllWeaks) //only the weakest player gets a suitable reward
	{
		bRewardAllWeaks = True;//next time
		bRewardAll = True;//but first reward all
		
		if(index == 2 || (playerList[index-2].s != 0.0 && playerList[index-1].s/playerList[index-2].s < 0.7))
		{
			activeReward = -1;
			
			if(playerList[index-1].s < avg * 0.55)
			{
				if(playerList[index-1].s < avg * 0.05)
					activeReward = 9;
				else if(playerList[index-1].s < avg * 0.17)
					activeReward = 8;
				else if(playerList[index-1].s < avg * 0.38)
					activeReward = 7;
				else //check is above
					activeReward = 6;
			}
			else
				return False;//abort
				
			//give
			if(playerList[index-1].p.bHidden || playerList[index-1].p.Health <= 0)
			{
				pendingReceivers[0] = playerList[index-1].p.PlayerReplicationInfo.PlayerID;
				maxPendingSeconds = Level.TimeSeconds + MAX_PENDING;//dead player: get reward at respawn within MAX_PENDING seconds
				Log("single - weak -> pending");
			}
			else
				GiveReward(playerList[index-1].p);
	
			//tell all
			BroadcastLocalizedMessage( class'bmessagesv02.rewardM');
			//tell weak player
			playerList[index-1].p.ClientMessage("You were rewarded!!",,True);
		}
		else //too little difference
			return False;
	}
	else //all weaks get Cat. I
	{
		bRewardAllWeaks = False;//next time
		
		avg *= 0.5;//upper limit
		activeReward = 11;
		j = 0;
		
		for(i = index - 1;i>0;i--)
		{
			//weak enough?
			if(playerList[i].s < avg)
			{
				playerList[i].r = True;//received reward
				//give
				if(playerList[i].p.bHidden || playerList[i].p.Health <= 0)
				{
					pendingReceivers[j++] = playerList[i].p.PlayerReplicationInfo.PlayerID;
				}
				else
					GiveReward(playerList[i].p);
					
				//&tell -> may motivate respawn
				playerList[i].p.ClientMessage("You were rewarded!!",, True);
			}
			else
				break;//strength exceeds limit
		}
		
		//tell
		if(playerList[index-1].r)//at least the weakest received
		{
			if(j != 0)
				maxPendingSeconds = Level.TimeSeconds + MAX_PENDING;//dead players: get reward at respawn within 5 seconds
			
			//tell all
			BroadcastLocalizedMessage( class'bmessagesv02.rewardM');
		}
		else 
			return False;//failed
	}

	return True;
}


//==========================
//AnnounceRewardToAll || just spreads the message preparing players
function AnnounceRewardToAll()
{
	switch(activeReward)
	{
		case 0:
			BroadcastLocalizedMessage(class'bmessagesv02.reedM');
			break;
		case 2:
			BroadcastLocalizedMessage(class'bmessagesv02.ampM');
			break;
	}
		
	//wait for DELAY to pass
	bDelayReward = True;
	SetTimer(DELAY, False);
}
//==========================

//SpreadPickups || randomly place pickups on botpath so everyone got the chance to pick them up
function SpreadPickups()
{
	Log("spreadpickups");
	
	
	Self.BroadcastMessage("Search the pickups", True, 'CriticalEvent');//'Event' (default), 'CriticalEvent', 'Say', 'TeamSay', 'DeathMessage', 'Pickup'
	
	placedOn[0] = -1;
	placedOn[1] = -1;
	placedOn[2] = -1;
	placedOn[3] = -1;
	placedOn[4] = -1;
	
	PlacePickup(class'WarHeadLauncher', 0);
	PlacePickup(class'WarHeadLauncher', 1);
	PlacePickup(class'WarHeadLauncher', 2);
	PlacePickup(class'UDamage', 3);
	PlacePickup(class'UT_Jumpboots', 4);
}
//==========================

//PlacePickup || places the specified pickup on a random PN; avoids double placings and checks for players near?
function PlacePickup(class<Inventory> PickupClass, int index)
{
	local int targetIndex, i;
	local bool bRetry;
	local Inventory inv;
	
	if(pn_count < 5)
	{
		Log("Only " $ pn_count $ " pns");
		return;
	}
	
	targetIndex = Rand(pn_count);
	while(True)
	{
		bRetry = False;
		for(i = 0; i < index; i++)
		{
			//in use
			if(placedOn[i] == targetIndex)
			{
				targetIndex = Rand(pn_count);
				bRetry = True;
				break;
			}
		}
		if(!bRetry)
			break;
	}
	
	inv = Level.Spawn(PickupClass, Self, , PN[targetIndex].Location, PN[targetIndex].Rotation);
	placedOn[i] = targetIndex;
	if(inv != None)
		inv.RespawnTime = 0.0;
	Log("placed " $ PickupClass $ " on " $ targetIndex);
}

//==========================
function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	
    if(Other.class == class'UT_Invisibility')
		return False;
        
	if(NextMutator != None)
		return NextMutator.CheckReplacement(Other, bSuperRelevant);
	else
		return True;
}

//==========================
defaultproperties
{
	bRewardAll=True
	bRewardAllWeaks=True
	DELAY=1.35
	MAX_PENDING=5
	time(0)=22.0
	time(1)=27.0
	time(2)=31.0
	time(3)=37.0
}